/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.TextField;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.util.EnumChatFormatting;

public class SearchField
extends TextField
implements ItemFilter.ItemFilterProvider {
    public static List<ISearchProvider> searchProviders = new LinkedList<ISearchProvider>();
    long lastclicktime;

    public SearchField(String ident) {
        super(ident);
        API.addItemFilter(this);
    }

    public static boolean searchInventories() {
        return NEIClientConfig.world.nbt.getBoolean("searchinventories");
    }

    @Override
    public void drawBox() {
        if (SearchField.searchInventories()) {
            GuiDraw.drawGradientRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)-256, (int)-4149248);
        } else {
            GuiDraw.drawRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)-6250336);
        }
        GuiDraw.drawRect((int)(this.x + 1), (int)(this.y + 1), (int)(this.w - 2), (int)(this.h - 2), (int)-16777216);
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (button == 0) {
            if (this.focused() && System.currentTimeMillis() - this.lastclicktime < 500L) {
                NEIClientConfig.world.nbt.setBoolean("searchinventories", !SearchField.searchInventories());
                NEIClientConfig.world.saveNBT();
            }
            this.lastclicktime = System.currentTimeMillis();
        }
        return super.handleClick(mousex, mousey, button);
    }

    @Override
    public void onTextChange(String oldText) {
        NEIClientConfig.setSearchExpression(this.text());
        ItemList.updateFilter.restart();
    }

    @Override
    public void lastKeyTyped(int keyID, char keyChar) {
        if (keyID == NEIClientConfig.getKeyBinding("gui.search")) {
            this.setFocus(true);
        }
    }

    @Override
    public String filterText(String s) {
        return EnumChatFormatting.getTextWithoutFormattingCodes((String)s);
    }

    @Override
    public ItemFilter getFilter() {
        String s_filter = this.text().toLowerCase();
        for (ISearchProvider p : searchProviders) {
            ItemFilter filter = p.getFilter(s_filter);
            if (filter == null) continue;
            return filter;
        }
        switch (NEIClientConfig.getIntSetting("inventory.searchmode")) {
            case 0: {
                s_filter = "\\Q" + s_filter + "\\E";
                break;
            }
            case 1: {
                s_filter = s_filter.replace(".", "").replace("?", ".").replace("*", ".+?");
            }
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(s_filter);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        if (pattern == null || pattern.toString().equals("")) {
            return new ItemList.EverythingItemFilter();
        }
        return new ItemList.PatternItemFilter(pattern);
    }

    public static interface ISearchProvider {
        public ItemFilter getFilter(String var1);
    }
}

