/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.nei.ItemPanel;
import codechicken.nei.config.DataDumper;
import codechicken.nei.guihook.GuiContainerManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;

public class ItemPanelDumper
extends DataDumper {
    public ItemPanelDumper(String name) {
        super(name);
    }

    @Override
    public String[] header() {
        return new String[]{"Item Name", "Item ID", "Item meta", "Has NBT", "Display Name"};
    }

    @Override
    public Iterable<String[]> dump(int mode) {
        LinkedList<String[]> list = new LinkedList<String[]>();
        for (ItemStack stack : ItemPanel.items) {
            list.add(new String[]{Item.itemRegistry.getNameForObject((Object)stack.getItem()), Integer.toString(Item.getIdFromItem((Item)stack.getItem())), Integer.toString(InventoryUtils.actualDamage((ItemStack)stack)), stack.stackTagCompound == null ? "false" : "true", EnumChatFormatting.getTextWithoutFormattingCodes((String)GuiContainerManager.itemDisplayNameShort(stack))});
        }
        return list;
    }

    @Override
    public String renderName() {
        return this.translateN(this.name, new Object[0]);
    }

    @Override
    public String getFileExtension() {
        switch (this.getMode()) {
            case 0: {
                return ".csv";
            }
            case 1: {
                return ".nbt";
            }
            case 2: {
                return ".json";
            }
        }
        return null;
    }

    public ChatComponentTranslation dumpMessage(File file) {
        return new ChatComponentTranslation(this.namespaced(this.name + ".dumped"), new Object[]{"dumps/" + file.getName()});
    }

    @Override
    public String modeButtonText() {
        return this.translateN(this.name + ".mode." + this.getMode(), new Object[0]);
    }

    @Override
    public void dumpTo(File file) throws IOException {
        if (this.getMode() == 0) {
            super.dumpTo(file);
        } else if (this.getMode() == 1) {
            this.dumpNBT(file);
        } else {
            this.dumpJson(file);
        }
    }

    public void dumpNBT(File file) throws IOException {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : ItemPanel.items) {
            list.appendTag((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.setTag("list", (NBTBase)list);
        CompressedStreamTools.writeCompressed((NBTTagCompound)tag, (OutputStream)new FileOutputStream(file));
    }

    public void dumpJson(File file) throws IOException {
        PrintWriter p = new PrintWriter(file);
        for (ItemStack stack : ItemPanel.items) {
            NBTTagCompound tag = stack.writeToNBT(new NBTTagCompound());
            tag.removeTag("Count");
            p.println(tag);
        }
        p.close();
    }

    @Override
    public int modeCount() {
        return 3;
    }
}

