/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.config.ConfigTag;
import codechicken.nei.config.ConfigSet;
import codechicken.nei.config.GuiOptionList;
import codechicken.nei.config.OptionList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public abstract class Option {
    public GuiOptionList.OptionScrollSlot slot;
    public String namespace = null;
    public final String name;
    public OptionList parent;

    public static void playClickSound() {
        Minecraft.getMinecraft().getSoundHandler().playSound((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
    }

    public Option(String name) {
        this.name = name;
    }

    public String fullName() {
        return this.namespaced(this.name);
    }

    public String configName() {
        return this.fullName().substring(this.configBase().fullName().length() + 1);
    }

    public String namespaced(String name) {
        return this.namespace == null ? name : this.namespace + "." + name;
    }

    public String translateN(String s, Object ... args) {
        return StatCollector.translateToLocalFormatted((String)this.namespaced(s), (Object[])args);
    }

    public int getHeight() {
        return 20;
    }

    private <T> T assertParentOverride(T elem) {
        if (elem == null) {
            throw new IllegalStateException("Option " + this.fullName() + " does not have a defined parent list. Use OptionList.setOptionList to insert a parent");
        }
        return elem;
    }

    public ConfigSet globalConfigSet() {
        return this.assertParentOverride(this.parent.globalConfigSet());
    }

    public ConfigSet worldConfigSet() {
        return this.assertParentOverride(this.parent.worldConfigSet());
    }

    public OptionList configBase() {
        return this.assertParentOverride(this.parent.configBase());
    }

    public boolean worldSpecific() {
        return this.worldSpecific(this.configName());
    }

    public boolean worldSpecific(String s) {
        return this.worldConfigSet().config.containsTag(s);
    }

    public ConfigSet configSet() {
        return this.worldConfig() ? this.worldConfigSet() : this.globalConfigSet();
    }

    public ConfigTag renderTag() {
        return this.renderTag(this.configName());
    }

    public ConfigTag renderTag(String s) {
        return (this.worldConfig() && this.worldSpecific((String)s) ? this.worldConfigSet() : this.globalConfigSet()).config.getTag(s);
    }

    public ConfigTag getTag() {
        return this.getTag(this.configName());
    }

    public ConfigTag getTag(String s) {
        return this.configSet().config.getTag(s);
    }

    public boolean worldConfig() {
        return this.slot.getGui().worldConfig();
    }

    public boolean defaulting() {
        return this.defaulting(this.configName());
    }

    public boolean defaulting(String s) {
        return this.worldConfig() && !this.worldSpecific(s);
    }

    public void useGlobals() {
        this.useGlobal(this.configName());
    }

    public void useGlobal(String s) {
        if (this.worldConfig()) {
            this.worldConfigSet().config.removeTag(s);
        }
    }

    public void copyGlobals() {
        this.copyGlobal(this.configName());
    }

    public void copyGlobal(String s) {
        this.copyGlobal(s, false);
    }

    public void copyGlobal(String s, boolean recursive) {
        if (!this.worldConfig()) {
            return;
        }
        ConfigTag tag = this.globalConfigSet().config.getTag(s);
        this.worldConfigSet().config.getTag(s).setValue(tag.getValue());
        if (recursive) {
            for (String s2 : tag.childTagMap().keySet()) {
                this.copyGlobal(s + "." + s2);
            }
        }
    }

    public void onAdded(GuiOptionList.OptionScrollSlot slot) {
        this.slot = slot;
    }

    public void onAdded(OptionList list) {
        this.parent = list;
    }

    public void onMouseClicked(int mx, int my, int button) {
    }

    public void mouseClicked(int mx, int my, int button) {
    }

    public void update() {
    }

    public void draw(int mx, int my, float frame) {
    }

    public void keyTyped(char c, int keycode) {
    }

    public List<String> handleTooltip(int mx, int my, List<String> currenttip) {
        return currenttip;
    }

    public boolean showWorldSelector() {
        return true;
    }

    public boolean hasWorldOverride() {
        return this.worldSpecific();
    }
}

