/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;

public class FurnaceRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static HashSet<Block> efuels;

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "smelting", new Object[0]));
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFurnace.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.furnace", new Object[0]);
    }

    @Override
    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            FurnaceRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("smelting") && this.getClass() == FurnaceRecipeHandler.class) {
            Map recipes = FurnaceRecipes.smelting().getSmeltingList();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        Map recipes = FurnaceRecipes.smelting().getSmeltingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getValue(), result)) continue;
            this.arecipes.add(new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && this.getClass() == FurnaceRecipeHandler.class) {
            this.loadCraftingRecipes("smelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = FurnaceRecipes.smelting().getSmeltingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getKey(), ingredient)) continue;
            SmeltingPair arecipe = new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/furnace.png";
    }

    @Override
    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.getItemFromBlock((Block)Blocks.brown_mushroom));
        efuels.add(Item.getItemFromBlock((Block)Blocks.red_mushroom));
        efuels.add(Item.getItemFromBlock((Block)Blocks.standing_sign));
        efuels.add(Item.getItemFromBlock((Block)Blocks.wall_sign));
        efuels.add(Item.getItemFromBlock((Block)Blocks.wooden_door));
        efuels.add(Item.getItemFromBlock((Block)Blocks.trapped_chest));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = FurnaceRecipeHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (efuels.contains(item.getItem()) || (burnTime = TileEntityFurnace.getItemBurnTime((ItemStack)item)) <= 0) continue;
            afuels.add(new FuelPair(item.copy(), burnTime));
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "smelting";
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack(ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public SmeltingPair(ItemStack ingred, ItemStack result) {
            ingred.stackSize = 1;
            this.ingred = new PositionedStack(ingred, 51, 6);
            this.result = new PositionedStack(result, 111, 24);
        }

        @Override
        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(FurnaceRecipeHandler.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        @Override
        public PositionedStack getOtherStack() {
            return FurnaceRecipeHandler.afuels.get((int)(FurnaceRecipeHandler.this.cycleticks / 48 % FurnaceRecipeHandler.afuels.size())).stack;
        }
    }
}

