/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.render.CCRenderState;
import codechicken.nei.ContainerEnchantmentModifier;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiEnchantmentModifier
extends GuiContainer {
    ContainerEnchantmentModifier container;

    public GuiEnchantmentModifier(InventoryPlayer inventoryplayer, World world, int i, int j, int k) {
        super((Container)new ContainerEnchantmentModifier(inventoryplayer, world, i, j, k));
        this.container = (ContainerEnchantmentModifier)this.inventorySlots;
        this.container.parentscreen = this;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRendererObj.drawString(NEIClientUtils.translate("enchant", new Object[0]), 12, 6, 0x404040);
        this.fontRendererObj.drawString(NEIClientUtils.translate("enchant.level", new Object[0]), 19, 20, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CCRenderState.changeTexture((String)"textures/gui/container/enchanting_table.png");
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawTexturedModalRect(0, 0, 0, 0, this.xSize, this.ySize);
        this.container.onUpdate(i, j);
        this.container.drawSlots(this);
        this.container.drawScrollBar(this);
        String levelstring = "" + this.container.level;
        this.fontRendererObj.drawString(levelstring, 33 - this.fontRendererObj.getStringWidth(levelstring) / 2, 34, -10461088);
        GL11.glTranslatef((float)(-this.guiLeft), (float)(-this.guiTop), (float)0.0f);
    }

    public void initGui() {
        super.initGui();
        this.buttonList.add(new GuiNEIButton(0, this.width / 2 - 78, this.height / 2 - 52, 12, 12, "<"));
        this.buttonList.add(new GuiNEIButton(1, this.width / 2 - 44, this.height / 2 - 52, 12, 12, ">"));
        this.buttonList.add(new GuiNEIButton(2, this.width / 2 - 80, this.height / 2 - 15, 50, 12, this.lockDisplayString()));
    }

    private String lockDisplayString() {
        return GuiEnchantmentModifier.validateEnchantments() ? NEIClientUtils.translate("enchant.locked", new Object[0]) : NEIClientUtils.translate("enchant.unlocked", new Object[0]);
    }

    public static boolean validateEnchantments() {
        return NEIClientConfig.world.nbt.getBoolean("validateenchantments");
    }

    public static void toggleEnchantmentValidation() {
        NEIClientConfig.world.nbt.setBoolean("validateenchantments", !GuiEnchantmentModifier.validateEnchantments());
        NEIClientConfig.world.saveNBT();
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton.id == 0) {
            this.changeLevel(-1);
        } else if (guibutton.id == 1) {
            this.changeLevel(1);
        } else if (guibutton.id == 2) {
            GuiEnchantmentModifier.toggleEnchantmentValidation();
            this.container.updateEnchantmentOptions(GuiEnchantmentModifier.validateEnchantments());
            guibutton.displayString = this.lockDisplayString();
        }
    }

    private void changeLevel(int i) {
        this.container.level += i;
        ((GuiButton)this.buttonList.get((int)0)).enabled = this.container.level != 1;
        ((GuiButton)this.buttonList.get((int)1)).enabled = this.container.level != 10;
    }

    protected void mouseClicked(int i, int j, int k) {
        if (this.container.clickButton(i, j, k)) {
            return;
        }
        if (this.container.clickScrollBar(i, j, k)) {
            return;
        }
        super.mouseClicked(i, j, k);
    }

    protected void mouseMovedOrUp(int i, int j, int k) {
        this.container.mouseUp(i, j, k);
        super.mouseMovedOrUp(i, j, k);
    }

    public FontRenderer getFontRenderer() {
        return this.fontRendererObj;
    }
}

