/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemStackMap;
import codechicken.nei.api.ItemFilter;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackSet
extends ItemStackMap<ItemStack>
implements ItemFilter {
    public ItemStackSet with(ItemStack ... items) {
        for (ItemStack item : items) {
            this.add(item);
        }
        return this;
    }

    public ItemStackSet with(Item ... items) {
        for (Item item : items) {
            this.add(ItemStackMap.wildcard(item));
        }
        return this;
    }

    public ItemStackSet with(Block ... blocks) {
        for (Block block : blocks) {
            this.add(ItemStackMap.wildcard(Item.getItemFromBlock((Block)block)));
        }
        return this;
    }

    public void add(ItemStack item) {
        this.put(item, item);
    }

    public boolean contains(ItemStack item) {
        return this.get(item) != null;
    }

    public boolean containsAll(Item item) {
        return this.get(ItemStackMap.wildcard(item)) != null;
    }

    @Override
    public boolean matches(ItemStack item) {
        return this.contains(item);
    }

    public static ItemStackSet of(Block ... blocks) {
        return new ItemStackSet().with(blocks);
    }

    public static ItemStackSet of(Item ... items) {
        return new ItemStackSet().with(items);
    }

    public static ItemStackSet of(ItemStack ... items) {
        return new ItemStackSet().with(items);
    }
}

