/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PositionedStack {
    public int relx;
    public int rely;
    public ItemStack[] items;
    public ItemStack item;
    private boolean permutated = false;

    public PositionedStack(Object object, int x, int y, boolean genPerms) {
        this.items = NEIServerUtils.extractRecipeItems(object);
        this.relx = x;
        this.rely = y;
        if (genPerms) {
            this.generatePermutations();
        } else {
            this.setPermutationToRender(0);
        }
    }

    public PositionedStack(Object object, int x, int y) {
        this(object, x, y, true);
    }

    public void generatePermutations() {
        if (this.permutated) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            if (item == null || item.getItem() == null) continue;
            if (item.getItemDamage() == Short.MAX_VALUE) {
                List permutations = ItemList.itemMap.get((Object)item.getItem());
                if (!permutations.isEmpty()) {
                    for (ItemStack stack : permutations) {
                        stacks.add(stack.copy());
                    }
                    continue;
                }
                ItemStack base = new ItemStack(item.getItem(), item.stackSize);
                base.stackTagCompound = item.stackTagCompound;
                stacks.add(base);
                continue;
            }
            stacks.add(item.copy());
        }
        this.items = stacks.toArray(new ItemStack[0]);
        if (this.items.length == 0) {
            this.items = new ItemStack[]{new ItemStack((Block)Blocks.fire)};
        }
        this.permutated = true;
        this.setPermutationToRender(0);
    }

    public void setMaxSize(int i) {
        for (ItemStack item : this.items) {
            if (item.stackSize <= i) continue;
            item.stackSize = i;
        }
    }

    public PositionedStack copy() {
        return new PositionedStack(this.items, this.relx, this.rely);
    }

    public void setPermutationToRender(int index) {
        this.item = this.items[index].copy();
        if (this.item.getItem() == null) {
            this.item = new ItemStack((Block)Blocks.fire);
        } else if (this.item.getItemDamage() == Short.MAX_VALUE) {
            this.item.setItemDamage(0);
        }
    }

    public boolean contains(ItemStack ingredient) {
        for (ItemStack item : this.items) {
            if (!NEIServerUtils.areStacksSameTypeCrafting(item, ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Item ingred) {
        for (ItemStack item : this.items) {
            if (item.getItem() != ingred) continue;
            return true;
        }
        return false;
    }
}

