/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiScrollSlot;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemList;
import codechicken.nei.ItemStackSet;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.RestartableTask;
import codechicken.nei.SearchField;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.guihook.GuiContainerManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;

public class SubsetWidget
extends Button
implements ItemFilter.ItemFilterProvider,
ItemList.ItemsLoadedCallback,
SearchField.ISearchProvider {
    protected static final SubsetTag root = new SubsetTag(null);
    public static Rectangle4i area = new Rectangle4i();
    public static ItemStack hoverStack;
    private static HashMap<String, SubsetState> subsetState;
    private static final ItemStackSet hiddenItems;
    private static final AtomicReference<NBTTagList> dirtyHiddenItems;
    private static final RestartableTask prepareDirtyHiddenItems;
    private static final UpdateStateTask updateState;
    private long lastclicktime;

    public static SubsetState getState(SubsetTag tag) {
        SubsetState state = subsetState.get(tag.fullname);
        return state == null ? new SubsetState() : state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTag(SubsetTag tag) {
        updateState.stop();
        SubsetTag subsetTag = root;
        synchronized (subsetTag) {
            SubsetWidget.root.addTag(tag);
            updateState.reallocate();
        }
    }

    public static SubsetTag getTag(String name) {
        return name == null ? root : SubsetWidget.root.getTag(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHidden(ItemStack item) {
        ItemStackSet itemStackSet = hiddenItems;
        synchronized (itemStackSet) {
            return hiddenItems.contains(item);
        }
    }

    private static void _setHidden(SubsetTag tag, boolean hidden) {
        for (ItemStack item : SubsetWidget.getState((SubsetTag)tag).items) {
            SubsetWidget._setHidden(item, hidden);
        }
        for (SubsetTag child : tag.sorted) {
            SubsetWidget._setHidden(child, hidden);
        }
    }

    private static void _setHidden(ItemStack item, boolean hidden) {
        if (hidden) {
            hiddenItems.add(item);
        } else {
            hiddenItems.remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showOnly(SubsetTag tag) {
        ItemStackSet itemStackSet = hiddenItems;
        synchronized (itemStackSet) {
            for (ItemStack item : ItemList.items) {
                SubsetWidget._setHidden(item, true);
            }
            SubsetWidget.setHidden(tag, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHidden(SubsetTag tag, boolean hidden) {
        ItemStackSet itemStackSet = hiddenItems;
        synchronized (itemStackSet) {
            SubsetWidget._setHidden(tag, hidden);
            SubsetWidget.updateHiddenItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHidden(ItemStack item, boolean hidden) {
        ItemStackSet itemStackSet = hiddenItems;
        synchronized (itemStackSet) {
            SubsetWidget._setHidden(item, hidden);
            SubsetWidget.updateHiddenItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unhideAll() {
        ItemStackSet itemStackSet = hiddenItems;
        synchronized (itemStackSet) {
            hiddenItems.clear();
            SubsetWidget.updateHiddenItems();
        }
    }

    private static void updateHiddenItems() {
        prepareDirtyHiddenItems.restart();
        updateState.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadHidden() {
        ItemStackSet itemStackSet = hiddenItems;
        synchronized (itemStackSet) {
            hiddenItems.clear();
        }
        LinkedList<ItemStack> itemList = new LinkedList<ItemStack>();
        try {
            NBTTagList list = NEIClientConfig.world.nbt.getTagList("hiddenItems", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                itemList.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)list.getCompoundTagAt(i)));
            }
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading hiddenItems", (Throwable)e);
            return;
        }
        ItemStackSet itemStackSet2 = hiddenItems;
        synchronized (itemStackSet2) {
            for (ItemStack item : itemList) {
                hiddenItems.add(item);
            }
        }
        updateState.restart();
    }

    private static void saveHidden() {
        NBTTagList list = dirtyHiddenItems.getAndSet(null);
        if (list != null) {
            NEIClientConfig.world.nbt.setTag("hiddenItems", (NBTBase)list);
            NEIClientConfig.world.saveNBT();
        }
    }

    public SubsetWidget() {
        super("NEI Subsets");
        API.addItemFilter(this);
        API.addSearchProvider(this);
        ItemList.loadCallbacks.add(this);
    }

    @Override
    public void draw(int mx, int my) {
        super.draw(mx, my);
        area.set(this.x, this.y + this.h, this.w, LayoutManager.searchField.y - this.h - this.y);
        hoverStack = null;
        if (root.isVisible()) {
            root.resize(SubsetWidget.area.x, 0, SubsetWidget.area.y);
            root.cacheState();
            root.draw(mx, my);
        }
    }

    @Override
    public void update() {
        Point mouse = GuiDraw.getMousePosition();
        this.updateVisiblity(mouse.x, mouse.y);
        SubsetWidget.saveHidden();
    }

    private void updateVisiblity(int mx, int my) {
        if (!root.isVisible() || root.isScrolling()) {
            return;
        }
        root.updateVisiblity(mx, my);
        if (!root.isVisible() && this.bounds().contains(mx, my)) {
            root.setVisible();
        }
    }

    @Override
    public boolean contains(int px, int py) {
        return super.contains(px, py) || root.isVisible() && root.contains(px, py);
    }

    @Override
    public boolean handleClick(int mx, int my, int button) {
        if (root.isVisible() && root.contains(mx, my)) {
            root.mouseClicked(mx, my, button);
            return true;
        }
        if (button == 0) {
            if (System.currentTimeMillis() - this.lastclicktime < 500L) {
                SubsetWidget.unhideAll();
            } else {
                root.setVisible();
            }
            NEIClientUtils.playClickSound();
            this.lastclicktime = System.currentTimeMillis();
        }
        return true;
    }

    @Override
    public boolean onButtonPress(boolean rightclick) {
        return false;
    }

    @Override
    public void mouseDragged(int mx, int my, int button, long heldTime) {
        if (root.isVisible()) {
            root.mouseDragged(mx, my, button, heldTime);
        }
    }

    @Override
    public void mouseUp(int mx, int my, int button) {
        if (root.isVisible()) {
            root.mouseUp(mx, my, button);
        }
    }

    @Override
    public boolean onMouseWheel(int i, int mx, int my) {
        return root.isVisible() && root.mouseScrolled(mx, my, -i);
    }

    @Override
    public void onGuiClick(int mx, int my) {
        if (!this.contains(mx, my)) {
            root.setHidden();
        }
    }

    @Override
    public ItemStack getStackMouseOver(int mx, int my) {
        return hoverStack;
    }

    @Override
    public ItemFilter getFilter() {
        return new ItemFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean matches(ItemStack item) {
                ItemStackSet itemStackSet = hiddenItems;
                synchronized (itemStackSet) {
                    return !hiddenItems.matches(item);
                }
            }
        };
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public ItemFilter getFilter(String searchText) {
        if (!searchText.startsWith("@")) {
            return null;
        }
        searchText = searchText.substring(1);
        ItemList.AnyMultiItemFilter filter = new ItemList.AnyMultiItemFilter();
        SubsetTag tag = SubsetWidget.getTag(searchText);
        if (tag != null) {
            tag.addFilters(filter.filters);
        } else {
            Pattern p = SearchField.getPattern(searchText);
            if (p == null) {
                return null;
            }
            LinkedList<SubsetTag> matching = new LinkedList<SubsetTag>();
            root.search(matching, p);
            if (matching.isEmpty()) {
                return null;
            }
            for (SubsetTag tag2 : matching) {
                tag2.addFilters(filter.filters);
            }
        }
        return filter;
    }

    @Override
    public void itemsLoaded() {
        updateState.reallocate();
    }

    static {
        subsetState = new HashMap();
        hiddenItems = new ItemStackSet();
        dirtyHiddenItems = new AtomicReference();
        prepareDirtyHiddenItems = new RestartableTask("NEI Subset Save Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List<ItemStack> getList() {
                ItemStackSet itemStackSet = hiddenItems;
                synchronized (itemStackSet) {
                    return hiddenItems.values();
                }
            }

            @Override
            public void execute() {
                NBTTagList list = new NBTTagList();
                for (ItemStack item : this.getList()) {
                    if (this.interrupted()) {
                        return;
                    }
                    NBTTagCompound tag = new NBTTagCompound();
                    item.writeToNBT(tag);
                    list.appendTag((NBTBase)tag);
                }
                dirtyHiddenItems.set(list);
            }
        };
        updateState = new UpdateStateTask();
    }

    private static class UpdateStateTask
    extends RestartableTask {
        private volatile boolean reallocate;

        public UpdateStateTask() {
            super("NEI Subset Item Allocation");
        }

        @Override
        public void clearTasks() {
            super.clearTasks();
            this.reallocate = false;
        }

        public synchronized void reallocate() {
            this.reallocate = true;
            this.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            HashMap<String, SubsetState> state = new HashMap<String, SubsetState>();
            LinkedList<SubsetTag> tags = new LinkedList<SubsetTag>();
            SubsetTag subsetTag = root;
            synchronized (subsetTag) {
                this.cloneStates(root, tags, state);
                if (this.interrupted()) {
                    return;
                }
            }
            if (this.reallocate) {
                for (ItemStack item : ItemList.items) {
                    if (this.interrupted()) {
                        return;
                    }
                    if (ItemInfo.isHidden(item)) continue;
                    for (SubsetTag tag : tags) {
                        if (!tag.filter.matches(item)) continue;
                        state.get((Object)tag.fullname).items.add(item);
                    }
                }
            }
            subsetTag = root;
            synchronized (subsetTag) {
                this.calculateVisibility(root, state);
                if (this.interrupted()) {
                    return;
                }
            }
            subsetState = state;
            ItemList.updateFilter.restart();
        }

        private void cloneStates(SubsetTag tag, List<SubsetTag> tags, HashMap<String, SubsetState> state) {
            for (SubsetTag child : tag.sorted) {
                if (this.interrupted()) {
                    return;
                }
                this.cloneStates(child, tags, state);
            }
            tags.add(tag);
            SubsetState sstate = new SubsetState();
            if (!this.reallocate) {
                sstate.items = SubsetWidget.getState((SubsetTag)tag).items;
            }
            state.put(tag.fullname, sstate);
        }

        private void calculateVisibility(SubsetTag tag, Map<String, SubsetState> state) {
            SubsetState sstate = state.get(tag.fullname);
            int hidden = 0;
            for (SubsetTag child : tag.sorted) {
                if (this.interrupted()) {
                    return;
                }
                this.calculateVisibility(child, state);
                int cstate = state.get((Object)child.fullname).state;
                if (cstate == 1) {
                    sstate.state = 1;
                    continue;
                }
                if (cstate != 0) continue;
                ++hidden;
            }
            if (sstate.state == 1) {
                return;
            }
            ArrayList<ItemStack> items = sstate.items;
            for (ItemStack item : items) {
                if (this.interrupted()) {
                    return;
                }
                if (!SubsetWidget.isHidden(item)) continue;
                ++hidden;
            }
            if (hidden == tag.sorted.size() + items.size()) {
                sstate.state = 0;
            } else if (hidden > 0) {
                sstate.state = 1;
            }
        }
    }

    public static class SubsetTag {
        public final String fullname;
        public final ItemFilter filter;
        public TreeMap<String, SubsetTag> children = new TreeMap();
        public List<SubsetTag> sorted = Collections.emptyList();
        private int childwidth;
        protected String displayName;
        protected SubsetState state = new SubsetState();
        protected final SubsetSlot slot = new SubsetSlot();
        private SubsetTag selectedChild;
        private int visible;

        public SubsetTag(String fullname) {
            this(fullname, new ItemList.NothingItemFilter());
        }

        public SubsetTag(String fullname, ItemFilter filter) {
            assert (filter != null) : "Filter cannot be null";
            this.fullname = EnumChatFormatting.getTextWithoutFormattingCodes((String)fullname);
            this.filter = filter;
            if (fullname != null) {
                int idx = fullname.lastIndexOf(46);
                this.displayName = idx < 0 ? fullname : fullname.substring(idx + 1);
            }
        }

        public String displayName() {
            return this.displayName;
        }

        public String name() {
            int idx = this.fullname.indexOf(46);
            return idx < 0 ? this.fullname : this.fullname.substring(idx + 1);
        }

        public String parent() {
            int idx = this.fullname.lastIndexOf(46);
            return idx < 0 ? null : this.fullname.substring(0, idx);
        }

        private SubsetTag getTag(String name) {
            int idx = name.indexOf(46);
            String childname = idx > 0 ? name.substring(0, idx) : name;
            SubsetTag child = this.children.get(childname.toLowerCase());
            if (child == null) {
                return null;
            }
            return idx > 0 ? child.getTag(name.substring(idx + 1)) : child;
        }

        private void recacheChildren() {
            this.sorted = new ArrayList<SubsetTag>(this.children.values());
            this.childwidth = 0;
            for (SubsetTag tag : this.sorted) {
                this.childwidth = Math.max(this.childwidth, tag.nameWidth() + 2);
            }
        }

        private void addTag(SubsetTag tag) {
            String name = this.fullname == null ? tag.fullname : tag.fullname.substring(this.fullname.length() + 1);
            int idx = name.indexOf(46);
            if (idx < 0) {
                SubsetTag prev = this.children.put(name.toLowerCase(), tag);
                if (prev != null) {
                    tag.children = prev.children;
                    tag.sorted = prev.sorted;
                }
                this.recacheChildren();
            } else {
                String childname = name.substring(0, idx);
                SubsetTag child = this.children.get(childname.toLowerCase());
                if (child == null) {
                    child = new SubsetTag(this.fullname == null ? childname : this.fullname + '.' + childname);
                    this.children.put(childname.toLowerCase(), child);
                }
                this.recacheChildren();
                child.addTag(tag);
            }
        }

        protected void cacheState() {
            this.state = SubsetWidget.getState(this);
            for (SubsetTag tag : this.sorted) {
                tag.cacheState();
            }
        }

        public void addFilters(List<ItemFilter> filters) {
            if (this.filter != null) {
                filters.add(this.filter);
            }
            for (SubsetTag child : this.sorted) {
                child.addFilters(filters);
            }
        }

        public void search(List<SubsetTag> tags, Pattern p) {
            if (this.fullname != null && p.matcher(this.fullname.toLowerCase()).find()) {
                tags.add(this);
            } else {
                for (SubsetTag child : this.sorted) {
                    child.search(tags, p);
                }
            }
        }

        public void updateVisiblity(int mx, int my) {
            if (this.selectedChild != null) {
                this.selectedChild.updateVisiblity(mx, my);
                if (!this.selectedChild.isVisible()) {
                    this.selectedChild = null;
                }
            }
            if (this.slot.contains(mx, my) && (this.selectedChild == null || !this.selectedChild.contains(mx, my))) {
                SubsetTag mtag;
                int mslot = this.slot.getClickedSlot(my);
                if (mslot >= 0 && mslot < this.sorted.size() && (mtag = this.sorted.get(mslot)) != null) {
                    if (mtag != this.selectedChild && this.selectedChild != null) {
                        this.selectedChild.setHidden();
                    }
                    this.selectedChild = mtag;
                    this.selectedChild.setVisible();
                }
                this.setVisible();
            }
            if (this.selectedChild == null) {
                this.countdownVisible();
            }
        }

        public void setHidden() {
            this.visible = 0;
            this.slot.mouseMovedOrUp(0, 0, 0);
            if (this.selectedChild != null) {
                this.selectedChild.setHidden();
                this.selectedChild = null;
            }
        }

        public void setVisible() {
            this.visible = 10;
            this.cacheState();
        }

        private void countdownVisible() {
            if (this.visible > 0 && --this.visible == 0) {
                this.setHidden();
            }
        }

        public void resize(int x, int pwidth, int y) {
            boolean fitRight;
            int cheight;
            int mheight = SubsetWidget.area.h;
            int dheight = area.y2() - y;
            int height = cheight = this.slot.contentHeight();
            if (cheight > mheight) {
                y = SubsetWidget.area.y;
                height = mheight;
            } else if (cheight > dheight) {
                y = area.y2() - cheight;
            }
            height = height / this.slot.getSlotHeight(0) * this.slot.getSlotHeight(0);
            int width = this.childwidth;
            if (!this.state.items.isEmpty()) {
                width = Math.max(this.childwidth, 18);
            }
            if (this.slot.contentHeight() > height) {
                width += this.slot.scrollbarDim().width;
            }
            boolean fitLeft = x - width >= area.x1();
            boolean bl = fitRight = x + width + pwidth <= area.x2();
            if (pwidth >= 0 ? !fitRight && fitLeft : !fitLeft) {
                pwidth *= -1;
            }
            this.slot.setSize(x += pwidth >= 0 ? pwidth : -width, y, width, height);
            this.slot.setMargins(this.slot.hasScrollbar() ? this.slot.scrollbarDim().width : 0, 0, 0, 0);
            if (this.selectedChild != null) {
                y = this.slot.getSlotY(this.sorted.indexOf(this.selectedChild)) - this.slot.scrolledPixels() + this.slot.y;
                this.selectedChild.resize(x, pwidth >= 0 ? width : -width, y);
            }
        }

        protected int nameWidth() {
            return Minecraft.getMinecraft().fontRenderer.getStringWidth(this.displayName());
        }

        public boolean isVisible() {
            return this.visible > 0;
        }

        public void draw(int mx, int my) {
            this.slot.draw(mx, my, 0.0f);
            if (this.selectedChild != null) {
                this.selectedChild.draw(mx, my);
            }
        }

        public boolean contains(int px, int py) {
            return this.slot.contains(px, py) || this.selectedChild != null && this.selectedChild.contains(px, py);
        }

        public void mouseClicked(int mx, int my, int button) {
            if (this.selectedChild != null && this.selectedChild.contains(mx, my)) {
                this.selectedChild.mouseClicked(mx, my, button);
            } else if (this.slot.contains(mx, my)) {
                this.slot.mouseClicked(mx, my, button);
            }
        }

        public void mouseDragged(int mx, int my, int button, long heldTime) {
            this.slot.mouseDragged(mx, my, button, heldTime);
            if (this.selectedChild != null) {
                this.selectedChild.mouseDragged(mx, my, button, heldTime);
            }
        }

        public void mouseUp(int mx, int my, int button) {
            this.slot.mouseMovedOrUp(mx, my, button);
            if (this.selectedChild != null) {
                this.selectedChild.mouseUp(mx, my, button);
            }
        }

        public boolean mouseScrolled(int mx, int my, int scroll) {
            if (this.slot.hasScrollbar() && this.slot.contains(mx, my)) {
                this.slot.scroll(scroll);
                return true;
            }
            if (this.selectedChild != null && this.selectedChild.mouseScrolled(mx, my, scroll)) {
                return true;
            }
            if (this.slot.hasScrollbar() && !this.contains(mx, my)) {
                this.slot.scroll(scroll);
                return true;
            }
            return false;
        }

        public boolean isScrolling() {
            return this.slot.isScrolling() || this.selectedChild != null && this.selectedChild.isScrolling();
        }

        protected class SubsetSlot
        extends GuiScrollSlot {
            public SubsetSlot() {
                super(0, 0, 0, 0);
                this.setSmoothScroll(false);
            }

            public int getSlotHeight(int slot) {
                return 18;
            }

            protected int getNumSlots() {
                return SubsetTag.this.children.size() + SubsetTag.this.state.items.size();
            }

            protected void slotClicked(int slot, int button, int mx, int my, int count) {
                if (slot < SubsetTag.this.sorted.size()) {
                    SubsetTag tag = SubsetTag.this.sorted.get(slot);
                    if (NEIClientUtils.shiftKey()) {
                        LayoutManager.searchField.setText("@" + tag.fullname);
                    } else if (button == 0 && count >= 2) {
                        SubsetWidget.showOnly(tag);
                    } else {
                        SubsetWidget.setHidden(tag, button == 1);
                    }
                } else {
                    ItemStack item = SubsetTag.this.state.items.get(slot - SubsetTag.this.sorted.size());
                    if (NEIClientUtils.controlKey()) {
                        NEIClientUtils.cheatItem(item, button, -1);
                    } else {
                        SubsetWidget.setHidden(SubsetTag.this.state.items.get(slot - SubsetTag.this.sorted.size()), button == 1);
                    }
                }
            }

            protected void drawSlot(int slot, int x, int y, int mx, int my, float frame) {
                int w = this.windowBounds().width;
                Rectangle4i r = new Rectangle4i(x, y, w, this.getSlotHeight(slot));
                if (slot < SubsetTag.this.sorted.size()) {
                    SubsetTag tag = SubsetTag.this.sorted.get(slot);
                    LayoutManager.getLayoutStyle().drawSubsetTag(tag.displayName(), x, y, r.w, r.h, tag.state.state, r.contains(mx, my));
                } else {
                    ItemStack stack = SubsetTag.this.state.items.get(slot - SubsetTag.this.sorted.size());
                    boolean hidden = SubsetWidget.isHidden(stack);
                    int itemx = w / 2 - 8;
                    int itemy = 1;
                    LayoutManager.getLayoutStyle().drawSubsetTag(null, x, y, r.w, r.h, hidden ? 0 : 2, false);
                    GuiContainerManager.drawItem(x + itemx, y + itemy, stack);
                    if (new Rectangle4i(itemx, itemy, 16, 16).contains(mx, my)) {
                        hoverStack = stack;
                    }
                }
            }

            public void drawOverlay(float frame) {
            }

            public void drawBackground(float frame) {
                SubsetSlot.drawRect((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-14671840);
            }

            public int scrollbarAlignment() {
                return -1;
            }

            public void drawScrollbar(float frame) {
                if (this.hasScrollbar()) {
                    super.drawScrollbar(frame);
                }
            }

            public int scrollbarGuideAlignment() {
                return 0;
            }
        }
    }

    public static class SubsetState {
        int state = 2;
        ArrayList<ItemStack> items = new ArrayList();
    }
}

