/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiCCTextField;
import codechicken.core.gui.GuiScrollSlot;
import codechicken.core.gui.GuiWidget;
import codechicken.core.inventory.GuiContainerWidget;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.FontUtils;
import codechicken.nei.ContainerPotionCreator;
import codechicken.nei.NEIClientUtils;
import java.awt.Dimension;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiPotionCreator
extends GuiContainerWidget {
    int amplifier = 0;
    GuiCCButton ampDown;
    GuiCCButton ampUp;
    GuiSlotPotionEffects slotPotionEffects;
    GuiDurationField durationField;
    ContainerPotionCreator container = (ContainerPotionCreator)this.inventorySlots;

    public GuiPotionCreator(InventoryPlayer inventoryplayer) {
        super((Container)new ContainerPotionCreator(inventoryplayer, (IInventory)new ContainerPotionCreator.InventoryPotionStore()), 176, 208);
    }

    public void applyEffect() {
        if (this.slotPotionEffects.selectedslot >= 0) {
            this.container.setPotionEffect(this.slotPotionEffects.selectedPotion(), this.durationField.getDurationTicks(), this.amplifier);
        }
    }

    public String translateAmplifier(int amplifier) {
        switch (amplifier) {
            case 0: {
                return "I";
            }
            case 1: {
                return "II";
            }
            case 2: {
                return "III";
            }
            case 3: {
                return "IV";
            }
            case 4: {
                return "V";
            }
        }
        return Integer.toString(amplifier);
    }

    public void validateInputButtons() {
        this.ampDown.setEnabled(this.amplifier > 0);
        this.ampUp.setEnabled(this.amplifier < 3);
    }

    public void drawBackground() {
        CCRenderState.changeTexture((String)"nei:textures/gui/potion.png");
        this.drawTexturedModalRect(0, 0, 0, 0, this.xSize, this.ySize);
        FontUtils.drawCenteredString((String)NEIClientUtils.translate("potion.favourite", new Object[0]), (int)(this.xSize / 2), (int)4, (int)0x404040);
        this.fontRendererObj.drawString(NEIClientUtils.translate("potion.duration", new Object[0]), 12, 40, 0x404040);
        this.fontRendererObj.drawString(NEIClientUtils.translate("potion.level", new Object[0]), 19, 73, 0x404040);
        FontUtils.drawCenteredString((String)this.translateAmplifier(this.amplifier), (int)33, (int)86, (int)-10461088);
    }

    public void addWidgets() {
        this.ampDown = new GuiCCButton(10, 84, 12, 12, "<").setActionCommand("ampDown");
        this.add((GuiWidget)this.ampDown);
        this.ampUp = new GuiCCButton(44, 84, 12, 12, ">").setActionCommand("ampUp");
        this.add((GuiWidget)this.ampUp);
        this.durationField = new GuiDurationField(15, 53, 35, 12);
        this.add((GuiWidget)this.durationField);
        this.slotPotionEffects = new GuiSlotPotionEffects(60, 38);
        this.add((GuiWidget)this.slotPotionEffects);
    }

    public void updateScreen() {
        super.updateScreen();
        this.slotPotionEffects.setEnabled(this.container.potionInv.getStackInSlot(0) != null);
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("ampDown")) {
            --this.amplifier;
        } else if (ident.equals("ampUp")) {
            ++this.amplifier;
        }
        this.applyEffect();
        this.validateInputButtons();
    }

    public class GuiDurationField
    extends GuiCCTextField {
        private String baseValue;

        public GuiDurationField(int x, int y, int width, int height) {
            super(x, y, width, height, "100");
            this.setMaxStringLength(4);
            this.setAllowedCharacters("0123456789");
            this.baseValue = this.getText();
        }

        public void setDurationTicks(int i) {
            String minutes = Integer.toString((i /= 20) / 60);
            String seconds = Integer.toString(i % 60);
            if (seconds.length() == 1) {
                seconds = '0' + seconds;
            }
            this.setText(minutes + seconds);
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (!this.isEnabled()) {
                this.setText("100");
            }
        }

        public void onFocusChanged() {
            if (this.isFocused()) {
                this.baseValue = this.getText();
            } else if (!this.validateValue()) {
                this.setText(this.baseValue);
            } else {
                GuiPotionCreator.this.applyEffect();
            }
        }

        public void onTextChanged(String oldText) {
            GuiPotionCreator.this.validateInputButtons();
        }

        private boolean validateValue() {
            try {
                int i = Integer.parseInt(this.getText());
                return i > 1 && this.getDurationTicks() < Short.MAX_VALUE && i / 100 <= 60 && i % 100 < 60;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        public void drawText() {
            String s = this.getText();
            String seconds = s.substring(Math.max(0, s.length() - 2), Math.max(0, s.length() - 2) + Math.min(s.length(), 2));
            String minutes = s.length() < 3 ? "" : s.substring(0, s.length() - 2);
            int ty = this.y + this.height / 2 - 4;
            int tcolour = this.getTextColour();
            FontUtils.drawCenteredString((String)":", (int)(this.x + this.width / 2 + 1), (int)ty, (int)tcolour);
            FontUtils.drawRightString((String)seconds, (int)(this.x + this.width - 3), (int)ty, (int)tcolour);
            FontUtils.drawRightString((String)minutes, (int)(this.x + this.width / 2 - 1), (int)ty, (int)tcolour);
        }

        public int getTextColour() {
            return this.isFocused() ? 0xCCCCCC : 0x909090;
        }

        public int getDurationTicks() {
            int i = Integer.parseInt(this.getText());
            return (i / 100 * 60 + i % 100) * 20;
        }
    }

    public class GuiSlotPotionEffects
    extends GuiScrollSlot {
        public int selectedslot;
        public boolean enabled;
        private ArrayList<Potion> validPotions;

        public GuiSlotPotionEffects(int x, int y) {
            super(x, y, 108, 76);
            this.selectedslot = -1;
            this.enabled = true;
            this.validPotions = new ArrayList();
            for (Potion p : Potion.potionTypes) {
                if (p == null) continue;
                this.validPotions.add(p);
            }
            this.setSmoothScroll(false);
            this.setMargins(0, 0, 0, 0);
        }

        public int getSlotHeight(int slot) {
            return 19;
        }

        public void drawBackground(float frame) {
            super.drawBackground(frame);
            GuiSlotPotionEffects.drawRect((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
        }

        public void drawOverlay(float frame) {
        }

        public int scrollbarGuideAlignment() {
            return 0;
        }

        public Dimension scrollbarDim() {
            Dimension dim = super.scrollbarDim();
            dim.width = 7;
            return dim;
        }

        protected void drawSlot(int slot, int x, int y, int mx, int my, float frame) {
            int textColour;
            String amp;
            boolean blank;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Potion potion = this.validPotions.get(slot);
            PotionEffect effect = this.getEffect(potion.id);
            boolean bl = blank = effect == null;
            if (effect == null) {
                effect = new PotionEffect(potion.id, 1200, 0);
            }
            int shade = this.selectedslot == slot ? 2 : (blank ? 1 : 0);
            CCRenderState.changeTexture((String)"textures/gui/container/enchanting_table.png");
            this.drawTexturedModalRect(x, y, 0, 166 + this.getSlotHeight(slot) * shade, this.width - 30, this.getSlotHeight(slot));
            this.drawTexturedModalRect(x + this.width - 30, y, this.width - 23, 166 + this.getSlotHeight(slot) * shade, 30, this.getSlotHeight(slot));
            if (potion.hasStatusIcon()) {
                CCRenderState.changeTexture((String)"textures/gui/container/inventory.png");
                int icon = potion.getStatusIconIndex();
                this.drawTexturedModalRect(x + 1, y + 1, icon % 8 * 18, 198 + icon / 8 * 18, 18, 18);
            }
            String name = StatCollector.translateToLocal((String)potion.getName());
            String string = amp = effect.getAmplifier() > 0 ? " " + GuiPotionCreator.this.translateAmplifier(effect.getAmplifier()) : "";
            int n = shade == 0 ? 6839882 : (textColour = shade == 1 ? 4226832 : 0xFFFF80);
            if (this.fontRenderer.getStringWidth(name + amp) < this.width - 20) {
                this.fontRenderer.drawString(name + amp, x + 20, y + 1, textColour);
            } else {
                this.fontRenderer.drawString(name, x + 20, y + 1, textColour);
                FontUtils.drawRightString((String)amp, (int)(x + this.width - 10), (int)(y + 10), (int)textColour);
            }
            String duration = Potion.getDurationString((PotionEffect)effect);
            textColour = shade == 0 ? 0xA0A0A0 : (shade == 1 ? 0x808080 : 0xCCCCCC);
            this.fontRenderer.drawStringWithShadow(duration, x + 20, y + 10, textColour);
        }

        private PotionEffect getEffect(int id) {
            ItemStack potion = GuiPotionCreator.this.container.potionInv.getStackInSlot(0);
            if (potion != null && potion.hasTagCompound() && potion.getTagCompound().hasKey("CustomPotionEffects")) {
                NBTTagList potionTagList = potion.getTagCompound().getTagList("CustomPotionEffects", 10);
                for (int i = 0; i < potionTagList.tagCount(); ++i) {
                    PotionEffect effect = PotionEffect.readCustomPotionEffectFromNBT((NBTTagCompound)potionTagList.getCompoundTagAt(i));
                    if (effect.getPotionID() != id) continue;
                    return effect;
                }
            }
            return null;
        }

        protected int getNumSlots() {
            return this.validPotions.size();
        }

        protected void slotClicked(int slot, int button, int mx, int my, int count) {
            if (!this.enabled) {
                return;
            }
            if (button == 0) {
                this.select(slot);
                GuiPotionCreator.this.applyEffect();
            } else if (button == 1) {
                this.deselect();
                GuiPotionCreator.this.container.removePotionEffect(this.validPotions.get((int)slot).id);
            }
        }

        public void selectNext() {
            if (this.selectedslot >= 0 && this.selectedslot + 1 < this.getNumSlots()) {
                this.select(this.selectedslot + 1);
                this.showSlot(this.selectedslot);
            }
        }

        public void selectPrev() {
            if (this.selectedslot > 0) {
                this.select(this.selectedslot - 1);
                this.showSlot(this.selectedslot);
            }
        }

        public void setEnabled(boolean b) {
            if (b == this.enabled) {
                return;
            }
            this.enabled = b;
            if (!this.enabled) {
                this.deselect();
            }
        }

        private void select(int slot) {
            this.selectedslot = slot;
            GuiPotionCreator.this.durationField.setEnabled(true);
            PotionEffect effect = this.getEffect(this.validPotions.get((int)slot).id);
            if (effect == null) {
                effect = new PotionEffect(this.validPotions.get((int)slot).id, 1200, 0);
            }
            GuiPotionCreator.this.durationField.setDurationTicks(effect.getDuration());
            GuiPotionCreator.this.amplifier = effect.getAmplifier();
            GuiPotionCreator.this.validateInputButtons();
        }

        private void deselect() {
            this.selectedslot = -1;
            GuiPotionCreator.this.durationField.setEnabled(false);
            GuiPotionCreator.this.ampDown.setEnabled(false);
            GuiPotionCreator.this.ampUp.setEnabled(false);
        }

        public int selectedPotion() {
            return this.validPotions.get((int)this.selectedslot).id;
        }
    }
}

