/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.SpawnerRenderer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ItemMobSpawner
extends ItemBlock {
    private static Map<Integer, EntityLiving> entityHashMap;
    private static Map<Integer, String> IDtoNameMap;
    public static int idPig;
    private static boolean loaded;
    public static int placedX;
    public static int placedY;
    public static int placedZ;

    public ItemMobSpawner() {
        super(Blocks.mob_spawner);
        this.hasSubtypes = true;
        MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new SpawnerRenderer());
        entityHashMap = new HashMap<Integer, EntityLiving>();
        IDtoNameMap = new HashMap<Integer, String>();
    }

    public IIcon getIconFromDamage(int par1) {
        return Blocks.mob_spawner.getBlockTextureFromSide(0);
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (super.onItemUse(itemstack, entityplayer, world, x, y, z, par7, par8, par9, par10) && world.isRemote) {
            TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.getTileEntity(placedX, placedY, placedZ);
            if (tileentitymobspawner != null) {
                this.setDefaultTag(itemstack);
                String mobtype = IDtoNameMap.get(itemstack.getItemDamage());
                if (mobtype != null) {
                    NEICPH.sendMobSpawnerID(placedX, placedY, placedZ, mobtype);
                    tileentitymobspawner.func_145881_a().setEntityName(mobtype);
                }
            }
            return true;
        }
        return false;
    }

    public void addInformation(ItemStack itemstack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        this.setDefaultTag(itemstack);
        int meta = itemstack.getItemDamage();
        if (meta == 0) {
            meta = idPig;
        }
        EntityLiving e = ItemMobSpawner.getEntity(meta);
        list.add("\u00a7" + (e instanceof IMob ? "4" : "3") + IDtoNameMap.get(meta));
    }

    public static EntityLiving getEntity(int ID) {
        EntityLiving e = entityHashMap.get(ID);
        if (e == null) {
            WorldClient world = NEIClientUtils.mc().theWorld;
            ItemMobSpawner.loadSpawners((World)world);
            Class clazz = (Class)EntityList.IDtoClassMapping.get(ID);
            try {
                e = (EntityLiving)clazz.getConstructor(World.class).newInstance(world);
            }
            catch (Throwable t) {
                if (clazz == null) {
                    NEIClientConfig.logger.error("Null class for entity (" + ID + ", " + IDtoNameMap.get(ID));
                } else {
                    NEIClientConfig.logger.error("Error creating instance of entity: " + clazz.getName(), t);
                }
                e = ItemMobSpawner.getEntity(idPig);
            }
            entityHashMap.put(ID, e);
        }
        return e;
    }

    private void setDefaultTag(ItemStack itemstack) {
        if (!IDtoNameMap.containsKey(itemstack.getItemDamage())) {
            itemstack.setItemDamage(idPig);
        }
    }

    public static void loadSpawners(World world) {
        if (loaded) {
            return;
        }
        loaded = true;
        HashMap classToStringMapping = (HashMap)EntityList.classToStringMapping;
        HashMap classToIDMapping = (HashMap)EntityList.classToIDMapping;
        for (Class eclass : classToStringMapping.keySet()) {
            if (!EntityLiving.class.isAssignableFrom(eclass)) continue;
            try {
                EntityLiving entityliving = (EntityLiving)eclass.getConstructor(World.class).newInstance(world);
                entityliving.isChild();
                int id = (Integer)classToIDMapping.get(eclass);
                String name = (String)classToStringMapping.get(eclass);
                if (name.equals("EnderDragon")) continue;
                IDtoNameMap.put(id, name);
                if (!name.equals("Pig")) continue;
                idPig = id;
            }
            catch (Throwable ignored) {}
        }
        Iterator<Map.Entry<Integer, String>> it = IDtoNameMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, String> e = it.next();
            if (ItemMobSpawner.getEntity(e.getKey()).getClass() != EntityPig.class || e.getValue().equals("Pig")) continue;
            it.remove();
        }
    }

    public void getSubItems(Item item, CreativeTabs tab, List list) {
        if (!NEIClientConfig.hasSMPCounterPart()) {
            list.add(new ItemStack(item));
        } else {
            for (int i : IDtoNameMap.keySet()) {
                list.add(new ItemStack(item, 1, i));
            }
        }
    }
}

