/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.nei.FastTransferManager;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class DefaultOverlayHandler
implements IOverlayHandler {
    public int offsetx;
    public int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        List<PositionedStack> ingredients = recipe.getIngredientStacks(recipeIndex);
        List<DistributedIngred> ingredStacks = this.getPermutationIngredients(ingredients);
        if (!this.clearIngredients(gui, ingredients)) {
            return;
        }
        this.findInventoryQuantities(gui, ingredStacks);
        List<IngredientDistribution> assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        int quantity = this.calculateRecipeQuantity(assignedIngredients);
        if (quantity != 0) {
            this.moveIngredients(gui, assignedIngredients, quantity);
        }
    }

    private boolean clearIngredients(GuiContainer gui, List<PositionedStack> ingreds) {
        for (PositionedStack pstack : ingreds) {
            for (Slot slot : gui.inventorySlots.inventorySlots) {
                if (slot.xDisplayPosition != pstack.relx + this.offsetx || slot.yDisplayPosition != pstack.rely + this.offsety || !slot.getHasStack()) continue;
                FastTransferManager.clickSlot(gui, slot.slotNumber, 0, 1);
                if (!slot.getHasStack()) continue;
                return false;
            }
        }
        return true;
    }

    private void moveIngredients(GuiContainer gui, List<IngredientDistribution> assignedIngredients, int quantity) {
        block0: for (IngredientDistribution distrib : assignedIngredients) {
            ItemStack pstack = distrib.permutation;
            int transferCap = quantity * pstack.stackSize;
            int transferred = 0;
            int destSlotIndex = 0;
            Slot dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.getMaxStackSize();
            for (Slot slot : gui.inventorySlots.inventorySlots) {
                ItemStack stack;
                if (!slot.getHasStack() || !this.canMoveFrom(slot, gui) || !this.canStack(stack = slot.getStack(), pstack)) continue;
                FastTransferManager.clickSlot(gui, slot.slotNumber);
                int amount = Math.min(transferCap - transferred, stack.stackSize);
                for (int c = 0; c < amount; ++c) {
                    FastTransferManager.clickSlot(gui, dest.slotNumber, 1);
                    ++transferred;
                    if (++slotTransferred < slotTransferCap) continue;
                    if (++destSlotIndex == distrib.slots.length) {
                        dest = null;
                        break;
                    }
                    dest = distrib.slots[destSlotIndex];
                    slotTransferred = 0;
                }
                FastTransferManager.clickSlot(gui, slot.slotNumber);
                if (transferred < transferCap && dest != null) continue;
                continue block0;
            }
        }
    }

    private int calculateRecipeQuantity(List<IngredientDistribution> assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            if (allSlots / istack.numSlots > istack.stack.getMaxStackSize()) {
                allSlots = istack.numSlots * istack.stack.getMaxStackSize();
            }
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        return quantity;
    }

    private Slot[][] assignIngredSlots(GuiContainer gui, List<PositionedStack> ingredients, List<IngredientDistribution> assignedIngredients) {
        Slot[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<Slot, Integer> distribution = new HashMap<Slot, Integer>();
        for (int i = 0; i < recipeSlots.length; ++i) {
            for (Slot slot : recipeSlots[i]) {
                if (distribution.containsKey(slot)) continue;
                distribution.put(slot, -1);
            }
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            remainingIngreds.add(i);
            assignedSlots.add(new LinkedList());
        }
        while (avaliableSlots.size() > 0 && remainingIngreds.size() > 0) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = assignedIngredients.get((int)i).distrib;
                for (Slot slot : recipeSlots[i]) {
                    if (!avaliableSlots.contains(slot)) continue;
                    avaliableSlots.remove(slot);
                    if (slot.getHasStack()) continue;
                    ++istack.numSlots;
                    ((LinkedList)assignedSlots.get(i)).add(slot);
                    assigned = true;
                    break;
                }
                if (assigned && istack.numSlots * istack.stack.getMaxStackSize() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            assignedIngredients.get((int)i).slots = ((LinkedList)assignedSlots.get(i)).toArray(new Slot[0]);
        }
        return recipeSlots;
    }

    private List<IngredientDistribution> assignIngredients(List<PositionedStack> ingredients, List<DistributedIngred> ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            ItemStack permutation = null;
            int biggestSize = 0;
            block1: for (ItemStack pstack : posstack.items) {
                for (int j = 0; j < ingredStacks.size(); ++j) {
                    int relsize;
                    DistributedIngred istack = ingredStacks.get(j);
                    if (!this.canStack(pstack, istack.stack) || istack.invAmount - istack.distributed < pstack.stackSize || (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.stackSize) <= biggestSize) continue;
                    biggestSize = relsize;
                    biggestIngred = istack;
                    permutation = pstack;
                    continue block1;
                }
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.stackSize;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(GuiContainer gui, List<DistributedIngred> ingredStacks) {
        for (Slot slot : gui.inventorySlots.inventorySlots) {
            ItemStack pstack;
            DistributedIngred istack;
            if (!slot.getHasStack() || !this.canMoveFrom(slot, gui) || (istack = this.findIngred(ingredStacks, pstack = slot.getStack())) == null) continue;
            istack.invAmount += pstack.stackSize;
        }
    }

    private List<DistributedIngred> getPermutationIngredients(List<PositionedStack> ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            for (ItemStack pstack : posstack.items) {
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.stackSize;
            }
        }
        return ingredStacks;
    }

    public boolean canMoveFrom(Slot slot, GuiContainer gui) {
        return slot.inventory instanceof InventoryPlayer;
    }

    public Slot[][] mapIngredSlots(GuiContainer gui, List<PositionedStack> ingredients) {
        Slot[][] recipeSlotList = new Slot[ingredients.size()][];
        for (int i = 0; i < ingredients.size(); ++i) {
            LinkedList<Slot> recipeSlots = new LinkedList<Slot>();
            PositionedStack pstack = ingredients.get(i);
            for (Slot slot : gui.inventorySlots.inventorySlots) {
                if (slot.xDisplayPosition != pstack.relx + this.offsetx || slot.yDisplayPosition != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new Slot[0]);
        }
        return recipeSlotList;
    }

    public DistributedIngred findIngred(List<DistributedIngred> ingredStacks, ItemStack pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!this.canStack(pstack, istack.stack)) continue;
            return istack;
        }
        return null;
    }

    protected boolean canStack(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return true;
        }
        return stack1.getItem() == stack2.getItem() && stack1.getItemDamage() == stack2.getItemDamage() && ItemStack.areItemStackTagsEqual((ItemStack)stack2, (ItemStack)stack1);
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public ItemStack permutation;
        public Slot[] slots;

        public IngredientDistribution(DistributedIngred distrib, ItemStack permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }

    public static class DistributedIngred {
        public ItemStack stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;

        public DistributedIngred(ItemStack item) {
            this.stack = InventoryUtils.copyStack((ItemStack)item, (int)1);
        }
    }
}

