/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.inventory.ContainerExtended;
import codechicken.core.inventory.SlotHandleClicks;
import codechicken.lib.inventory.InventoryNBT;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;

public class ContainerPotionCreator
extends ContainerExtended {
    InventoryPlayer playerInv;
    InventoryBasic potionInv;
    IInventory potionStoreInv;

    public ContainerPotionCreator(InventoryPlayer inventoryPlayer, IInventory potionStoreInv) {
        this.playerInv = inventoryPlayer;
        this.potionInv = new InventoryBasic("Potion", true, 1);
        this.potionStoreInv = potionStoreInv;
        this.addSlotToContainer(new SlotPotion((IInventory)this.potionInv, 0, 25, 102));
        for (int i = 0; i < 9; ++i) {
            this.addSlotToContainer((Slot)new SlotPotionStore(potionStoreInv, i, 8 + i * 18, 14));
        }
        this.bindPlayerInventory(inventoryPlayer, 8, 125);
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        if (slotIndex < 10) {
            return this.mergeItemStack(stack, 10, 46, true);
        }
        return this.mergeItemStack(stack, 0, 1, false);
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        if (!player.worldObj.isRemote) {
            InventoryUtils.dropOnClose((EntityPlayer)player, (IInventory)this.potionInv);
        }
    }

    public void handleInputPacket(PacketCustom packet) {
        ItemStack potion = this.potionInv.getStackInSlot(0);
        if (potion == null) {
            return;
        }
        boolean add = packet.readBoolean();
        short effectID = packet.readUByte();
        NBTTagList effects = potion.getTagCompound().getTagList("CustomPotionEffects", 10);
        NBTTagList newEffects = new NBTTagList();
        for (int i = 0; i < effects.tagCount(); ++i) {
            NBTTagCompound tag = effects.getCompoundTagAt(i);
            PotionEffect e = PotionEffect.readCustomPotionEffectFromNBT((NBTTagCompound)tag);
            if (e.getPotionID() == effectID) continue;
            newEffects.appendTag((NBTBase)tag);
        }
        if (add) {
            newEffects.appendTag((NBTBase)new PotionEffect((int)effectID, packet.readInt(), (int)packet.readUByte()).writeCustomPotionEffectToNBT(new NBTTagCompound()));
        }
        potion.getTagCompound().setTag("CustomPotionEffects", (NBTBase)newEffects);
    }

    public void setPotionEffect(int effectID, int duration, int amplifier) {
        PacketCustom packet = NEICPH.createContainerPacket();
        packet.writeBoolean(true);
        packet.writeByte(effectID);
        packet.writeInt(duration);
        packet.writeByte(amplifier);
        packet.sendToServer();
    }

    public void removePotionEffect(int effectID) {
        PacketCustom packet = NEICPH.createContainerPacket();
        packet.writeBoolean(false);
        packet.writeByte(effectID);
        packet.sendToServer();
    }

    public static class InventoryPotionStore
    extends InventoryNBT {
        public InventoryPotionStore() {
            super(9, NEIClientConfig.global.nbt.getCompoundTag("potionStore"));
        }

        public void markDirty() {
            super.markDirty();
            NEIClientConfig.global.nbt.setTag("potionStore", (NBTBase)this.tag);
            NEIClientConfig.global.saveNBT();
        }
    }

    public class SlotPotionStore
    extends SlotHandleClicks {
        public SlotPotionStore(IInventory inv, int slotIndex, int x, int y) {
            super(inv, slotIndex, x, y);
        }

        public ItemStack slotClick(ContainerExtended container, EntityPlayer player, int button, int modifier) {
            ItemStack held = player.inventory.getItemStack();
            if (button == 0 && modifier == 1) {
                NEIClientUtils.cheatItem(this.getStack(), button, -1);
            } else if (button == 1) {
                this.putStack(null);
            } else if (held != null) {
                if (this.isItemValid(held)) {
                    this.putStack(InventoryUtils.copyStack((ItemStack)held, (int)1));
                    player.inventory.setItemStack(null);
                }
            } else if (this.getHasStack()) {
                player.inventory.setItemStack(this.getStack());
            }
            return null;
        }

        public boolean isItemValid(ItemStack stack) {
            return stack.getItem() instanceof ItemPotion;
        }
    }

    public class SlotPotion
    extends Slot {
        public SlotPotion(IInventory inv, int slotIndex, int x, int y) {
            super(inv, slotIndex, x, y);
        }

        public boolean isItemValid(ItemStack stack) {
            return stack.getItem() instanceof ItemPotion;
        }

        public void onSlotChanged() {
            super.onSlotChanged();
            if (this.getHasStack()) {
                ItemStack stack = this.getStack();
                if (!stack.hasTagCompound()) {
                    stack.setTagCompound(new NBTTagCompound());
                }
                if (!stack.getTagCompound().hasKey("CustomPotionEffects")) {
                    stack.getTagCompound().setTag("CustomPotionEffects", (NBTBase)new NBTTagList());
                }
            }
        }
    }
}

