/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClientUtils;
import codechicken.core.GuiModListScroll;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.DefaultHighlightHandler;
import codechicken.nei.HUDRenderer;
import codechicken.nei.KeyManager;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.WorldOverlayRenderer;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemInfo;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientHandler {
    private static ClientHandler instance;
    private ArrayList<EntityItem> SMPmagneticItems = new ArrayList();
    private World lastworld;
    private GuiScreen lastGui;

    public void addSMPMagneticItem(int i, World world) {
        WorldClient cworld = (WorldClient)world;
        Entity e = cworld.getEntityByID(i);
        if (e == null || !(e instanceof EntityItem)) {
            return;
        }
        this.SMPmagneticItems.add((EntityItem)e);
    }

    private void updateMagnetMode(World world, EntityPlayerSP player) {
        if (!NEIClientConfig.getMagnetMode()) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List<Object> items = world.isRemote ? this.SMPmagneticItems : world.getEntitiesWithinAABB(EntityItem.class, player.boundingBox.expand((double)distancexz, (double)distancey, (double)distancexz));
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            double rationspeedy;
            EntityItem item = (EntityItem)iterator.next();
            if (item.delayBeforeCanPickup > 0) continue;
            if (item.isDead && world.isRemote) {
                iterator.remove();
            }
            if (!NEIClientUtils.canItemFitInInventory((EntityPlayer)player, item.getEntityItem())) continue;
            double dx = player.posX - item.posX;
            double dy = player.posY + (double)player.getEyeHeight() - item.posY;
            double dz = player.posZ - item.posZ;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.motionX + speedxz * dx;
            double vy = item.motionY + speedy * dy;
            double vz = item.motionZ + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            if (absvxz < 0.2 && absxz < 0.2 && world.isRemote) {
                item.setDead();
            }
            item.setVelocity(vx, vy, vz);
        }
    }

    public static void preInit() {
        ItemInfo.preInit();
    }

    public static void load() {
        instance = new ClientHandler();
        GuiModListScroll.register((Object)"NotEnoughItems");
        PacketCustom.assignHandler((Object)"NEI", (PacketCustom.ICustomPacketHandler)new NEICPH());
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        API.registerHighlightHandler(new DefaultHighlightHandler(), ItemInfo.Layout.HEADER);
        HUDRenderer.load();
        WorldOverlayRenderer.load();
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.ClientTickEvent event) {
        GuiScreen gui;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.theWorld != null) {
            this.loadWorld((World)mc.theWorld, false);
            if (!NEIClientConfig.isEnabled()) {
                return;
            }
            KeyManager.tickKeyStates();
            NEIController.updateUnlimitedItems(mc.thePlayer.inventory);
            if (mc.currentScreen == null) {
                NEIController.processCreativeCycling(mc.thePlayer.inventory);
            }
            this.updateMagnetMode((World)mc.theWorld, (EntityPlayerSP)mc.thePlayer);
        }
        if ((gui = mc.currentScreen) != this.lastGui) {
            if (gui instanceof GuiMainMenu) {
                this.lastworld = null;
            } else if (gui instanceof GuiSelectWorld) {
                NEIClientConfig.reloadSaves();
            }
        }
        this.lastGui = gui;
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && NEIClientConfig.isEnabled()) {
            HUDRenderer.renderOverlay();
        }
    }

    @SubscribeEvent
    public void renderLastEvent(RenderWorldLastEvent event) {
        if (NEIClientConfig.isEnabled()) {
            WorldOverlayRenderer.render(event.partialTicks);
        }
    }

    public void loadWorld(World world, boolean fromServer) {
        if (world != this.lastworld) {
            this.SMPmagneticItems.clear();
            WorldOverlayRenderer.reset();
            if (!fromServer) {
                NEIClientConfig.setHasSMPCounterPart(false);
                NEIClientConfig.setInternalEnabled(false);
                if (!Minecraft.getMinecraft().isSingleplayer()) {
                    NEIClientConfig.loadWorld("remote/" + ClientUtils.getServerIP().replace(':', '~'));
                }
            }
            this.lastworld = world;
        }
    }

    public static ClientHandler instance() {
        return instance;
    }

    public static RuntimeException throwCME(final String message) {
        GuiErrorScreen errorGui = new GuiErrorScreen(null, null){

            public void handleMouseInput() {
            }

            public void handleKeyboardInput() {
            }

            public void drawScreen(int par1, int par2, float par3) {
                this.drawDefaultBackground();
                String[] s_msg = message.split("\n");
                for (int i = 0; i < s_msg.length; ++i) {
                    this.drawCenteredString(this.fontRendererObj, s_msg[i], this.width / 2, this.height / 3 + 12 * i, -1);
                }
            }
        };
        CustomModLoadingErrorDisplayException e = new CustomModLoadingErrorDisplayException((GuiScreen)errorGui){
            final /* synthetic */ GuiScreen val$errorGui;
            {
                this.val$errorGui = guiScreen;
            }

            public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
                Minecraft.getMinecraft().displayGuiScreen(this.val$errorGui);
            }

            public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
            }
        };
        throw e;
    }
}

