/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ExtendedCreativeInv;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ContainerCreativeInv
extends Container {
    public EntityPlayer player;

    public ContainerCreativeInv(EntityPlayer player, ExtendedCreativeInv extraInv) {
        int col;
        int row;
        this.player = player;
        InventoryPlayer invPlayer = player.inventory;
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlotToContainer(new Slot((IInventory)extraInv, col + row * 9, 8 + col * 18, 5 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlotToContainer(new Slot((IInventory)invPlayer, col + row * 9 + 9, 8 + col * 18, 118 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlotToContainer(new Slot((IInventory)invPlayer, col2, 8 + col2 * 18, 176));
        }
        this.addSlotToContainer(new SlotBlockArmor((IInventory)invPlayer, invPlayer.getSizeInventory() - 1, -15, 23, 0));
        for (int armorType = 1; armorType < 4; ++armorType) {
            this.addSlotToContainer(new SlotArmor((IInventory)invPlayer, invPlayer.getSizeInventory() - 1 - armorType, -15, 23 + armorType * 18, armorType));
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slotIndex) {
        ItemStack transferredStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack stack = slot.getStack();
            transferredStack = stack.copy();
            if (stack.getItem() instanceof ItemArmor) {
                ItemArmor armor = (ItemArmor)stack.getItem();
                if (!this.getSlot(90 + armor.armorType).getHasStack()) {
                    this.getSlot(90 + armor.armorType).putStack(transferredStack);
                    slot.putStack(null);
                    return transferredStack;
                }
            }
            if (slotIndex < 54 ? !this.mergeItemStack(stack, 54, 90, true) : !this.mergeItemStack(stack, 0, 54, false)) {
                return null;
            }
            if (stack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return transferredStack;
    }

    public boolean canInteractWith(EntityPlayer var1) {
        return true;
    }

    private class SlotBlockArmor
    extends SlotArmor {
        public SlotBlockArmor(IInventory inv, int x, int y, int slot, int armor) {
            super(inv, x, y, slot, armor);
        }

        @Override
        public boolean isItemValid(ItemStack stack) {
            return super.isItemValid(stack) || stack != null;
        }
    }

    private class SlotArmor
    extends Slot {
        int armorType;

        public SlotArmor(IInventory inv, int x, int y, int slot, int armor) {
            super(inv, x, y, slot);
            this.armorType = armor;
        }

        public int getSlotStackLimit() {
            return 1;
        }

        public boolean isItemValid(ItemStack stack) {
            return stack != null && stack.getItem().isValidArmor(stack, this.armorType, (Entity)ContainerCreativeInv.this.player);
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getBackgroundIconIndex() {
            return ItemArmor.func_94602_b((int)this.armorType);
        }
    }
}

