/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.client.gui;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiCCTextField;
import codechicken.core.gui.GuiScreenWidget;
import codechicken.core.gui.GuiWidget;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.LangProxy;
import codechicken.wirelessredstone.api.IGuiRemoteUseable;
import codechicken.wirelessredstone.api.ITileWireless;
import codechicken.wirelessredstone.client.gui.GuiButtonArrow;
import codechicken.wirelessredstone.client.gui.GuiInvItemSlot;
import codechicken.wirelessredstone.client.gui.GuiNameSlot;
import codechicken.wirelessredstone.item.ItemWirelessFreq;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.SaveManager;
import codechicken.wirelessredstone.network.WRClientPH;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class GuiRedstoneWireless
extends GuiScreenWidget
implements IGuiRemoteUseable {
    private static LangProxy lang = new LangProxy("wrcbe");
    RedstoneEther ether = RedstoneEther.get(true);
    private GuiCCTextField textboxname;
    private GuiCCTextField textboxfreq;
    private GuiNameSlot slotnames;
    private GuiInvItemSlot dyeslot;
    private GuiCCButton setfreqbutton;
    private GuiCCButton setnamebutton;
    private GuiCCButton setcolourbutton;
    private int selectedfreq;
    private boolean toggle;
    protected TileEntity etile;
    protected ITileWireless itile;
    protected ItemWirelessFreq item;
    protected InventoryPlayer inventory;
    public boolean largeGui;

    public GuiRedstoneWireless(InventoryPlayer inventoryplayer, ITileWireless tileentityredstonewireless) {
        this.itile = tileentityredstonewireless;
        this.etile = (TileEntity)tileentityredstonewireless;
        this.selectedfreq = this.itile.getFreq();
        this.inventory = inventoryplayer;
    }

    public GuiRedstoneWireless(InventoryPlayer inventoryplayer) {
        this.item = (ItemWirelessFreq)inventoryplayer.func_70448_g().func_77973_b();
        this.selectedfreq = this.item.getItemFreq(inventoryplayer.func_70448_g());
        this.inventory = inventoryplayer;
    }

    public void func_73866_w_() {
        this.largeGui = SaveManager.config().getTag("AdvancedGui").getBooleanValue(false);
        if (this.largeGui) {
            this.xSize = 236;
            this.ySize = 190;
        } else {
            this.xSize = 176;
            this.ySize = 166;
        }
        super.func_73866_w_();
    }

    public void addWidgets() {
        if (this.largeGui) {
            this.add((GuiWidget)new GuiCCButton(218, 4, 14, 15, "x").setActionCommand("close"));
            this.add((GuiWidget)new GuiCCButton(135, 20, 20, 20, "+").setActionCommand("+1"));
            this.add((GuiWidget)new GuiCCButton(81, 20, 20, 20, "-").setActionCommand("-1"));
            this.add((GuiWidget)new GuiCCButton(158, 20, 20, 20, "+10").setActionCommand("+10"));
            this.add((GuiWidget)new GuiCCButton(58, 20, 20, 20, "-10").setActionCommand("-10"));
            this.add((GuiWidget)new GuiCCButton(180, 20, 26, 20, "+100").setActionCommand("+100"));
            this.add((GuiWidget)new GuiCCButton(29, 20, 26, 20, "-100").setActionCommand("-100"));
            this.add((GuiWidget)new GuiCCButton(174, 42, 32, 20, "+1000").setActionCommand("+1000"));
            this.add((GuiWidget)new GuiCCButton(29, 42, 32, 20, "-1000").setActionCommand("-1000"));
            this.add((GuiWidget)new GuiCCButton(181, 167, 50, 16, lang.translate("button.simple")).setActionCommand("toggleSize"));
            this.setfreqbutton = new GuiCCButton(143, 45, 26, 20, lang.translate("button.set")).setActionCommand("setFreq");
            this.add((GuiWidget)this.setfreqbutton);
            this.setnamebutton = new GuiCCButton(171, 83, 50, 20, "").setActionCommand("setName");
            this.add((GuiWidget)this.setnamebutton);
            this.setcolourbutton = new GuiCCButton(171, 140, 61, 20, lang.translate("button.colour")).setActionCommand("setColour");
            this.add((GuiWidget)this.setcolourbutton);
            this.add((GuiWidget)new GuiButtonArrow(182, 122, 12, 12, 3).setActionCommand("nextItem"));
            this.add((GuiWidget)new GuiButtonArrow(208, 122, 12, 12, 1).setActionCommand("prevItem"));
            this.slotnames = new GuiNameSlot(18, 104);
            this.add((GuiWidget)this.slotnames);
            this.textboxfreq = new GuiCCTextField(98, 46, 40, 18, "").setActionCommand("setFreq").setMaxStringLength(4).setAllowedCharacters("0123456789");
            this.add((GuiWidget)this.textboxfreq);
            this.textboxname = new GuiCCTextField(18, 85, 150, 16, "").setActionCommand("setName").setMaxStringLength(20);
            this.add((GuiWidget)this.textboxname);
            this.dyeslot = new GuiInvItemSlot(193, 120, this.inventory, RedstoneEther.getColourSetters(), 14).setActionCommand("setColour");
            this.add(this.dyeslot);
            this.updateColourSetButton();
            this.updateFreqSetButton();
            this.reloadNameText();
            this.updateNames();
        } else {
            this.add((GuiWidget)new GuiCCButton(157, 6, 14, 15, "x").setActionCommand("close"));
            this.add((GuiWidget)new GuiCCButton(101, 33, 20, 20, "+").setActionCommand("+1"));
            this.add((GuiWidget)new GuiCCButton(55, 33, 20, 20, "-").setActionCommand("-1"));
            this.add((GuiWidget)new GuiCCButton(123, 33, 20, 20, "+10").setActionCommand("+10"));
            this.add((GuiWidget)new GuiCCButton(33, 33, 20, 20, "-10").setActionCommand("-10"));
            this.add((GuiWidget)new GuiCCButton(145, 33, 26, 20, "+100").setActionCommand("+100"));
            this.add((GuiWidget)new GuiCCButton(5, 33, 26, 20, "-100").setActionCommand("-100"));
            this.add((GuiWidget)new GuiCCButton(127, 55, 32, 20, "+1000").setActionCommand("+1000"));
            this.add((GuiWidget)new GuiCCButton(18, 55, 32, 20, "-1000").setActionCommand("-1000"));
            this.add((GuiWidget)new GuiCCButton(61, 68, 54, 16, lang.translate("button.advanced")).setActionCommand("toggleSize"));
        }
    }

    public void func_73876_c() {
        if (this.itile != null && this.field_146297_k.field_71441_e.func_175625_s(this.etile.func_174877_v()) != this.etile) {
            this.field_146297_k.field_71462_r = null;
            this.field_146297_k.func_71381_h();
        }
        super.func_73876_c();
        if (this.toggle) {
            this.largeGui = !this.largeGui;
            SaveManager.config().getTag("AdvancedGui").setBooleanValue(this.largeGui);
            this.reset();
            this.toggle = false;
        }
        if (this.largeGui) {
            this.updateColourSetButton();
            this.updateFreqSetButton();
            this.updateNames();
        }
    }

    public void func_73863_a(int mousex, int mousey, float f) {
        this.func_146276_q_();
        super.func_73863_a(mousex, mousey, f);
    }

    public void drawForeground() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        if (this.largeGui) {
            this.drawCentered(this.getSetObjectName(), 118, 5, 0x303030);
            this.drawRight(lang.translate("label.value"), 96, 51, 0x404040);
            this.drawCentered(lang.translate("label.name"), 94, 74, 0x404040);
            this.drawCentered(lang.translate("label.colour"), 201, 107, this.ether.getFreqColour(this.selectedfreq));
            String sactualfreq = Integer.toString(this.getSetObjectFreq());
            if (!this.ether.canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, this.selectedfreq)) {
                this.drawCentered("" + this.selectedfreq, 118, 23, 0xFF4040);
                this.drawCentered(sactualfreq, 118, 33, 0x4040FF);
            } else {
                this.drawCentered(sactualfreq, 118, 26, 0xFFFFFF);
            }
        } else {
            this.drawCentered(this.getSetObjectName(), 88, 5, 0x303030);
            this.drawCentered(lang.translate("label.freq"), 88, 16, 0x404040);
            String sactualfreq = Integer.toString(this.getSetObjectFreq());
            if (!this.ether.canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, this.selectedfreq)) {
                this.drawCentered("" + this.selectedfreq, 88, 36, 0xFF4040);
                this.drawCentered(sactualfreq, 88, 46, 0x4040FF);
            } else {
                this.drawCentered(sactualfreq, 88, 39, 0xFFFFFF);
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    private void drawCentered(String s, int x, int y, int colour) {
        this.field_146289_q.func_78276_b(s, x - this.field_146289_q.func_78256_a(s) / 2, y, colour);
    }

    private void drawRight(String s, int x, int y, int colour) {
        this.field_146289_q.func_78276_b(s, x - this.field_146289_q.func_78256_a(s), y, colour);
    }

    private void updateFreqSetButton() {
        int i;
        String s = this.textboxfreq.getText();
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            i = -1;
        }
        this.setfreqbutton.setEnabled(i >= 0 && i <= 5000);
    }

    private void updateColourSetButton() {
        int selected = this.dyeslot.getSelectedIndex();
        if (selected == -1) {
            this.setcolourbutton.setEnabled(false);
            return;
        }
        if (selected == 14) {
            selected = -1;
        }
        this.setcolourbutton.setEnabled(this.selectedfreq != 0 && selected != this.ether.getFreqColourId(this.selectedfreq) && this.ether.canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, this.selectedfreq));
    }

    private boolean nameIsUsed(String name) {
        ArrayList<String> names = this.ether.getAllNames();
        return names.contains(name);
    }

    private void updateNames() {
        String name = this.ether.getFreqName(this.selectedfreq);
        String tname = this.textboxname.getText();
        boolean set = name == null || name.equals("") || !name.equals(tname);
        boolean canset = !tname.equals("") && !this.nameIsUsed(tname) && this.selectedfreq != 0;
        this.setnamebutton.setEnabled((set && canset || !set) && this.ether.canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, this.selectedfreq));
        String string = this.setnamebutton.text = set ? "Set Name" : "Remove";
        if (set) {
            this.slotnames.updateNameList((EntityPlayer)this.field_146297_k.field_71439_g, this.textboxname.getText());
        } else if (name.equals(tname)) {
            this.slotnames.updateNameList((EntityPlayer)this.field_146297_k.field_71439_g, "");
            this.slotnames.removeName(tname);
        } else {
            this.slotnames.clearNameList();
        }
    }

    private void reloadNameText() {
        String name = this.ether.getFreqName(this.selectedfreq);
        if (name == null) {
            name = "";
        }
        this.textboxname.setText(name);
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("close")) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else if (ident.startsWith("+") || ident.startsWith("-")) {
            this.selectedfreq += Integer.parseInt(ident.startsWith("+") ? ident.substring(1) : ident);
            if (this.selectedfreq > 5000) {
                this.selectedfreq -= 5001;
            }
            if (this.selectedfreq < 0) {
                this.selectedfreq += 5001;
            }
            this.setNewFreq();
        } else if (ident.equals("toggleSize")) {
            this.toggle = true;
        } else if (ident.equals("setFreq")) {
            this.selectedfreq = Integer.parseInt(this.textboxfreq.getText());
            this.setNewFreq();
        } else if (ident.equals("setName")) {
            if (this.setnamebutton.isEnabled()) {
                if (this.setnamebutton.text.equals("Set Name")) {
                    this.ether.setFreqName(this.selectedfreq, this.textboxname.getText());
                    WRClientPH.sendSetFreqInfo(this.selectedfreq, this.textboxname.getText(), this.ether.getFreqColourId(this.selectedfreq));
                } else {
                    this.ether.setFreqName(this.selectedfreq, "");
                    WRClientPH.sendSetFreqInfo(this.selectedfreq, "", this.ether.getFreqColourId(this.selectedfreq));
                    this.textboxname.setText("");
                }
            }
        } else if (ident.equals("setColour")) {
            int colourid = this.dyeslot.getSelectedIndex();
            if (colourid == -1) {
                return;
            }
            if (colourid == 14) {
                colourid = -1;
            }
            if (colourid == this.ether.getFreqColourId(this.selectedfreq)) {
                return;
            }
            this.dyeslot.decrementCurrentStack();
            this.ether.setFreqColour(this.selectedfreq, colourid);
            WRClientPH.sendSetFreqInfo(this.selectedfreq, this.ether.getFreqName(this.selectedfreq), colourid);
        } else if (ident.equals("nextItem")) {
            this.dyeslot.cycleNextItem();
        } else if (ident.equals("prevItem")) {
            this.dyeslot.cyclePrevItem();
        } else if (ident.equals("selectName")) {
            String slotname = this.slotnames.getSelectedName();
            if (slotname.equals("")) {
                return;
            }
            int freq = this.ether.getFreqByName(slotname);
            if (freq != -1) {
                this.selectedfreq = freq;
                this.setNewFreq();
            }
        }
    }

    private void setNewFreq() {
        if (this.ether.canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, this.selectedfreq)) {
            if (this.itile == null) {
                this.item.setFreq(this.inventory.field_70458_d, this.inventory.field_70461_c, this.inventory.func_70448_g(), this.selectedfreq);
            } else {
                RedstoneEther.get(true).setFreq(this.itile, this.selectedfreq);
            }
        }
        if (this.largeGui) {
            this.reloadNameText();
        }
    }

    private String getSetObjectName() {
        return this.itile == null ? this.item.getGuiName() : this.itile.getGuiName();
    }

    private int getSetObjectFreq() {
        return this.itile == null ? this.item.getItemFreq(this.inventory.func_70448_g()) : this.itile.getFreq();
    }

    public void drawBackground() {
        if (this.largeGui) {
            TextureUtils.changeTexture((String)"wrcbe:textures/gui/wirelessLarge.png");
        } else {
            TextureUtils.changeTexture((String)"wrcbe:textures/gui/wirelessSmall.png");
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(0, 0, 0, 0, this.xSize, this.ySize);
    }

    public boolean func_73868_f() {
        return false;
    }
}

