/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.item;

import codechicken.lib.model.blockbakery.IBakeryItem;
import codechicken.lib.model.blockbakery.IItemBakery;
import codechicken.wirelessredstone.WirelessRedstone;
import codechicken.wirelessredstone.api.ITileWireless;
import codechicken.wirelessredstone.client.bakery.WirelessRemoteBakery;
import codechicken.wirelessredstone.item.ItemWirelessFreq;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherAddons;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWirelessRemote
extends ItemWirelessFreq
implements IBakeryItem {
    public ItemWirelessRemote() {
        this.func_77637_a(WirelessRedstone.creativeTab);
        this.func_77655_b("wrcbe:remote");
        this.func_77625_d(1);
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!player.func_70093_af() && stack.func_77952_i() <= 5000 && stack.func_77952_i() > 0) {
            TileEntity tile = world.func_175625_s(pos);
            int freq = stack.func_77952_i();
            if (tile != null && tile instanceof ITileWireless && RedstoneEther.get(world.field_72995_K).canBroadcastOnFrequency(player, freq)) {
                RedstoneEther.get(world.field_72995_K).setFreq((ITileWireless)tile, freq);
                return EnumActionResult.SUCCESS;
            }
        }
        this.func_77659_a(stack, world, player, hand);
        return EnumActionResult.PASS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return super.func_77659_a(itemStack, world, player, hand);
        }
        if (!ItemWirelessRemote.getTransmitting(itemStack) && itemStack.func_77952_i() != 0) {
            RedstoneEtherAddons.get(world.field_72995_K).activateRemote(world, player);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        int freq = this.getItemFreq(stack);
        EntityPlayer player = (EntityPlayer)entity;
        if (!(!ItemWirelessRemote.getTransmitting(stack) || held && RedstoneEtherAddons.get(world.field_72995_K).isRemoteOn(player, freq) || RedstoneEtherAddons.get(world.field_72995_K).deactivateRemote(world, player))) {
            stack.func_77964_b(freq);
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        return !ItemWirelessRemote.getTransmitting(stack);
    }

    @Override
    public int getItemFreq(ItemStack itemstack) {
        return itemstack.func_77952_i() & 0x1FFF;
    }

    public static boolean getTransmitting(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("on", 1) && tag.func_74767_n("on");
    }

    public static void setOn(ItemStack stack, boolean on) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("on", on);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack itemstack) {
        return RedstoneEtherAddons.localizeWirelessItem(I18n.func_74838_a((String)"item.wrcbe.remote.short"), itemstack.func_77952_i());
    }

    @Override
    public String getGuiName() {
        return I18n.func_74838_a((String)"item.wrcbe:remote.name");
    }

    @SideOnly(value=Side.CLIENT)
    public IItemBakery getBakery() {
        return WirelessRemoteBakery.INSTANCE;
    }
}

