/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.manager;

import codechicken.wirelessredstone.WirelessRedstone;
import codechicken.wirelessredstone.api.ClientMapInfo;
import codechicken.wirelessredstone.api.IGuiRemoteUseable;
import codechicken.wirelessredstone.device.Remote;
import codechicken.wirelessredstone.entity.EntityREP;
import codechicken.wirelessredstone.init.ModItems;
import codechicken.wirelessredstone.item.ItemWirelessFreq;
import codechicken.wirelessredstone.item.ItemWirelessRemote;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherAddons;
import codechicken.wirelessredstone.manager.TriangFreqManager;
import codechicken.wirelessredstone.network.WRClientPH;
import codechicken.wirelessredstone.util.WirelessMapNodeStorage;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import org.lwjgl.input.Mouse;

public class RedstoneEtherClientAddons
extends RedstoneEtherAddons {
    private boolean mousedown;
    private boolean wasmousedown;
    private Remote remote;
    private TriangFreqManager[] triangFreqs;
    private HashMap<Short, ClientMapInfo> clientMapInfoSet = new HashMap();
    private WirelessMapNodeStorage wirelessmapnodes;
    private EntityREP activeREP;
    private int REPThrowTimeout;
    private int ticksInGui;

    public RedstoneEtherClientAddons() {
        this.triangFreqs = new TriangFreqManager[5001];
        for (int freq = 1; freq <= 5000; ++freq) {
            this.triangFreqs[freq] = new TriangFreqManager(freq);
        }
    }

    public void updateTriangulators(EntityPlayer player) {
        for (int freq = 1; freq <= 5000; ++freq) {
            this.triangFreqs[freq].tickTriang(player);
        }
    }

    public boolean isTriangOn(int freq) {
        return this.triangFreqs[freq].isTriangOn();
    }

    public float getTriangAngle(int freq) {
        return this.triangFreqs[freq].getTriangAngle();
    }

    public void setTriangAngle(int freq, float angle) {
        this.triangFreqs[freq].setTriangAngle(angle);
    }

    public void setTriangRequired(EntityPlayer player, int freq, boolean required) {
        WRClientPH.sendSyncTriang(freq, required);
    }

    @Override
    public boolean isRemoteOn(EntityPlayer player, int freq) {
        return this.remote == null ? false : this.remote.getFreq() == freq;
    }

    public int getRemoteFreq(EntityPlayer player) {
        return this.remote == null ? -1 : this.remote.getFreq();
    }

    public void checkClicks() {
        this.wasmousedown = this.mousedown;
        this.mousedown = Mouse.isButtonDown((int)1);
    }

    public void openItemGui(EntityPlayer player) {
        ItemStack helditem = player.field_71071_by.func_70448_g();
        if (helditem != null && helditem.func_77973_b() instanceof ItemWirelessFreq && this.mousedown && !this.wasmousedown && player.func_70093_af()) {
            WirelessRedstone.proxy.openItemWirelessGui(player);
        }
    }

    public void processRemote(World world, EntityPlayer player, GuiScreen currentscreen, RayTraceResult hit) {
        boolean jammed = RedstoneEther.client().isPlayerJammed(player);
        if (this.remote != null && (!this.mousedown || currentscreen != null && !(currentscreen instanceof IGuiRemoteUseable) || jammed)) {
            this.deactivateRemote(world, player);
        }
        if (this.mouseClicked() && this.remote == null && player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == ModItems.itemRemote && currentscreen != null && currentscreen instanceof IGuiRemoteUseable && !player.func_70093_af() && this.ticksInGui > 0 && !jammed) {
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (stack.func_77952_i() == 0 || ItemWirelessRemote.getTransmitting(stack)) {
                return;
            }
            this.activateRemote(world, player);
        }
    }

    @Override
    public void activateRemote(World world, EntityPlayer player) {
        if (this.remote != null) {
            if (this.remote.isBeingHeld()) {
                return;
            }
            this.deactivateRemote(world, player);
        }
        if (RedstoneEther.client().isPlayerJammed(player)) {
            return;
        }
        this.remote = new Remote(player);
        this.remote.metaOn();
        WRClientPH.sendSetRemote(true);
    }

    @Override
    public boolean deactivateRemote(World world, EntityPlayer player) {
        if (this.remote == null) {
            return false;
        }
        this.remote.metaOff();
        this.remote = null;
        WRClientPH.sendSetRemote(false);
        return true;
    }

    public void addSniffer(EntityPlayer player) {
        WRClientPH.sendOpenSniffer();
    }

    public void remSniffer(EntityPlayer player) {
        WRClientPH.sendCloseSniffer();
    }

    public WirelessMapNodeStorage getMapNodes() {
        if (this.wirelessmapnodes == null) {
            this.wirelessmapnodes = new WirelessMapNodeStorage();
        }
        return this.wirelessmapnodes;
    }

    public void updateSSPMap(World world, EntityPlayer player, MapData mapdata) {
        if (RedstoneEther.get(true).isPlayerJammed(player) || mapdata.field_76200_c != player.field_71093_bK) {
            this.clearMapNodes(player);
            return;
        }
    }

    public void clearMapNodes(EntityPlayer player) {
        WRClientPH.sendResetMap();
        this.wirelessmapnodes = null;
    }

    public boolean mouseClicked() {
        return this.mousedown && !this.wasmousedown;
    }

    public ClientMapInfo getMPMapInfo(short mapid) {
        return this.clientMapInfoSet.get(mapid);
    }

    public void setMPMapInfo(short mapid, ClientMapInfo mapinfo) {
        this.clientMapInfoSet.put(mapid, mapinfo);
    }

    public void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        this.checkClicks();
        this.updateTriangulators((EntityPlayer)mc.field_71439_g);
        this.openItemGui((EntityPlayer)mc.field_71439_g);
        this.processRemote((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g, mc.field_71462_r, mc.field_71476_x);
        if (this.REPThrowTimeout > 0) {
            --this.REPThrowTimeout;
        }
        this.ticksInGui = mc.field_71462_r == null ? 0 : ++this.ticksInGui;
    }

    public boolean detonateREP(EntityPlayer player) {
        if (this.activeREP == null) {
            return false;
        }
        if (this.activeREP.field_70128_L) {
            this.activeREP = null;
            return false;
        }
        this.activeREP.detonate();
        this.activeREP.func_70106_y();
        return true;
    }

    public void throwREP(ItemStack itemstack, World world, EntityPlayer player) {
        if (this.REPThrowTimeout > 0) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        this.activeREP = new EntityREP(world, (EntityLivingBase)player);
        world.func_72838_d((Entity)this.activeREP);
        this.REPThrowTimeout = 40;
    }

    @Override
    public void invalidateREP(EntityPlayer shootingEntity) {
        this.activeREP = null;
    }
}

