/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.network;

import codechicken.lib.packet.PacketCustom;
import codechicken.wirelessredstone.api.FreqCoord;
import codechicken.wirelessredstone.api.ITileWireless;
import codechicken.wirelessredstone.entity.EntityREP;
import codechicken.wirelessredstone.entity.EntityWirelessTracker;
import codechicken.wirelessredstone.entity.WirelessBolt;
import codechicken.wirelessredstone.item.ItemWirelessFreq;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherAddons;
import java.util.ArrayList;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapData;

public class WRServerPH
implements PacketCustom.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, EntityPlayerMP sender, INetHandlerPlayServer handler) {
        this.handlePacket((WorldServer)sender.field_70170_p, sender, packet);
    }

    private void handlePacket(WorldServer world, EntityPlayerMP player, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: {
                this.setTileFreq((EntityPlayer)player, (World)world, packet.readPos(), packet.readShort());
                break;
            }
            case 2: {
                this.setItemFreq(player, packet.readShort(), packet.readShort());
                break;
            }
            case 4: {
                this.handleFreqInfo(packet);
                break;
            }
            case 5: {
                this.decrementSlot(player, packet.readShort());
                break;
            }
            case 9: {
                RedstoneEther.get(false).setFreqOwner(packet.readShort(), packet.readString());
                break;
            }
            case 50: {
                if (packet.readBoolean()) {
                    RedstoneEtherAddons.server().addSniffer((EntityPlayer)player);
                    break;
                }
                RedstoneEtherAddons.server().remSniffer((EntityPlayer)player);
                break;
            }
            case 51: {
                if (packet.readBoolean()) {
                    RedstoneEtherAddons.server().activateRemote((World)world, (EntityPlayer)player);
                    break;
                }
                RedstoneEtherAddons.server().deactivateRemote((World)world, (EntityPlayer)player);
                break;
            }
            case 52: {
                RedstoneEtherAddons.server().setTriangRequired((EntityPlayer)player, packet.readUShort(), packet.readBoolean());
                break;
            }
            case 58: {
                RedstoneEtherAddons.server().clearMapNodes((EntityPlayer)player);
            }
        }
    }

    private void decrementSlot(EntityPlayerMP player, int slot) {
        try {
            ItemStack item = player.field_71071_by.field_70462_a[slot];
            --item.field_77994_a;
            if (item.field_77994_a == 0) {
                player.field_71071_by.field_70462_a[slot] = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void setItemFreq(EntityPlayerMP sender, int slot, int freq) {
        ItemStack stack;
        if (RedstoneEther.get(false).canBroadcastOnFrequency((EntityPlayer)sender, freq) && (stack = sender.field_71071_by.field_70462_a[slot]) != null && stack.func_77973_b() instanceof ItemWirelessFreq) {
            ((ItemWirelessFreq)stack.func_77973_b()).setFreq((EntityPlayer)sender, slot, stack, freq);
        }
    }

    private void setTileFreq(EntityPlayer sender, World world, BlockPos pos, int freq) {
        TileEntity tile;
        if (RedstoneEther.get(false).canBroadcastOnFrequency(sender, freq) && (tile = RedstoneEther.getTile(world, pos)) instanceof ITileWireless) {
            RedstoneEther.get(false).setFreq((ITileWireless)tile, freq);
        }
    }

    private void handleFreqInfo(PacketCustom packet) {
        int freq = packet.readUShort();
        String name = packet.readString();
        short colourid = packet.readUByte();
        RedstoneEther.get(false).setFreqName(freq, name);
        RedstoneEther.get(false).setFreqColour(freq, colourid);
        WRServerPH.sendSetFreqInfoTo(null, freq, name, colourid);
    }

    public static void sendSetFrequencyRangeTo(EntityPlayer player, int startfreq, int endfreq, boolean jam) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 3);
        packet.writeShort((int)((short)startfreq));
        packet.writeShort((int)((short)endfreq));
        packet.writeBoolean(jam);
        packet.sendToPlayer(player);
    }

    public static void sendPublicFrequencyTo(EntityPlayer player, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(freq);
        packet.writeByte(1);
        packet.sendToPlayer(player);
    }

    public static void sendSharedFrequencyTo(EntityPlayer player, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(freq);
        packet.writeByte(2);
        packet.sendToPlayer(player);
    }

    public static void sendSetFreqInfoTo(EntityPlayer player, int freq, String name, int colourid) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 4);
        packet.writeShort(freq);
        packet.writeByte(colourid);
        packet.writeString(name);
        packet.sendToPlayer(player);
    }

    public static void sendJamPlayerPacketTo(EntityPlayer player, boolean jam) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 7);
        packet.writeBoolean(jam);
        packet.sendToPlayer(player);
    }

    public static void sendWirelessBolt(WirelessBolt bolt) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 8);
        packet.writeFloat((float)bolt.start.x);
        packet.writeFloat((float)bolt.start.y);
        packet.writeFloat((float)bolt.start.z);
        packet.writeFloat((float)bolt.end.x);
        packet.writeFloat((float)bolt.end.y);
        packet.writeFloat((float)bolt.end.z);
        packet.writeLong(bolt.seed);
        packet.sendToChunk(bolt.world, (int)bolt.start.x >> 4, (int)bolt.start.z >> 4);
    }

    public static void sendSetSlot(int slot, ItemStack stack) {
    }

    public static void sendFreqInfoTo(EntityPlayer player, ArrayList<Integer> freqsWithInfo) {
        if (freqsWithInfo.size() == 0) {
            return;
        }
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 1);
        packet.writeShort(freqsWithInfo.size());
        for (int freq : freqsWithInfo) {
            packet.writeShort(freq);
            packet.writeByte(RedstoneEther.get(false).getFreqColourId(freq));
            packet.writeString(RedstoneEther.get(false).getFreqName(freq));
        }
        packet.sendToPlayer(player);
    }

    public static void sendFreqOwnerTo(EntityPlayer player, ArrayList<Integer> freqsWithOwners) {
        if (freqsWithOwners.size() == 0) {
            return;
        }
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 10);
        packet.writeShort(freqsWithOwners.size());
        for (int freq : freqsWithOwners) {
            packet.writeShort(freq);
            packet.writeString(RedstoneEther.get(false).getFreqOwner(freq));
        }
        packet.sendToPlayer(player);
    }

    public static void sendSetFreqOwner(int freq, String username) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 9);
        packet.writeShort(freq);
        packet.writeString(username);
        packet.sendToClients();
    }

    public static void sendUpdateSnifferTo(EntityPlayer player, int freq, boolean on) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 53);
        packet.writeShort((int)((short)freq));
        packet.writeBoolean(on);
        packet.sendToPlayer(player);
    }

    public static void sendEtherCopyTo(EntityPlayer player, byte[] ethercopy) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 54);
        packet.writeShort(ethercopy.length);
        packet.func_179250_a(ethercopy);
        packet.sendToPlayer(player);
    }

    public static void sendTriangAngleTo(EntityPlayer player, int freq, float angle) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 55);
        packet.writeShort((int)((short)freq));
        packet.writeFloat(angle);
        packet.sendToPlayer(player);
    }

    public static void sendMapUpdatePacketTo(EntityPlayer player, int mapno, MapData mapdata, TreeSet<FreqCoord> addednodes, TreeSet<FreqCoord> removednodes, TreeSet<FreqCoord> remotes) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 57);
        packet.writeShort((int)((short)addednodes.size()));
        for (FreqCoord node : addednodes) {
            packet.writeShort((int)((short)node.x));
            packet.writeShort((int)((short)node.z));
            packet.writeShort((int)((short)node.freq));
        }
        packet.writeShort((int)((short)removednodes.size()));
        for (FreqCoord node : removednodes) {
            packet.writeShort((int)((short)node.x));
            packet.writeShort((int)((short)node.z));
            packet.writeShort((int)((short)node.freq));
        }
        packet.writeShort((int)((short)remotes.size()));
        for (FreqCoord node : remotes) {
            packet.writeInt(node.x);
            packet.writeInt(node.z);
            packet.writeShort((int)((short)node.freq));
        }
        packet.sendToPlayer(player);
    }

    public static void sendMapInfoTo(EntityPlayer player, int mapno, MapData mapdata) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 56);
        packet.writeShort((int)((short)mapno));
        packet.writeInt(mapdata.field_76201_a);
        packet.writeInt(mapdata.field_76199_b);
        packet.writeByte((int)mapdata.field_76197_d);
        packet.sendToPlayer(player);
    }

    public static void sendSpawnREP(EntityREP activeREP) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 59);
        packet.writeBoolean(true);
        packet.writeInt(activeREP.func_145782_y());
        packet.writeInt(activeREP.shootingEntity.func_145782_y());
        packet.sendToChunk(activeREP.field_70170_p, (int)activeREP.field_70165_t >> 4, (int)activeREP.field_70161_v >> 4);
    }

    public static void sendKillREP(EntityREP entityREP) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 59);
        packet.writeBoolean(false);
        packet.writeInt(entityREP.func_145782_y());
        packet.sendToChunk(entityREP.field_70170_p, (int)entityREP.field_70165_t >> 4, (int)entityREP.field_70161_v >> 4);
    }

    public static void sendTrackerUpdatePacketTo(EntityPlayerMP player, EntityWirelessTracker tracker) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 60);
        packet.writeInt(tracker.func_145782_y());
        packet.writeShort(tracker.freq);
        packet.writeBoolean(tracker.isAttachedToEntity());
        if (tracker.isAttachedToEntity()) {
            packet.writeInt(tracker.attachedEntity.func_145782_y());
            packet.writeFloat(tracker.attachedX);
            packet.writeFloat(tracker.attachedY);
            packet.writeFloat(tracker.attachedZ);
            packet.writeFloat(tracker.attachedYaw);
        } else {
            packet.writeFloat((float)tracker.field_70165_t);
            packet.writeFloat((float)tracker.field_70163_u);
            packet.writeFloat((float)tracker.field_70161_v);
            packet.writeFloat((float)tracker.field_70159_w);
            packet.writeFloat((float)tracker.field_70181_x);
            packet.writeFloat((float)tracker.field_70179_y);
            packet.writeShort(tracker.attachmentCounter);
            packet.writeBoolean(tracker.item);
        }
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendRemoveTrackerTo(EntityPlayerMP player, EntityWirelessTracker tracker) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 61);
        packet.writeBoolean(false);
        packet.writeInt(tracker.func_145782_y());
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendThrowTracker(EntityWirelessTracker tracker, EntityPlayer thrower) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 61);
        packet.writeBoolean(true);
        packet.writeInt(tracker.func_145782_y());
        packet.writeInt(thrower.func_145782_y());
        packet.writeShort(tracker.freq);
        packet.sendToChunk(thrower.field_70170_p, (int)thrower.field_70165_t >> 4, (int)thrower.field_70161_v >> 4);
    }
}

