/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.CommonUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.WRAddonSPH;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessBolt;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityREP
extends Entity {
    private int xTileREP = -1;
    private int yTileREP = -1;
    private int zTileREP = -1;
    private Block inTileREP;
    private boolean inGroundREP;
    public int shakeREP;
    public EntityLivingBase shootingEntity;
    private int ticksInGroundREP;
    private int ticksInAirREP;
    public final int maxbolts = 50;

    public EntityREP(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
    }

    protected void entityInit() {
    }

    public boolean isInRangeToRenderDist(double d) {
        return true;
    }

    public EntityREP(World world, EntityLivingBase entityliving) {
        super(world);
        this.shootingEntity = entityliving;
        this.setSize(0.25f, 0.25f);
        this.setLocationAndAngles(entityliving.posX, entityliving.posY + (double)entityliving.getEyeHeight(), entityliving.posZ, entityliving.rotationYaw, entityliving.rotationPitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * 3.141593f)) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * 3.141593f)) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        float f = 0.4f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * 3.141593f)) * f;
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * 3.141593f)) * f;
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * 3.141593f)) * f;
        this.setREPHeading(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    public EntityREP(World world, double d, double d1, double d2) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.setPosition(d, d1, d2);
    }

    public void setREPHeading(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.sqrt_double((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d2 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        this.motionX = d *= (double)f;
        this.motionY = d1 *= (double)f;
        this.motionZ = d2 *= (double)f;
        float f3 = MathHelper.sqrt_double((double)(d * d + d2 * d2));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.ticksInGroundREP = 0;
    }

    public void setVelocity(double d, double d1, double d2) {
        this.motionX = d;
        this.motionY = d1;
        this.motionZ = d2;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(d * d + d2 * d2));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f) * 180.0 / 3.1415927410125732);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUpdate() {
        block16: {
            this.lastTickPosX = this.posX;
            this.lastTickPosY = this.posY;
            this.lastTickPosZ = this.posZ;
            super.onUpdate();
            if (this.shakeREP > 0) {
                --this.shakeREP;
            }
            if (this.inGroundREP) {
                Block block = this.worldObj.getBlock(this.xTileREP, this.yTileREP, this.zTileREP);
                if (block != this.inTileREP) {
                    this.inGroundREP = false;
                    this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                    this.ticksInGroundREP = 0;
                    this.ticksInAirREP = 0;
                    break block16;
                } else {
                    ++this.ticksInGroundREP;
                    if (this.ticksInGroundREP == 1200) {
                        this.setDead();
                    }
                    return;
                }
            }
            ++this.ticksInAirREP;
        }
        Vec3 vec3d = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        Vec3 vec3d1 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec3d, vec3d1);
        vec3d = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        vec3d1 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        if (movingobjectposition != null) {
            vec3d1 = Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord);
        }
        if (!this.worldObj.isRemote) {
            Entity entity = null;
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d = 0.0;
            for (Entity entity1 : list) {
                double d1;
                float f4;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                if (!entity1.canBeCollidedWith() || entity1 == this.shootingEntity && this.ticksInAirREP < 5 || (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.expand((double)(f4 = 0.3f), (double)f4, (double)f4)).calculateIntercept(vec3d, vec3d1)) == null || !((d1 = vec3d.distanceTo(movingobjectposition1.hitVec)) < d) && d != 0.0) continue;
                entity = entity1;
                d = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
        }
        if (movingobjectposition != null) {
            this.detonate();
            this.setDead();
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f1 = 0.99f;
        float f2 = 0.03f;
        if (this.isInWater()) {
            for (int k = 0; k < 4; ++k) {
                float f3 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ);
            }
            f1 = 0.8f;
        }
        this.motionX *= (double)f1;
        this.motionY *= (double)f1;
        this.motionZ *= (double)f1;
        this.motionY -= (double)f2;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public void detonate() {
        WirelessBolt bolt;
        if (this.worldObj.isRemote) {
            return;
        }
        int boltsgen = 0;
        List entities = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, AxisAlignedBB.getBoundingBox((double)(this.posX - 10.0), (double)(this.posY - 10.0), (double)(this.posZ - 10.0), (double)(this.posX + 10.0), (double)(this.posY + 10.0), (double)(this.posZ + 10.0)));
        Iterator iterator = entities.iterator();
        while (iterator.hasNext() && boltsgen <= 50) {
            Entity target = (Entity)iterator.next();
            if (!(target instanceof EntityLivingBase) || Vector3.fromEntity((Entity)this).subtract(Vector3.fromEntity((Entity)target)).magSquared() > 100.0) continue;
            bolt = new WirelessBolt(this.worldObj, Vector3.fromEntity((Entity)this), Vector3.fromEntity((Entity)target), this.worldObj.rand.nextLong());
            bolt.defaultFractal();
            bolt.finalizeBolt();
            bolt = new WirelessBolt(this.worldObj, Vector3.fromEntity((Entity)this), Vector3.fromEntity((Entity)target), this.worldObj.rand.nextLong());
            bolt.defaultFractal();
            bolt.finalizeBolt();
            boltsgen += 2;
        }
        TreeSet<BlockCoord> nodes = RedstoneEther.server().getNodesInRangeofPoint(CommonUtils.getDimension((World)this.worldObj), Vector3.fromEntity((Entity)this), RedstoneEther.jammerrange, true);
        Iterator<BlockCoord> iterator2 = nodes.iterator();
        while (iterator2.hasNext() && boltsgen <= 50) {
            BlockCoord node = iterator2.next();
            ITileWireless tile = (ITileWireless)RedstoneEther.getTile(this.worldObj, node);
            WirelessBolt bolt2 = new WirelessBolt(this.worldObj, Vector3.fromEntity((Entity)this), tile, this.worldObj.rand.nextLong());
            bolt2.defaultFractal();
            bolt2.finalizeBolt();
            ++boltsgen;
        }
        for (int i = 0; i < 16 && boltsgen <= 50; ++boltsgen, ++i) {
            bolt = new WirelessBolt(this.worldObj, Vector3.fromEntity((Entity)this), new Vector3(this.posX + (double)(20.0f * this.worldObj.rand.nextFloat()) - 10.0, this.posY + (double)(20.0f * this.worldObj.rand.nextFloat()) - 10.0, this.posZ + (double)(20.0f * this.worldObj.rand.nextFloat()) - 10.0), this.worldObj.rand.nextLong());
            bolt.defaultFractal();
            bolt.finalizeBolt();
        }
    }

    public void setDead() {
        super.setDead();
        RedstoneEtherAddons.get(this.worldObj.isRemote).invalidateREP((EntityPlayer)this.shootingEntity);
        if (!this.worldObj.isRemote) {
            WRAddonSPH.sendKillREP(this);
        }
    }

    public void writeEntityToNBT(NBTTagCompound tag) {
        tag.setShort("xTile", (short)this.xTileREP);
        tag.setShort("yTile", (short)this.yTileREP);
        tag.setShort("zTile", (short)this.zTileREP);
        tag.setShort("inTile", (short)Block.getIdFromBlock((Block)this.inTileREP));
        tag.setByte("shake", (byte)this.shakeREP);
        tag.setByte("inGround", (byte)(this.inGroundREP ? 1 : 0));
    }

    public void readEntityFromNBT(NBTTagCompound tag) {
        this.xTileREP = tag.getShort("xTile");
        this.yTileREP = tag.getShort("yTile");
        this.zTileREP = tag.getShort("zTile");
        this.inTileREP = Block.getBlockById((int)(tag.getShort("inTile") & 0xFFFF));
        this.shakeREP = tag.getByte("shake") & 0xFF;
        this.inGroundREP = tag.getByte("inGround") == 1;
    }

    public float getShadowSize() {
        return 0.0f;
    }
}

