/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.WirelessRedstoneAddons;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EntityWirelessTracker
extends Entity
implements WirelessTransmittingDevice {
    String attachedPlayerName;
    boolean attached;
    boolean item;
    float attachedX;
    float attachedY;
    float attachedZ;
    float attachedYaw;
    int attachmentCounter = 2;
    int freq;
    boolean loaded;
    public Entity attachedEntity;
    public static final double torad = 0.017453;
    public static final double todeg = 57.295779;

    public EntityWirelessTracker(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
    }

    public EntityWirelessTracker(World world, int freq) {
        this(world);
        this.freq = freq;
    }

    public EntityWirelessTracker(World world, int freq, EntityLivingBase entityliving) {
        this(world, freq);
        this.setLocationAndAngles(entityliving.posX, entityliving.posY + (double)entityliving.getEyeHeight(), entityliving.posZ, entityliving.rotationYaw, entityliving.rotationPitch);
        float speed = 1.3f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * 3.141593f)) * speed;
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * 3.141593f)) * speed;
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * 3.141593f)) * speed;
        this.freq = freq;
    }

    protected void entityInit() {
    }

    public boolean isInRangeToRenderDist(double d) {
        return true;
    }

    public void onEntityUpdate() {
        if (this.attachmentCounter < -6000 && !this.attached || !this.worldObj.isRemote && this.attachedInOtherDimension()) {
            this.setDead();
            return;
        }
        if (!this.loaded && !this.worldObj.isRemote) {
            this.loaded = true;
            RedstoneEtherAddons.server().addTracker(this);
            if (!this.attachedToLogout()) {
                RedstoneEther.server().addTransmittingDevice(this);
            }
        }
        this.boundingBox.setBB(this.boundingBox.expand(0.0, 0.2, 0.0));
        super.onEntityUpdate();
        this.boundingBox.setBB(this.boundingBox.expand(0.0, -0.2, 0.0));
        if (this.attached && this.attachedEntity == null) {
            if (!this.worldObj.isRemote) {
                this.findAttachedEntity();
            }
        } else if (this.isAttachedToEntity()) {
            this.trackEntity();
            if (!this.worldObj.isRemote) {
                this.checkDetachment();
            }
        } else {
            this.applyPhysics();
            this.moveEntityWithBounce(1.0);
            if (!this.worldObj.isRemote) {
                this.attachToNearbyEntities();
            }
        }
        if (this.item && this.attachmentCounter == 0) {
            this.item = false;
            if (!this.worldObj.isRemote) {
                RedstoneEtherAddons.server().updateTracker(this);
            }
        }
        if (this.isBurning()) {
            this.extinguish();
            if (!this.worldObj.isRemote) {
                RedstoneEtherAddons.server().updateTracker(this);
            }
            this.item = true;
            this.attachmentCounter = 1200;
        }
        if (!this.attachedToLogout()) {
            --this.attachmentCounter;
        }
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource == DamageSource.lava || par1DamageSource == DamageSource.outOfWorld) {
            this.setDead();
            return true;
        }
        return false;
    }

    public void setDead() {
        super.setDead();
        if (!this.worldObj.isRemote) {
            RedstoneEther.server().removeTransmittingDevice(this);
            RedstoneEtherAddons.server().removeTracker(this);
        }
    }

    public void onCollideWithPlayer(EntityPlayer par1EntityPlayer) {
        if (!this.worldObj.isRemote && this.item && par1EntityPlayer.inventory.addItemStackToInventory(new ItemStack((Item)WirelessRedstoneAddons.tracker, 1, this.freq))) {
            this.worldObj.playSoundAtEntity((Entity)this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            par1EntityPlayer.onItemPickup((Entity)this, 1);
            this.setDead();
        }
    }

    private void checkDetachment() {
        int z;
        int y;
        int x;
        if (this.attachedEntity.isDead && this.attachedPlayerName != null) {
            this.attachedEntity = null;
            RedstoneEther.server().removeTransmittingDevice(this);
            return;
        }
        if (this.attachedEntity.isBurning() || this.attachedEntity.isDead) {
            this.detachFromEntity();
        }
        if (this.isRetractingStickyPistonFacing(x = MathHelper.floor_double((double)this.posX), (y = MathHelper.floor_double((double)(this.posY + (double)(this.height / 2.0f)))) + 2, z = MathHelper.floor_double((double)this.posZ), 0) || this.isRetractingStickyPistonFacing(x, y - 2, z, 1) || this.isRetractingStickyPistonFacing(x, y, z + 2, 2) || this.isRetractingStickyPistonFacing(x, y, z - 2, 3) || this.isRetractingStickyPistonFacing(x + 2, y, z, 4) || this.isRetractingStickyPistonFacing(x - 2, y, z, 5)) {
            this.detachFromEntity();
        }
    }

    public boolean isRetractingStickyPistonFacing(int x, int y, int z, int facing) {
        Block block = this.worldObj.getBlock(x, y, z);
        if (block != Blocks.piston_extension) {
            return false;
        }
        TileEntity t = this.worldObj.getTileEntity(x, y, z);
        if (!(t instanceof TileEntityPiston)) {
            return false;
        }
        TileEntityPiston tep = (TileEntityPiston)t;
        return tep.getPistonOrientation() == facing && !tep.isExtending() && tep.getStoredBlockID() == Blocks.sticky_piston;
    }

    private void detachFromEntity() {
        this.attachedEntity = null;
        this.attached = false;
        this.attachedX = 0.0f;
        this.attachedY = 0.0f;
        this.attachedZ = 0.0f;
        this.attachedYaw = 0.0f;
        this.attachmentCounter = 5;
        this.attachedPlayerName = null;
        this.motionX = (double)this.rand.nextFloat() - 0.5;
        this.motionY = (double)this.rand.nextFloat() - 0.5;
        this.motionZ = (double)this.rand.nextFloat() - 0.5;
        RedstoneEtherAddons.server().updateTracker(this);
    }

    private void trackEntity() {
        Vector3 relPos = this.getRotatedAttachment();
        this.setPosition(this.attachedEntity.posX + relPos.x, this.attachedEntity.posY + (double)(this.attachedEntity.height / 2.0f) - (double)this.attachedEntity.yOffset + relPos.y - (double)this.height, this.attachedEntity.posZ + relPos.z);
    }

    private void applyPhysics() {
        this.motionY -= 0.05;
        if (this.onGround) {
            this.motionX *= 0.8;
            this.motionZ *= 0.8;
        }
        this.func_145771_j(this.posX, this.posY + (double)(this.height / 2.0f), this.posZ);
    }

    private void attachToNearbyEntities() {
        if (this.isAttachedToEntity() || this.item || this.attachmentCounter > 0) {
            return;
        }
        for (Entity entity : this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, AxisAlignedBB.getBoundingBox((double)-10.0, (double)-10.0, (double)-10.0, (double)10.0, (double)10.0, (double)10.0).offset(this.posX, this.posY, this.posZ))) {
            AxisAlignedBB bb = entity.boundingBox;
            if (bb == null || !((double)entity.width >= 0.3) || !this.tryAttach(entity, 0.4, 0.2)) continue;
            return;
        }
    }

    private boolean tryAttach(Entity entity, double extraw, double extrah) {
        Vector3 evec = Vector3.fromEntityCenter((Entity)entity);
        Vector3 posVec = new Vector3(this.posX, this.posY + (double)(this.height / 2.0f), this.posZ);
        Vector3 lastPosVec = new Vector3(this.lastTickPosX, this.lastTickPosY + (double)(this.height / 2.0f), this.lastTickPosZ);
        Vector3 diffVec = lastPosVec.copy().subtract(posVec);
        double distanceBetweenTicks = diffVec.mag();
        double width = (double)entity.width + extraw;
        double height = (double)entity.height + extrah;
        for (double d = 0.0; d <= distanceBetweenTicks; d += 0.05) {
            Vector3 interpVec = diffVec.copy().normalize().multiply(d).add(lastPosVec);
            double xDiff = Math.abs(evec.x - interpVec.x);
            double yDiff = Math.abs(evec.y - interpVec.y);
            double zDiff = Math.abs(evec.z - interpVec.z);
            if (!(yDiff <= height / 2.0) || !(xDiff <= width / 2.0) || !(zDiff <= width / 2.0)) continue;
            this.attachToEntity(interpVec, entity);
            return true;
        }
        return false;
    }

    public void attachToEntity(Vector3 pos, Entity e) {
        this.attached = true;
        this.attachedEntity = e;
        this.attachedX = (float)(pos.x - e.posX);
        this.attachedY = (float)(pos.y + (double)(this.height / 2.0f) - (e.posY - (double)e.yOffset + (double)(e.height / 2.0f)));
        this.attachedZ = (float)(pos.z - e.posZ);
        this.attachedYaw = this.getEntityRotation();
        if (this.attachedEntity instanceof EntityPlayer) {
            this.attachedPlayerName = this.attachedEntity.getCommandSenderName();
        }
        this.moveToEntityExterior();
        RedstoneEtherAddons.server().updateTracker(this);
    }

    private void moveToEntityExterior() {
        Vector3 attachPosVec2 = this.getRotatedAttachment().normalize().multiply((double)Math.max(this.attachedEntity.width, this.attachedEntity.height));
        Vector3 diffVec = attachPosVec2.copy().negate();
        double distanceBetweenTicks = diffVec.mag();
        double width = this.attachedEntity.width;
        double height = this.attachedEntity.height;
        for (double d = 0.0; d <= distanceBetweenTicks; d += 0.05) {
            Vector3 interpVec = diffVec.copy().normalize().multiply(d).add(attachPosVec2);
            double xDiff = Math.abs(interpVec.x);
            double yDiff = Math.abs(interpVec.y);
            double zDiff = Math.abs(interpVec.z);
            if (!(yDiff <= height / 2.0) || !(xDiff <= width / 2.0) || !(zDiff <= width / 2.0)) continue;
            this.attachedYaw = this.getEntityRotation();
            this.attachedX = (float)interpVec.x;
            this.attachedY = (float)interpVec.y;
            this.attachedZ = (float)interpVec.z;
            return;
        }
    }

    public boolean isAttachedToEntity() {
        return this.attachedEntity != null;
    }

    public void moveEntityWithBounce(double bounceFactor) {
        double dx = this.motionX;
        double dz = this.motionZ;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.setPosition(this.posX, this.posY, this.posZ);
        boolean isCollidedX = this.motionX != dx;
        boolean isCollidedZ = this.motionZ != dz;
        this.motionX = dx;
        this.motionZ = dz;
        if (isCollidedX) {
            this.motionX *= -bounceFactor;
            this.posX += Math.signum(this.motionX) * 0.1;
        }
        if (isCollidedZ) {
            this.motionZ *= -bounceFactor;
            this.posZ += Math.signum(this.motionZ) * 0.1;
        }
        this.func_145771_j(this.posX, this.posY + (double)(this.height / 2.0f), this.posZ);
    }

    private void findAttachedEntity() {
        if (this.attachmentCounter == 0) {
            this.detachFromEntity();
            return;
        }
        if (this.attachedPlayerName != null) {
            EntityPlayerMP player = ServerUtils.getPlayer((String)this.attachedPlayerName);
            if (player != null) {
                this.attachedEntity = player;
                this.moveToEntityExterior();
                RedstoneEther.server().addTransmittingDevice(this);
                this.attachmentCounter = 0;
                return;
            }
        } else {
            for (Entity entity : this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, AxisAlignedBB.getBoundingBox((double)-10.0, (double)-10.0, (double)-10.0, (double)10.0, (double)10.0, (double)10.0).offset(this.posX, this.posY, this.posZ))) {
                if (!this.tryAttach(entity, 0.4, 0.2)) continue;
                this.attachmentCounter = 0;
                return;
            }
            --this.attachmentCounter;
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setBoolean("attached", this.attached);
        nbttagcompound.setShort("attachCount", (short)this.attachmentCounter);
        nbttagcompound.setBoolean("item", this.item);
        nbttagcompound.setShort("freq", (short)this.freq);
        if (this.attachedPlayerName != null) {
            nbttagcompound.setString("player", this.attachedPlayerName);
            nbttagcompound.setFloat("attachedX", this.attachedX);
            nbttagcompound.setFloat("attachedY", this.attachedY);
            nbttagcompound.setFloat("attachedZ", this.attachedZ);
            nbttagcompound.setFloat("attachedYaw", this.attachedYaw);
        }
    }

    public void onChunkUnload() {
        if (!this.worldObj.isRemote) {
            RedstoneEther.server().removeTransmittingDevice(this);
            RedstoneEtherAddons.server().removeTracker(this);
        }
    }

    public boolean attachedInOtherDimension() {
        return this.attachedEntity instanceof EntityPlayer && ((EntityPlayer)this.attachedEntity).dimension != this.getDimension();
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.attached = nbttagcompound.getBoolean("attached");
        this.attachmentCounter = nbttagcompound.getShort("attachCount");
        this.freq = nbttagcompound.getShort("freq");
        this.item = nbttagcompound.getBoolean("item");
        if (nbttagcompound.hasKey("player")) {
            this.attachedPlayerName = nbttagcompound.getString("player");
            this.attachedX = nbttagcompound.getFloat("attachedX");
            this.attachedY = nbttagcompound.getFloat("attachedY");
            this.attachedZ = nbttagcompound.getFloat("attachedZ");
            this.attachedYaw = nbttagcompound.getFloat("attachedYaw");
        }
        if (this.attached) {
            this.attachmentCounter = 5;
        }
    }

    public float getShadowSize() {
        return 0.0f;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public Vector3 getRotatedAttachment() {
        Vector3 relPos = new Vector3((double)this.attachedX, (double)this.attachedY, (double)this.attachedZ);
        Quat rot = Quat.aroundAxis((double)0.0, (double)1.0, (double)0.0, (double)((double)(this.getEntityRotation() - this.attachedYaw) * 0.017453));
        rot.rotate(relPos);
        return relPos;
    }

    public float getEntityRotation() {
        if (this.attachedEntity instanceof EntityLivingBase) {
            return -((EntityLivingBase)this.attachedEntity).renderYawOffset;
        }
        return this.attachedEntity.rotationYaw;
    }

    public boolean attachedToLogout() {
        return this.attached && this.attachedEntity == null && this.attachedPlayerName != null;
    }

    public void copyToDimension(int dimension) {
        WorldServer otherWorld = DimensionManager.getWorld((int)dimension);
        EntityWirelessTracker copy = new EntityWirelessTracker((World)otherWorld, this.freq);
        copy.attached = true;
        copy.attachedPlayerName = this.attachedPlayerName;
        copy.attachedX = this.attachedX;
        copy.attachedY = this.attachedY;
        copy.attachedZ = this.attachedZ;
        copy.attachedYaw = this.attachedYaw;
        copy.setPosition(this.attachedEntity.posX, this.attachedEntity.posY, this.attachedEntity.posZ);
        otherWorld.spawnEntityInWorld((Entity)copy);
    }

    @Override
    public EntityLivingBase getAttachedEntity() {
        if (this.attachedEntity instanceof EntityLivingBase) {
            return (EntityLivingBase)this.attachedEntity;
        }
        return null;
    }

    @Override
    public Vector3 getPosition() {
        return Vector3.fromEntityCenter((Entity)this);
    }

    @Override
    public int getDimension() {
        return CommonUtils.getDimension((World)this.worldObj);
    }

    @Override
    public int getFreq() {
        return this.freq;
    }
}

