/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.render.CCRenderState;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.core.RedstoneEther;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class GuiWirelessSniffer
extends GuiScreen {
    public String title = "Wireless Sniffer";
    private int page = 0;
    private byte[] ethercopy = new byte[625];
    protected byte[] brightness = new byte[5000];
    public static int xSize = 256;
    public static int ySize = 200;
    public static ColourARGB colourOn;
    public static ColourARGB colourOff;
    public static ColourARGB colourPOn;
    public static ColourARGB colourPOff;
    public static ColourARGB colourJammed;
    public static ColourARGB borderOn;
    public static ColourARGB borderOff;
    public static ColourARGB borderPOn;
    public static ColourARGB borderPOff;
    public static ColourARGB borderJammed;
    public static final int blocksize = 5;

    public void initGui() {
        this.buttonList.add(new GuiButton(0, this.width / 2 + 40, this.height / 2 + 75, 50, 20, "Next"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 90, this.height / 2 + 75, 50, 20, "Prev"));
        super.initGui();
    }

    protected void actionPerformed(GuiButton guibutton) {
        switch (guibutton.id) {
            case 0: {
                ++this.page;
                break;
            }
            case 1: {
                --this.page;
            }
        }
        if (this.page < 0) {
            this.page = 4;
        } else if (this.page > 4) {
            this.page = 0;
        }
    }

    public int getFreqMouseOver(int mousex, int mousey) {
        int xfreq = (mousex - ((this.width - xSize) / 2 + 8)) / 6;
        int yfreq = (mousey - ((this.height - ySize) / 2 + 24)) / 6;
        if (xfreq < 0 || xfreq >= 40 || yfreq < 0 || yfreq >= 25) {
            return 0;
        }
        return this.page * 1000 + 1 + yfreq * 40 + xfreq;
    }

    public void drawScreen(int mousex, int mousey, float partialframe) {
        this.drawDefaultBackground();
        int backtexx = (this.width - xSize) / 2;
        int backtexy = (this.height - ySize) / 2;
        int startfreq = this.page * 1000 + 1;
        int endfreq = (this.page + 1) * 1000;
        if (endfreq > 5000) {
            endfreq = 5000;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CCRenderState.changeTexture((String)"wrcbe_addons:textures/gui/sniffer.png");
        this.drawTexturedModalRect(backtexx, backtexy, 0, 0, xSize, ySize);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)backtexx, (float)backtexy, (float)0.0f);
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.fontRendererObj.drawString(this.title, xSize / 2 - this.fontRendererObj.getStringWidth(this.title) / 2, 10, 0x404040);
        this.drawFrequencies(8, 24, startfreq);
        String rangestring = "" + startfreq + " - " + endfreq;
        this.fontRendererObj.drawString(rangestring, xSize / 2 - this.fontRendererObj.getStringWidth(rangestring) / 2, 181, 0x404040);
        GL11.glPopMatrix();
        int freq = this.getFreqMouseOver(mousex, mousey);
        if (freq != 0) {
            String freqname = this.getFreqTip(freq);
            int width = this.fontRendererObj.getStringWidth(freqname);
            this.drawGradientRect(mousex, mousey - 12, mousex + width + 3, mousey, -1073741824, -1073741824);
            this.fontRendererObj.drawStringWithShadow(freqname, mousex + 2, mousey - 10, -1);
        }
        super.drawScreen(mousex, mousey, partialframe);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public String getFreqTip(int freq) {
        String name = RedstoneEther.get(true).getFreqName(freq);
        return Integer.toString(freq) + (name == null || name.equals("") ? "" : " " + name);
    }

    public Colour getColour(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((EntityPlayer)this.mc.thePlayer) || !RedstoneEther.get(true).canBroadcastOnFrequency((EntityPlayer)this.mc.thePlayer, freq)) {
            return colourJammed;
        }
        return colourOff.copy().interpolate((Colour)colourOn, (double)((float)this.brightness[freq - 1] / 64.0f));
    }

    public Colour getBorder(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((EntityPlayer)this.mc.thePlayer) || !RedstoneEther.get(true).canBroadcastOnFrequency((EntityPlayer)this.mc.thePlayer, freq)) {
            return borderJammed;
        }
        if (RedstoneEther.get(true).getFreqColourId(freq) != -1) {
            return new ColourARGB(RedstoneEther.get(true).getFreqColour(freq));
        }
        return borderOff.copy().interpolate((Colour)borderOn, (double)((float)this.brightness[freq - 1] / 64.0f));
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    private void drawFrequencies(int xstart, int ystart, int freqstart) {
        int freq = freqstart;
        for (int yfreq = 0; yfreq < 25; ++yfreq) {
            for (int xfreq = 0; xfreq < 40; ++xfreq) {
                if (freq > 5000) {
                    return;
                }
                int x = xstart + 6 * xfreq;
                int y = ystart + 6 * yfreq;
                GuiWirelessSniffer.drawRect((int)x, (int)y, (int)(x + 5), (int)(y + 5), (int)this.getBorder(freq).argb());
                GuiWirelessSniffer.drawRect((int)(x + 1), (int)(y + 1), (int)(x + 5 - 1), (int)(y + 5 - 1), (int)this.getColour(freq).argb());
                ++freq;
            }
        }
    }

    public void onGuiClosed() {
        RedstoneEtherAddons.client().remSniffer((EntityPlayer)this.mc.thePlayer);
    }

    public void updateScreen() {
        super.updateScreen();
        for (int freq = 0; freq < 5000; ++freq) {
            if ((this.ethercopy[freq >> 3] & 1 << (freq & 7)) != 0) {
                if (this.brightness[freq] < 1) {
                    this.brightness[freq] = 1;
                }
                this.brightness[freq] = 64;
                if ((this.brightness[freq] & 0xFF) <= 64) continue;
                this.brightness[freq] = 64;
                continue;
            }
            int n = freq;
            this.brightness[n] = (byte)((double)this.brightness[n] * 0.9);
        }
    }

    public void setEtherCopy(byte[] copy) {
        this.ethercopy = copy;
    }

    public void setEtherFreq(int freq, boolean state) {
        --freq;
        if (state) {
            int n = freq >> 3;
            this.ethercopy[n] = (byte)(this.ethercopy[n] | 1 << (freq & 7));
            this.brightness[freq] = 64;
        } else {
            int n = freq >> 3;
            this.ethercopy[n] = (byte)(this.ethercopy[n] & (1 << (freq & 7) ^ 0xFF));
        }
    }

    public static void loadColours(ConfigTag addonconfig) {
        ConfigTag snifferconifg = addonconfig.getTag("sniffer.gui").useBraces();
        ConfigTag colourconfig = snifferconifg.getTag("colour").setPosition(0).setComment("Colours are in 0xAARRGGBB format:Alpha should be FF");
        ConfigTag borderconfig = snifferconifg.getTag("border").setPosition(1).setNewLine(true);
        colourOn = new ColourARGB(colourconfig.getTag("on").setPosition(0).setComment("").getHexValue(-65536));
        colourOff = new ColourARGB(colourconfig.getTag("off").setPosition(1).getHexValue(-9437184));
        colourJammed = new ColourARGB(colourconfig.getTag("jammed").setPosition(2).getHexValue(-9408400));
        colourPOn = new ColourARGB(colourconfig.getTag("private.on").setPosition(0).getHexValue(-12521472));
        colourPOff = new ColourARGB(colourconfig.getTag("private.off").setPosition(1).getHexValue(-12541952));
        borderOn = new ColourARGB(borderconfig.getTag("on").setPosition(0).getHexValue(-1179648));
        borderOff = new ColourARGB(borderconfig.getTag("off").setPosition(1).getHexValue(-11534336));
        borderJammed = new ColourARGB(borderconfig.getTag("jammed").setPosition(2).getHexValue(-11513776));
        borderPOn = new ColourARGB(borderconfig.getTag("private.on").setPosition(0).getHexValue(-14622720));
        borderPOff = new ColourARGB(borderconfig.getTag("private.off").setPosition(1).getHexValue(-14643200));
    }
}

