/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.WRAddonSPH;
import codechicken.wirelessredstone.core.ItemWirelessFreq;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemWirelessTracker
extends ItemWirelessFreq {
    public ItemWirelessTracker() {
        this.setMaxStackSize(1);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer player) {
        if (player.isSneaking()) {
            return super.onItemRightClick(itemstack, world, player);
        }
        if (this.getItemFreq(itemstack) == 0) {
            return itemstack;
        }
        if (!player.capabilities.isCreativeMode) {
            --itemstack.stackSize;
        }
        if (!world.isRemote) {
            world.playSoundAtEntity((Entity)player, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            EntityWirelessTracker tracker = new EntityWirelessTracker(world, this.getItemFreq(itemstack), (EntityLivingBase)player);
            world.spawnEntityInWorld((Entity)tracker);
            WRAddonSPH.sendThrowTracker(tracker, player);
        }
        return itemstack;
    }

    @Override
    public int getItemFreq(ItemStack itemstack) {
        return itemstack.getItemDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public String getItemStackDisplayName(ItemStack itemstack) {
        return RedstoneEtherAddons.localizeWirelessItem(StatCollector.translateToLocal((String)"wrcbe_addons.tracker.short"), itemstack.getItemDamage());
    }

    @Override
    public String getGuiName() {
        return StatCollector.translateToLocal((String)"item.wrcbe_addons:tracker.name");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
    }
}

