/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.wirelessredstone.addons.ClientMapInfo;
import codechicken.wirelessredstone.addons.EntityREP;
import codechicken.wirelessredstone.addons.ItemWirelessRemote;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.Remote;
import codechicken.wirelessredstone.addons.TriangFreqManager;
import codechicken.wirelessredstone.addons.WRAddonCPH;
import codechicken.wirelessredstone.addons.WirelessMapNodeStorage;
import codechicken.wirelessredstone.addons.WirelessRedstoneAddons;
import codechicken.wirelessredstone.core.IGuiRemoteUseable;
import codechicken.wirelessredstone.core.ItemWirelessFreq;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessRedstoneCore;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import org.lwjgl.input.Mouse;

public class RedstoneEtherClientAddons
extends RedstoneEtherAddons {
    private boolean mousedown;
    private boolean wasmousedown;
    private Remote remote;
    private TriangFreqManager[] triangFreqs;
    private HashMap<Short, ClientMapInfo> clientMapInfoSet = new HashMap();
    private WirelessMapNodeStorage wirelessmapnodes;
    private EntityREP activeREP;
    private int REPThrowTimeout;
    private int ticksInGui;

    public RedstoneEtherClientAddons() {
        this.triangFreqs = new TriangFreqManager[5001];
        for (int freq = 1; freq <= 5000; ++freq) {
            this.triangFreqs[freq] = new TriangFreqManager(freq);
        }
    }

    public void updateTriangulators(EntityPlayer player) {
        for (int freq = 1; freq <= 5000; ++freq) {
            this.triangFreqs[freq].tickTriang(player);
        }
    }

    public boolean isTriangOn(int freq) {
        return this.triangFreqs[freq].isTriangOn();
    }

    public float getTriangAngle(int freq) {
        return this.triangFreqs[freq].getTriangAngle();
    }

    public void setTriangAngle(int freq, float angle) {
        this.triangFreqs[freq].setTriangAngle(angle);
    }

    public void setTriangRequired(EntityPlayer player, int freq, boolean required) {
        WRAddonCPH.sendSyncTriang(freq, required);
    }

    @Override
    public boolean isRemoteOn(EntityPlayer player, int freq) {
        return this.remote == null ? false : this.remote.getFreq() == freq;
    }

    public int getRemoteFreq(EntityPlayer player) {
        return this.remote == null ? -1 : this.remote.getFreq();
    }

    public void checkClicks() {
        this.wasmousedown = this.mousedown;
        this.mousedown = Mouse.isButtonDown((int)1);
    }

    public void openItemGui(EntityPlayer player) {
        ItemStack helditem = player.inventory.getCurrentItem();
        if (helditem != null && helditem.getItem() instanceof ItemWirelessFreq && this.mousedown && !this.wasmousedown && player.isSneaking()) {
            WirelessRedstoneCore.proxy.openItemWirelessGui(player);
        }
    }

    public void processRemote(World world, EntityPlayer player, GuiScreen currentscreen, MovingObjectPosition mop) {
        boolean jammed = RedstoneEther.client().isPlayerJammed(player);
        if (this.remote != null && (!this.mousedown || currentscreen != null && !(currentscreen instanceof IGuiRemoteUseable) || jammed)) {
            this.deactivateRemote(world, player);
        }
        if (this.mouseClicked() && this.remote == null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() == WirelessRedstoneAddons.remote && currentscreen != null && currentscreen instanceof IGuiRemoteUseable && !player.isSneaking() && this.ticksInGui > 0 && !jammed) {
            ItemStack stack = player.inventory.getCurrentItem();
            if (stack.getItemDamage() == 0 || ItemWirelessRemote.getTransmitting(stack)) {
                return;
            }
            this.activateRemote(world, player);
        }
    }

    @Override
    public void activateRemote(World world, EntityPlayer player) {
        if (this.remote != null) {
            if (this.remote.isBeingHeld()) {
                return;
            }
            this.deactivateRemote(world, player);
        }
        if (RedstoneEther.client().isPlayerJammed(player)) {
            return;
        }
        this.remote = new Remote(player);
        this.remote.metaOn();
        WRAddonCPH.sendSetRemote(true);
    }

    @Override
    public boolean deactivateRemote(World world, EntityPlayer player) {
        if (this.remote == null) {
            return false;
        }
        this.remote.metaOff();
        this.remote = null;
        WRAddonCPH.sendSetRemote(false);
        return true;
    }

    public void addSniffer(EntityPlayer player) {
        WRAddonCPH.sendOpenSniffer();
    }

    public void remSniffer(EntityPlayer player) {
        WRAddonCPH.sendCloseSniffer();
    }

    public WirelessMapNodeStorage getMapNodes() {
        if (this.wirelessmapnodes == null) {
            this.wirelessmapnodes = new WirelessMapNodeStorage();
        }
        return this.wirelessmapnodes;
    }

    public void updateSSPMap(World world, EntityPlayer player, MapData mapdata) {
        if (RedstoneEther.get(true).isPlayerJammed(player) || mapdata.dimension != player.dimension) {
            this.clearMapNodes(player);
            return;
        }
    }

    public void clearMapNodes(EntityPlayer player) {
        WRAddonCPH.sendResetMap();
        this.wirelessmapnodes = null;
    }

    public boolean mouseClicked() {
        return this.mousedown && !this.wasmousedown;
    }

    public ClientMapInfo getMPMapInfo(short mapid) {
        return this.clientMapInfoSet.get(mapid);
    }

    public void setMPMapInfo(short mapid, ClientMapInfo mapinfo) {
        this.clientMapInfoSet.put(mapid, mapinfo);
    }

    public void tick() {
        Minecraft mc = Minecraft.getMinecraft();
        this.checkClicks();
        this.updateTriangulators((EntityPlayer)mc.thePlayer);
        this.openItemGui((EntityPlayer)mc.thePlayer);
        this.processRemote((World)mc.theWorld, (EntityPlayer)mc.thePlayer, mc.currentScreen, mc.objectMouseOver);
        if (this.REPThrowTimeout > 0) {
            --this.REPThrowTimeout;
        }
        this.ticksInGui = mc.currentScreen == null ? 0 : ++this.ticksInGui;
    }

    public boolean detonateREP(EntityPlayer player) {
        if (this.activeREP == null) {
            return false;
        }
        if (this.activeREP.isDead) {
            this.activeREP = null;
            return false;
        }
        this.activeREP.detonate();
        this.activeREP.setDead();
        return true;
    }

    public void throwREP(ItemStack itemstack, World world, EntityPlayer player) {
        if (this.REPThrowTimeout > 0) {
            return;
        }
        if (!player.capabilities.isCreativeMode) {
            --itemstack.stackSize;
        }
        world.playSoundAtEntity((Entity)player, "random.bow", 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        this.activeREP = new EntityREP(world, (EntityLivingBase)player);
        world.spawnEntityInWorld((Entity)this.activeREP);
        this.REPThrowTimeout = 40;
    }

    @Override
    public void invalidateREP(EntityPlayer shootingEntity) {
        this.activeREP = null;
    }
}

