/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.addons.ItemWirelessRemote;
import codechicken.wirelessredstone.addons.WirelessRedstoneAddons;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class Remote
implements WirelessTransmittingDevice {
    EntityPlayer owner;
    int freq;
    int slot;

    public Remote(EntityPlayer owner) {
        this.owner = owner;
        this.freq = owner.inventory.getCurrentItem().getItemDamage() & 0x1FFF;
        this.slot = owner.inventory.currentItem;
    }

    @Override
    public EntityLivingBase getAttachedEntity() {
        return this.owner;
    }

    @Override
    public Vector3 getPosition() {
        return Vector3.fromEntityCenter((Entity)this.owner);
    }

    @Override
    public int getDimension() {
        return this.owner.dimension;
    }

    @Override
    public int getFreq() {
        return this.freq;
    }

    public boolean isBeingHeld() {
        ItemStack held = this.owner.inventory.getCurrentItem();
        return this.owner.inventory.currentItem == this.slot && held != null && held.getItem() == WirelessRedstoneAddons.remote && held.getItemDamage() == this.freq;
    }

    public void metaOff() {
        ItemStack stack = this.owner.inventory.getStackInSlot(this.slot);
        if (stack != null) {
            ItemWirelessRemote.setOn(stack, false);
        }
    }

    public void metaOn() {
        ItemStack stack = this.owner.inventory.getStackInSlot(this.slot);
        ItemWirelessRemote.setOn(stack, true);
    }
}

