/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.ManagedTextureFX;
import codechicken.lib.render.TextureUtils;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.core.RedstoneEther;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class TriangTexManager {
    private static Colour[] texRing;
    private static Colour[] texGrad;
    private static int[] imageData;
    private static ManagedTextureFX[] textures;
    private static ColourRGBA pr;
    private static ColourRGBA pb;
    private static ColourRGBA pg;
    private static ColourRGBA pd;
    private static HashMap<Integer, Integer> freqslotmap;
    private static LinkedList<Integer> freeslots;
    private static HashSet<Integer> activetextures;
    private static HashSet<Integer> visibletextures;
    private static ColourRGBA[] pointercolours;
    private static ColourRGBA[] pointersidecolours;

    public static void loadTextures() {
        texRing = TextureUtils.loadTextureColours((ResourceLocation)new ResourceLocation("wrcbe_addons", "textures/items/triangRing.png"));
        texGrad = TextureUtils.loadTextureColours((ResourceLocation)new ResourceLocation("wrcbe_addons", "textures/items/triangGrad.png"));
        TriangTexManager.processTexture(-1, 0);
    }

    public static IIcon getIconFromDamage(int damage) {
        return TriangTexManager.textures[TriangTexManager.getIconIndexFromDamage((int)damage)].texture;
    }

    public static int getIconIndexFromDamage(int freq) {
        if (freq == 0) {
            return 0;
        }
        visibletextures.add(freq);
        Integer iconindex = freqslotmap.get(freq);
        if (iconindex == null) {
            iconindex = TriangTexManager.allocateSlot(freq);
        }
        return iconindex;
    }

    private static int allocateSlot(int damage) {
        if (freeslots.isEmpty()) {
            throw new RuntimeException("More than 256 different triangulators!");
        }
        int slot = freeslots.remove(0);
        freqslotmap.put(damage, slot);
        return slot;
    }

    private static void processTexture(int freq, int iconindex) {
        int colour = freq <= 0 ? -1 : RedstoneEther.get(true).getFreqColour(freq);
        TriangTexManager.mergeTexturesWithColour(new ColourARGB(colour));
        if (freq > 0) {
            TriangTexManager.writePointer(freq);
        }
        textures[iconindex].setData(imageData);
    }

    private static void mergeTexturesWithColour(ColourARGB texcolour) {
        for (int i = 0; i < 256; ++i) {
            Colour colour = TriangTexManager.texGrad[i].a == 0 ? texRing[i] : texGrad[i].copy().multiply((Colour)texcolour);
            TriangTexManager.imageData[i] = colour.argb();
        }
    }

    private static void writePointer(int freq) {
        int p;
        int row;
        int col;
        int i;
        if (RedstoneEther.get(true).isPlayerJammed((EntityPlayer)Minecraft.getMinecraft().thePlayer) || !RedstoneEtherAddons.client().isTriangOn(freq)) {
            return;
        }
        int id = RedstoneEther.get(true).getFreqColourId(freq);
        ColourRGBA pcolour = id < 0 ? pr : pointercolours[id];
        ColourRGBA scolour = id < 0 ? pg : pointersidecolours[id];
        float angle = RedstoneEtherAddons.client().getTriangAngle(freq);
        double cos = MathHelper.cos((double)angle);
        double sin = MathHelper.sin((double)angle);
        for (i = -4; i <= 4; ++i) {
            col = (int)(8.5 + cos * (double)i * 0.3);
            row = (int)(7.5 - sin * (double)i * 0.3 * 0.5);
            p = row * 16 + col;
            TriangTexManager.imageData[p] = scolour.argb();
        }
        for (i = -8; i <= 16; ++i) {
            col = (int)(8.5 + sin * (double)i * 0.3);
            row = (int)(7.5 + cos * (double)i * 0.3 * 0.5);
            p = row * 16 + col;
            ColourRGBA c = i < 0 ? scolour : pcolour;
            TriangTexManager.imageData[p] = c.argb();
        }
    }

    public static void processAllTextures() {
        HashSet<Integer> wasActive = new HashSet<Integer>(activetextures);
        for (int freq : visibletextures) {
            int slot = freqslotmap.get(freq);
            if (!wasActive.remove(freq)) {
                RedstoneEtherAddons.client().setTriangRequired((EntityPlayer)Minecraft.getMinecraft().thePlayer, freq, true);
                freeslots.remove(slot);
                activetextures.add(freq);
            }
            TriangTexManager.processTexture(freq, slot);
        }
        for (int freq : wasActive) {
            RedstoneEtherAddons.client().setTriangRequired((EntityPlayer)Minecraft.getMinecraft().thePlayer, freq, false);
            freeslots.add(freqslotmap.get(freq));
            activetextures.remove(freq);
        }
        visibletextures.clear();
    }

    static {
        int i;
        texRing = new Colour[256];
        texGrad = new Colour[256];
        imageData = new int[256];
        textures = new ManagedTextureFX[256];
        pr = new ColourRGBA(-16776961);
        pb = new ColourRGBA(65535);
        pg = new ColourRGBA(-2139062017);
        pd = new ColourRGBA(0x404040FF);
        freqslotmap = new HashMap(256);
        freeslots = new LinkedList();
        activetextures = new HashSet(256);
        visibletextures = new HashSet(256);
        pointercolours = new ColourRGBA[]{pb, pr, pr, pr, pr, pr, pr, pr, pb, pr, pr, pr, pb, pb};
        pointersidecolours = new ColourRGBA[]{pg, pg, pg, pg, pg, pg, pd, pg, pd, pd, pd, pd, pg, pg};
        for (i = 1; i < textures.length; ++i) {
            freeslots.add(i);
        }
        for (i = 0; i < textures.length; ++i) {
            TriangTexManager.textures[i] = new ManagedTextureFX(16, "wrcbe_addons:triang_" + i);
            textures[i].setAtlas(1);
        }
    }
}

