/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.packet.PacketCustom;
import codechicken.wirelessredstone.addons.EntityREP;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.core.FreqCoord;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapData;

public class WRAddonSPH
implements PacketCustom.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, EntityPlayerMP sender, INetHandlerPlayServer handler) {
        this.handlePacket((WorldServer)sender.worldObj, sender, packet);
    }

    private void handlePacket(WorldServer world, EntityPlayerMP player, PacketCustom packet) {
        switch (packet.getType()) {
            case 50: {
                if (packet.readBoolean()) {
                    RedstoneEtherAddons.server().addSniffer((EntityPlayer)player);
                    break;
                }
                RedstoneEtherAddons.server().remSniffer((EntityPlayer)player);
                break;
            }
            case 51: {
                if (packet.readBoolean()) {
                    RedstoneEtherAddons.server().activateRemote((World)world, (EntityPlayer)player);
                    break;
                }
                RedstoneEtherAddons.server().deactivateRemote((World)world, (EntityPlayer)player);
                break;
            }
            case 52: {
                RedstoneEtherAddons.server().setTriangRequired((EntityPlayer)player, packet.readUShort(), packet.readBoolean());
                break;
            }
            case 58: {
                RedstoneEtherAddons.server().clearMapNodes((EntityPlayer)player);
            }
        }
    }

    public static void sendUpdateSnifferTo(EntityPlayer player, int freq, boolean on) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 53);
        packet.writeShort((int)((short)freq));
        packet.writeBoolean(on);
        packet.sendToPlayer(player);
    }

    public static void sendEtherCopyTo(EntityPlayer player, byte[] ethercopy) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 54);
        packet.writeShort(ethercopy.length);
        packet.writeByteArray(ethercopy);
        packet.sendToPlayer(player);
    }

    public static void sendTriangAngleTo(EntityPlayer player, int freq, float angle) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 55);
        packet.writeShort((int)((short)freq));
        packet.writeFloat(angle);
        packet.sendToPlayer(player);
    }

    public static void sendMapUpdatePacketTo(EntityPlayer player, int mapno, MapData mapdata, TreeSet<FreqCoord> addednodes, TreeSet<FreqCoord> removednodes, TreeSet<FreqCoord> remotes) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 57);
        packet.writeShort((int)((short)addednodes.size()));
        for (FreqCoord node : addednodes) {
            packet.writeShort((int)((short)node.x));
            packet.writeShort((int)((short)node.z));
            packet.writeShort((int)((short)node.freq));
        }
        packet.writeShort((int)((short)removednodes.size()));
        for (FreqCoord node : removednodes) {
            packet.writeShort((int)((short)node.x));
            packet.writeShort((int)((short)node.z));
            packet.writeShort((int)((short)node.freq));
        }
        packet.writeShort((int)((short)remotes.size()));
        for (FreqCoord node : remotes) {
            packet.writeInt(node.x);
            packet.writeInt(node.z);
            packet.writeShort((int)((short)node.freq));
        }
        packet.sendToPlayer(player);
    }

    public static void sendMapInfoTo(EntityPlayer player, int mapno, MapData mapdata) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 56);
        packet.writeShort((int)((short)mapno));
        packet.writeInt(mapdata.xCenter);
        packet.writeInt(mapdata.zCenter);
        packet.writeByte((int)mapdata.scale);
        packet.sendToPlayer(player);
    }

    public static void sendSpawnREP(EntityREP activeREP) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 59);
        packet.writeBoolean(true);
        packet.writeInt(activeREP.getEntityId());
        packet.writeInt(activeREP.shootingEntity.getEntityId());
        packet.sendToChunk(activeREP.worldObj, (int)activeREP.posX >> 4, (int)activeREP.posZ >> 4);
    }

    public static void sendKillREP(EntityREP entityREP) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 59);
        packet.writeBoolean(false);
        packet.writeInt(entityREP.getEntityId());
        packet.sendToChunk(entityREP.worldObj, (int)entityREP.posX >> 4, (int)entityREP.posZ >> 4);
    }

    public static void sendTrackerUpdatePacketTo(EntityPlayerMP player, EntityWirelessTracker tracker) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 60);
        packet.writeInt(tracker.getEntityId());
        packet.writeShort(tracker.freq);
        packet.writeBoolean(tracker.isAttachedToEntity());
        if (tracker.isAttachedToEntity()) {
            packet.writeInt(tracker.attachedEntity.getEntityId());
            packet.writeFloat(tracker.attachedX);
            packet.writeFloat(tracker.attachedY);
            packet.writeFloat(tracker.attachedZ);
            packet.writeFloat(tracker.attachedYaw);
        } else {
            packet.writeFloat((float)tracker.posX);
            packet.writeFloat((float)tracker.posY);
            packet.writeFloat((float)tracker.posZ);
            packet.writeFloat((float)tracker.motionX);
            packet.writeFloat((float)tracker.motionY);
            packet.writeFloat((float)tracker.motionZ);
            packet.writeShort(tracker.attachmentCounter);
            packet.writeBoolean(tracker.item);
        }
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendRemoveTrackerTo(EntityPlayerMP player, EntityWirelessTracker tracker) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 61);
        packet.writeBoolean(false);
        packet.writeInt(tracker.getEntityId());
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendThrowTracker(EntityWirelessTracker tracker, EntityPlayer thrower) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 61);
        packet.writeBoolean(true);
        packet.writeInt(tracker.getEntityId());
        packet.writeInt(thrower.getEntityId());
        packet.writeShort(tracker.freq);
        packet.sendToChunk(thrower.worldObj, (int)thrower.posX >> 4, (int)thrower.posZ >> 4);
    }
}

