/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.core.FreqCoord;
import codechicken.wirelessredstone.core.ITileJammer;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RedstoneEtherFrequency;
import codechicken.wirelessredstone.core.SaveManager;
import codechicken.wirelessredstone.core.WRCoreSPH;
import codechicken.wirelessredstone.core.WirelessReceivingDevice;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class RedstoneEtherServer
extends RedstoneEther {
    public RedstoneEtherServer() {
        super(false);
    }

    @Override
    public void init(World world) {
        super.init(world);
        SaveManager.resetWorld();
        SaveManager.loadFreqInfo();
        SaveManager.loadDimensionHash();
        this.publicfrequencyend = SaveManager.generalProp.getProperty("PublicFrequencies", 1000);
        this.sharedfrequencyend = SaveManager.generalProp.getProperty("SharedFrequencies", 5000);
        this.numprivatefreqs = SaveManager.generalProp.getProperty("PrivateFrequencies", 50);
    }

    @Override
    protected void addEther(World world, int dimension) {
        if (this.ethers.get(dimension) != null) {
            return;
        }
        super.addEther(world, dimension);
        SaveManager.reloadSave(dimension);
        SaveManager.getInstance(dimension).loadEther();
    }

    @Override
    public void remEther(World world, int dimension) {
        if (this.ethers.get(dimension) == null) {
            return;
        }
        super.remEther(world, dimension);
        SaveManager.unloadSave(dimension);
    }

    public void saveEther(World world) {
        int dimension = CommonUtils.getDimension((World)world);
        if (!this.ethers.containsKey(dimension)) {
            return;
        }
        for (RedstoneEtherFrequency freq : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave) {
            freq.saveFreq(dimension);
        }
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave.clear();
        SaveManager.getInstance(dimension).removeTrailingSectors();
        SaveManager.saveDimensionHash();
    }

    public void verifyChunkTransmitters(World world, int chunkx, int chunkz) {
        int dimension = CommonUtils.getDimension((World)world);
        RedstoneEther.DimensionalEtherHash ether = (RedstoneEther.DimensionalEtherHash)this.ethers.get(dimension);
        int blockxmin = chunkx * 16;
        int blockxmax = blockxmin + 15;
        int blockzmin = chunkz * 16;
        int blockzmax = blockzmin + 15;
        ArrayList<BlockCoord> transmittingblocks = new ArrayList<BlockCoord>(ether.transmittingblocks.keySet());
        for (BlockCoord node : transmittingblocks) {
            if (node.x < blockxmin || node.x > blockxmax || node.z < blockzmin || node.z > blockzmax) continue;
            TileEntity tile = RedstoneEther.getTile(world, node);
            int freq = ether.transmittingblocks.get((Object)node).freq;
            if (tile != null && tile instanceof ITileWireless && ((ITileWireless)tile).getFreq() == freq) continue;
            this.remTransmitter(world, node.x, node.y, node.z, freq);
            System.out.println("Removed Badly Synced node at:" + node.x + "," + node.y + "," + node.z + " on " + freq + " in dim" + dimension);
        }
    }

    public void setTransmitter(World world, int x, int y, int z, int freq, boolean on) {
        RedstoneEther.TXNodeInfo info;
        if (freq == 0) {
            return;
        }
        BlockCoord node = new BlockCoord(x, y, z);
        int dimension = CommonUtils.getDimension((World)world);
        if (this.isNodeInAOEofJammer(node, dimension)) {
            this.jamNodeSometime(world, node, dimension, freq);
        }
        if ((info = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.get(node)) == null) {
            ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.put(node, new RedstoneEther.TXNodeInfo(freq, on));
        } else {
            info.on = on;
        }
        this.freqarray[freq].setTransmitter(world, node, dimension, on);
    }

    public void remTransmitter(World world, int x, int y, int z, int freq) {
        if (freq == 0) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        BlockCoord node = new BlockCoord(x, y, z);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.remove(node);
        this.freqarray[freq].remTransmitter(world, node, dimension);
    }

    public void addReceiver(World world, int x, int y, int z, int freq) {
        if (freq == 0) {
            return;
        }
        BlockCoord node = new BlockCoord(x, y, z);
        int dimension = CommonUtils.getDimension((World)world);
        if (this.isNodeInAOEofJammer(node, dimension)) {
            this.jamNodeSometime(world, node, dimension, freq);
        }
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).recievingblocks.put(node, freq);
        this.freqarray[freq].addReceiver(world, node, dimension);
    }

    public void remReceiver(World world, int x, int y, int z, int freq) {
        if (freq == 0) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        BlockCoord node = new BlockCoord(x, y, z);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).recievingblocks.remove(node);
        this.freqarray[freq].remReceiver(world, node, dimension);
    }

    public void addJammer(World world, int x, int y, int z) {
        int dimension = CommonUtils.getDimension((World)world);
        BlockCoord jammer = new BlockCoord(x, y, z);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset.add(jammer);
        this.jamNodesInAOEOfJammer(world, jammer, dimension);
    }

    public void remJammer(World world, int x, int y, int z) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)CommonUtils.getDimension((World)world)))).jammerset.remove(new BlockCoord(x, y, z));
    }

    public boolean isNodeJammed(World world, int x, int y, int z) {
        Integer timeout = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)CommonUtils.getDimension((World)world)))).jammednodes.get(new BlockCoord(x, y, z));
        return timeout != null && timeout > 0;
    }

    public boolean isNodeInAOEofJammer(BlockCoord node, int dimension) {
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            if (RedstoneEtherServer.pythagorasPow2(jammer, node) >= jammerrangePow2) continue;
            return true;
        }
        return false;
    }

    public boolean isPointInAOEofJammer(Vector3 point, int dimension) {
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            if (!(RedstoneEtherServer.pythagorasPow2(jammer, point) < (double)jammerrangePow2)) continue;
            return true;
        }
        return false;
    }

    public BlockCoord getClosestJammer(BlockCoord node, int dimension) {
        BlockCoord closestjammer = null;
        double closestdist = jammerrangePow2;
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            double distance = RedstoneEtherServer.pythagorasPow2(jammer, node);
            if (!(distance < closestdist)) continue;
            closestjammer = jammer;
            closestdist = distance;
        }
        return closestjammer;
    }

    public BlockCoord getClosestJammer(Vector3 point, int dimension) {
        BlockCoord closestjammer = null;
        double closestdist = jammerrangePow2;
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            double distance = RedstoneEtherServer.pythagorasPow2(jammer, point);
            if (!(distance < closestdist)) continue;
            closestjammer = jammer;
            closestdist = distance;
        }
        return closestjammer;
    }

    public void jamNodeSometime(World world, BlockCoord node, int dimension, int freq) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.put(node, -world.rand.nextInt(jammerblockwait));
    }

    public void jamEntitySometime(EntityLivingBase entity) {
        this.jammedentities.put(entity, -entity.worldObj.rand.nextInt(jammerentitywait));
    }

    public void jamNode(World world, BlockCoord node, int dimension, int freq) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.put(node, RedstoneEtherServer.getRandomTimeout(world.rand));
        this.freqarray[freq].remTransmitter(world, node, dimension);
        this.freqarray[freq].remReceiver(world, node, dimension);
    }

    public void jamNode(World world, int x, int y, int z, int freq) {
        if (freq == 0) {
            return;
        }
        this.jamNode(world, new BlockCoord(x, y, z), CommonUtils.getDimension((World)world), freq);
    }

    @Override
    public void jamEntity(EntityLivingBase entity, boolean jam) {
        if (jam) {
            this.jammedentities.put(entity, RedstoneEtherServer.getRandomTimeout(entity.worldObj.rand));
        }
        if (entity instanceof EntityPlayer) {
            WRCoreSPH.sendJamPlayerPacketTo((EntityPlayer)entity, jam);
        }
    }

    public void jamNodesInAOEOfJammer(World world, BlockCoord jammer, int dimension) {
        for (int freq = 1; freq <= 5000; ++freq) {
            TreeMap<BlockCoord, Boolean> transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockCoord node : transmittermap.keySet()) {
                if (RedstoneEtherServer.pythagorasPow2(node, jammer) >= jammerrangePow2) continue;
                this.jamNodeSometime(world, node, dimension, freq);
            }
            TreeSet<BlockCoord> receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockCoord node : receiverset) {
                if (RedstoneEtherServer.pythagorasPow2(node, jammer) >= jammerrangePow2) continue;
                this.jamNodeSometime(world, node, dimension, freq);
            }
        }
    }

    public void unjamTile(World world, int x, int y, int z) {
        BlockCoord node = new BlockCoord(x, y, z);
        int dimension = CommonUtils.getDimension((World)world);
        Integer timeout = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        if (timeout != null && timeout >= 0) {
            ITileWireless tile = (ITileWireless)RedstoneEtherServer.getTile(world, node);
            tile.unjamTile();
        }
    }

    public void saveJammedFrequencies(String username) {
        String jammedfreqs = this.getJammedFrequencies(username = username.toLowerCase());
        if (jammedfreqs.equals("" + (this.sharedfrequencyend + 1) + "-" + 5000)) {
            SaveManager.generalProp.removeProperty(username + ".jammedFreqs");
        } else {
            SaveManager.generalProp.setProperty(username + ".jammedFreqs", jammedfreqs);
        }
    }

    public void loadJammedFrequencies(String jammedString, String username) {
        String[] freqranges = jammedString.split(",");
        for (int i = 0; i < freqranges.length; ++i) {
            int startfreq;
            int endfreq;
            String[] currentrange = freqranges[i].split("-");
            if (currentrange.length == 1) {
                try {
                    startfreq = endfreq = Integer.parseInt(currentrange[0]);
                }
                catch (NumberFormatException numberformatexception) {
                    continue;
                }
            }
            try {
                startfreq = Integer.parseInt(currentrange[0]);
                endfreq = Integer.parseInt(currentrange[1]);
            }
            catch (NumberFormatException numberformatexception1) {
                continue;
            }
            this.setFrequencyRange(username, startfreq, endfreq, true);
        }
    }

    @Override
    protected void loadJammedFrequencies(String username) {
        String openstring = SaveManager.generalProp.getProperty(username + ".jammedFreqs");
        if (openstring == null) {
            this.jamDefaultRange(username);
        } else {
            this.loadJammedFrequencies(openstring, username);
        }
    }

    public void setFrequencyRangeCommand(String username, int startfreq, int endfreq, boolean flag) {
        this.setFrequencyRange(username, startfreq, endfreq, flag);
        this.saveJammedFrequencies(username);
    }

    public void jamAllFrequencies(String username) {
        this.setFrequencyRange(username, 1, 5000, true);
    }

    public void jamDefaultRange(String username) {
        this.setFrequencyRange(username, 1, 5000, false);
        this.setFrequencyRange(username, this.sharedfrequencyend + 1, 5000, true);
    }

    public void setFreqClean(int freq, int dimension) {
        this.freqarray[freq].setClean(dimension);
    }

    public void resetPlayer(EntityPlayer player) {
        WRCoreSPH.sendPublicFrequencyTo(player, this.publicfrequencyend);
        WRCoreSPH.sendSharedFrequencyTo(player, this.sharedfrequencyend);
        String openstring = SaveManager.generalProp.getProperty(player.getCommandSenderName() + ".jammedFreqs");
        if (openstring == null) {
            this.jamDefaultRange(player.getCommandSenderName());
        } else {
            this.loadJammedFrequencies(openstring, player.getCommandSenderName());
        }
        this.sendFreqInfoTo(player);
        this.sendPrivateFreqsTo(player);
    }

    public void removePlayer(EntityPlayer player) {
        this.playerJammedMap.remove(player.getCommandSenderName());
    }

    private void sendFreqInfoTo(EntityPlayer player) {
        ArrayList<Integer> freqsWithInfo = new ArrayList<Integer>();
        for (int freq = 1; freq <= 5000; ++freq) {
            if (this.freqarray[freq].getName().equals("") && this.freqarray[freq].getColourId() == -1) continue;
            freqsWithInfo.add(freq);
        }
        WRCoreSPH.sendFreqInfoTo(player, freqsWithInfo);
    }

    private void sendPrivateFreqsTo(EntityPlayer player) {
        ArrayList<Integer> freqsWithOwners = new ArrayList<Integer>();
        for (int freq = 1; freq <= 5000; ++freq) {
            if (!this.isFreqPrivate(freq)) continue;
            freqsWithOwners.add(freq);
        }
        WRCoreSPH.sendFreqOwnerTo(player, freqsWithOwners);
    }

    public TreeMap<Integer, Integer> getLoadedFrequencies() {
        TreeMap<Integer, Integer> treemap = new TreeMap<Integer, Integer>();
        for (int freq = 1; freq <= 5000; ++freq) {
            if (this.freqarray[freq].nodeCount() == 0) continue;
            treemap.put(freq, this.freqarray[freq].getActiveTransmitters());
        }
        return treemap;
    }

    public Map<BlockCoord, Boolean> getTransmittersOnFreq(int freq, int dimension) {
        return Collections.unmodifiableMap(this.freqarray[freq].getTransmitters(dimension));
    }

    public Collection<BlockCoord> getReceiversOnFreq(int freq, int dimension) {
        return Collections.unmodifiableCollection(this.freqarray[freq].getReceivers(dimension));
    }

    public Map<BlockCoord, RedstoneEther.TXNodeInfo> getTransmittersInDimension(int dimension) {
        return Collections.unmodifiableMap(((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks);
    }

    public Set<WirelessTransmittingDevice> getTransmittingDevicesInDimension(int dimension) {
        return Collections.unmodifiableSet(((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingdevices);
    }

    public ArrayList<FreqCoord> getActiveTransmittersOnFreq(int freq, int dimension) {
        ArrayList<FreqCoord> txnodes = new ArrayList<FreqCoord>();
        this.freqarray[freq].putActiveTransmittersInList(dimension, txnodes);
        return txnodes;
    }

    public TreeSet<BlockCoord> getJammers(int dimension) {
        return ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset;
    }

    public TreeMap<BlockCoord, Integer> getJammedNodes(int dimension) {
        return ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes;
    }

    public TreeSet<BlockCoord> getNodesInRangeofPoint(int dimension, Vector3 point, float range, boolean includejammed) {
        TreeSet<BlockCoord> nodes = new TreeSet<BlockCoord>();
        float rangePow2 = range * range;
        for (int freq = 1; freq <= 5000; ++freq) {
            TreeMap<BlockCoord, Boolean> transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockCoord node : transmittermap.keySet()) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
            TreeSet<BlockCoord> receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockCoord node : receiverset) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
        }
        if (includejammed) {
            for (BlockCoord node : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.keySet()) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public TreeSet<BlockCoord> getNodesInRangeofNode(int dimension, BlockCoord block, float range, boolean includejammed) {
        TreeSet<BlockCoord> nodes = new TreeSet<BlockCoord>();
        float rangePow2 = range * range;
        for (int freq = 1; freq <= 5000; ++freq) {
            TreeMap<BlockCoord, Boolean> transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockCoord node : transmittermap.keySet()) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
            TreeSet<BlockCoord> receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockCoord node : receiverset) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
        }
        if (includejammed) {
            for (BlockCoord node : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.keySet()) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public void updateReceivingDevices(int freq, boolean on) {
        Iterator iterator = this.receivingdevices.iterator();
        while (iterator.hasNext()) {
            ((WirelessReceivingDevice)iterator.next()).updateDevice(freq, on);
        }
    }

    public List<WirelessTransmittingDevice> getTransmittingDevicesOnFreq(int freq) {
        return Collections.unmodifiableList(this.freqarray[freq].getTransmittingDevices());
    }

    public void addTransmittingDevice(WirelessTransmittingDevice device) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)device.getDimension()))).transmittingdevices.add(device);
        this.freqarray[device.getFreq()].addTransmittingDevice(device);
    }

    public void removeTransmittingDevice(WirelessTransmittingDevice device) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)device.getDimension()))).transmittingdevices.remove(device);
        this.freqarray[device.getFreq()].removeTransmittingDevice(device);
    }

    public void addReceivingDevice(WirelessReceivingDevice device) {
        this.receivingdevices.add(device);
    }

    public void removeReceivingDevice(WirelessReceivingDevice device) {
        this.receivingdevices.remove(device);
    }

    public void setDimensionTransmitterCount(int freq, int dimension, int count) {
        this.freqarray[freq].setActiveTransmittersInDim(dimension, count);
    }

    public void addFreqToSave(RedstoneEtherFrequency freq, int dimension) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave.add(freq);
    }

    public void tick(World world) {
        this.updateJammedNodes(world);
        this.randomJamTest(world);
        this.updateJammedEntities(world);
        this.entityJamTest(world);
        this.unloadJammedMap();
    }

    private void unloadJammedMap() {
        Iterator iterator = this.playerJammedMap.keySet().iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            if (ServerUtils.getPlayer((String)username) != null) continue;
            this.saveJammedFrequencies(username);
            iterator.remove();
        }
    }

    private void updateJammedNodes(World world) {
        int dimension = CommonUtils.getDimension((World)world);
        Iterator<BlockCoord> iterator = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.keySet().iterator();
        while (iterator.hasNext()) {
            BlockCoord node = iterator.next();
            int inactivetime = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.get(node);
            if (--inactivetime == 0 || inactivetime < 0 && inactivetime % jammerrandom == 0) {
                ITileJammer jammertile;
                ITileWireless tile = (ITileWireless)RedstoneEtherServer.getTile(world, node);
                if (tile == null) {
                    iterator.remove();
                    continue;
                }
                BlockCoord jammer = this.getClosestJammer(node, dimension);
                ITileJammer iTileJammer = jammertile = jammer == null ? null : (ITileJammer)RedstoneEtherServer.getTile(world, jammer);
                if (jammertile == null) {
                    iterator.remove();
                    tile.unjamTile();
                    continue;
                }
                jammertile.jamTile(tile);
            }
            if (inactivetime == 0) {
                inactivetime = jammertimeout;
            }
            ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.put(node, inactivetime);
        }
    }

    private void randomJamTest(World world) {
        if (world.getTotalWorldTime() % 600L != 0L) {
            return;
        }
        for (Map.Entry entry : this.ethers.entrySet()) {
            if (((RedstoneEther.DimensionalEtherHash)entry.getValue()).jammerset == null) continue;
            Iterator<BlockCoord> iterator = ((RedstoneEther.DimensionalEtherHash)entry.getValue()).jammerset.iterator();
            while (iterator.hasNext()) {
                this.jamNodesInAOEOfJammer(world, iterator.next(), (Integer)entry.getKey());
            }
        }
    }

    private void updateJammedEntities(World world) {
        int dimension = CommonUtils.getDimension((World)world);
        Iterator iterator = this.jammedentities.keySet().iterator();
        while (iterator.hasNext()) {
            EntityLivingBase entity = (EntityLivingBase)iterator.next();
            int inactivetime = (Integer)this.jammedentities.get(entity);
            --inactivetime;
            if (entity == null || entity.isDead) {
                iterator.remove();
                continue;
            }
            if (inactivetime == 0 || inactivetime < 0 && inactivetime % jammerentitywait == 0 || inactivetime > 0 && inactivetime % jammerentityretry == 0) {
                ITileJammer jammertile;
                BlockCoord jammer = this.getClosestJammer(Vector3.fromEntity((Entity)entity), dimension);
                ITileJammer iTileJammer = jammertile = jammer == null ? null : (ITileJammer)RedstoneEtherServer.getTile(world, jammer);
                if (jammertile == null) {
                    if (inactivetime <= 0) {
                        iterator.remove();
                        this.jamEntity(entity, false);
                        continue;
                    }
                } else {
                    jammertile.jamEntity((Entity)entity);
                }
            }
            if (inactivetime == 0) {
                inactivetime = jammertimeout;
            }
            this.jammedentities.put(entity, inactivetime);
        }
    }

    private void entityJamTest(World world) {
        if (world.getTotalWorldTime() % 10L != 0L) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            List entitiesinrange = world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBox((double)((double)jammer.x - 9.5), (double)((double)jammer.y - 9.5), (double)((double)jammer.z - 9.5), (double)((double)jammer.x + 10.5), (double)((double)jammer.y + 10.5), (double)((double)jammer.z + 10.5)));
            for (Entity entity : entitiesinrange) {
                if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && this.isPlayerJammed((EntityPlayer)entity)) continue;
                this.jamEntitySometime((EntityLivingBase)entity);
            }
        }
    }

    public void unload() {
        SaveManager.unloadAll();
    }

    @Override
    public void setFreq(ITileWireless tile, int freq) {
        tile.setFreq(freq);
    }
}

