/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessBolt;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.world.World;

public class WRCoreCPH
implements PacketCustom.IClientPacketHandler {
    public static List<PacketCustom.IClientPacketHandler> delegates = new LinkedList<PacketCustom.IClientPacketHandler>();

    public void handlePacket(PacketCustom packet, Minecraft mc, INetHandlerPlayClient handler) {
        this.handlePacket(mc.theWorld, (EntityPlayer)mc.thePlayer, packet);
        for (PacketCustom.IClientPacketHandler delegate : delegates) {
            delegate.handlePacket(packet, mc, handler);
        }
    }

    private void handlePacket(WorldClient world, EntityPlayer player, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: {
                this.handleFreqInfoList(packet);
                break;
            }
            case 2: {
                this.handleLastFreqInfo(packet.readUShort(), packet.readUByte());
                break;
            }
            case 3: {
                RedstoneEther.get(true).setFrequencyRange(player.getCommandSenderName(), packet.readUShort(), packet.readUShort(), packet.readBoolean());
                break;
            }
            case 4: {
                this.handleFreqInfo(packet);
                break;
            }
            case 7: {
                RedstoneEther.client().jamEntity((EntityLivingBase)player, packet.readBoolean());
                break;
            }
            case 8: {
                WirelessBolt bolt = new WirelessBolt((World)world, new Vector3((double)packet.readFloat(), (double)packet.readFloat(), (double)packet.readFloat()), new Vector3((double)packet.readFloat(), (double)packet.readFloat(), (double)packet.readFloat()), packet.readLong());
                bolt.defaultFractal();
                bolt.finalizeBolt();
                break;
            }
            case 9: {
                RedstoneEther.get(true).setFreqOwner(packet.readShort(), packet.readString());
                break;
            }
            case 10: {
                this.handleFreqOwnerList(packet);
            }
        }
    }

    private void handleFreqOwnerList(PacketCustom packet) {
        int numFreqs = packet.readUShort();
        for (int i = 0; i < numFreqs; ++i) {
            RedstoneEther.get(true).setFreqOwner(packet.readShort(), packet.readString());
        }
    }

    private void handleFreqInfoList(PacketCustom packet) {
        int numFreqs = packet.readUShort();
        for (int i = 0; i < numFreqs; ++i) {
            this.handleFreqInfo(packet);
        }
    }

    private void handleFreqInfo(PacketCustom packet) {
        int freq = packet.readUShort();
        RedstoneEther.get(true).setFreqColour(freq, packet.readByte());
        RedstoneEther.get(true).setFreqName(freq, packet.readString());
    }

    private void handleLastFreqInfo(int freq, int type) {
        switch (type) {
            case 1: {
                RedstoneEther.get(true).setLastPublicFrequency(freq);
                break;
            }
            case 2: {
                RedstoneEther.get(true).setLastSharedFrequency(freq);
            }
        }
    }

    public static void sendSetTileFreq(int x, int y, int z, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 1);
        packet.writeCoord(x, y, z);
        packet.writeShort(freq);
        packet.sendToServer();
    }

    public static void sendSetFreqInfo(int freq, String name, int colourid) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 4);
        packet.writeShort((int)((short)freq));
        packet.writeString(name);
        packet.writeByte((int)((byte)colourid));
        packet.sendToServer();
    }

    public static void sendDecrementSlot(int slot) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 5);
        packet.writeShort(slot);
        packet.sendToServer();
    }

    public static void sendSetFreqOwner(int freq, String username) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 9);
        packet.writeShort(freq);
        packet.writeString(username);
        packet.sendToServer();
    }

    public static void sendSetItemFreq(int slot, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(slot);
        packet.writeShort(freq);
        packet.sendToServer();
    }
}

