/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.ServerUtils;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RenderWirelessBolt;
import codechicken.wirelessredstone.core.WirelessBolt;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WRCoreEventHandler {
    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.isRemote) {
            RedstoneEther.loadClientEther(event.world);
        } else {
            RedstoneEther.loadServerWorld(event.world);
        }
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        RedstoneEther.loadServerWorld(event.world);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.isRemote) {
            return;
        }
        RedstoneEther.unloadServerWorld(event.world);
        if (!ServerUtils.mc().isServerRunning()) {
            RedstoneEther.unloadServer();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.world.isRemote || RedstoneEther.server() == null) {
            return;
        }
        RedstoneEther.server().saveEther(event.world);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.world.isRemote) {
            return;
        }
        if (RedstoneEther.server() != null) {
            RedstoneEther.loadServerWorld(event.world);
            RedstoneEther.server().verifyChunkTransmitters(event.world, event.getChunk().xPosition, event.getChunk().zPosition);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        RenderWirelessBolt.render(event.partialTicks, (Entity)Minecraft.getMinecraft().renderViewEntity);
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        RedstoneEther.server().resetPlayer(event.player);
    }

    @SubscribeEvent
    public void playerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        RedstoneEther.server().resetPlayer(event.player);
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        RedstoneEther.server().removePlayer(event.player);
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        RedstoneEther.server().resetPlayer(event.player);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            WirelessBolt.update(WirelessBolt.clientboltlist);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            WirelessBolt.update(WirelessBolt.serverboltlist);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.isRemote) {
            RedstoneEther.server().tick(event.world);
        }
    }
}

