/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.JItemMultiPart;
import codechicken.multipart.TMultiPart;
import codechicken.wirelessredstone.logic.JammerPart;
import codechicken.wirelessredstone.logic.ReceiverPart;
import codechicken.wirelessredstone.logic.RenderWireless;
import codechicken.wirelessredstone.logic.TransmitterPart;
import codechicken.wirelessredstone.logic.WirelessPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemWirelessPart
extends JItemMultiPart {
    public ItemWirelessPart() {
        this.setHasSubtypes(true);
        this.setUnlocalizedName("wrcbe_logic:wirelesspart");
    }

    public TMultiPart newPart(ItemStack item, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 vhit) {
        BlockCoord onPos = pos.copy().offset(side ^ 1);
        if (!world.isSideSolid(onPos.x, onPos.y, onPos.z, ForgeDirection.getOrientation((int)side))) {
            return null;
        }
        WirelessPart part = ItemWirelessPart.getPart(item.getItemDamage());
        part.setupPlacement(player, side);
        return part;
    }

    public static WirelessPart getPart(int damage) {
        switch (damage) {
            case 0: {
                return new TransmitterPart();
            }
            case 1: {
                return new ReceiverPart();
            }
            case 2: {
                return new JammerPart();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int d = 0; d < 3; ++d) {
            list.add(new ItemStack(item, 1, d));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return super.getUnlocalizedName() + "|" + stack.getItemDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpriteNumber() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        RenderWireless.loadIcons(par1IconRegister);
    }
}

