/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.core.asm.InterfaceDependancies;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessRedstoneCore;
import codechicken.wirelessredstone.logic.RenderWireless;
import codechicken.wirelessredstone.logic.WirelessPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;

@InterfaceDependancies
public abstract class TransceiverPart
extends WirelessPart
implements ITileWireless {
    public byte deadmap;
    public int currentfreq;

    @Override
    public int getFreq() {
        return this.currentfreq;
    }

    @Override
    public void setFreq(int newfreq) {
        this.removeFromEther();
        this.currentfreq = newfreq;
        this.addToEther();
        if (this.disabled()) {
            RedstoneEther.server().jamNode(this.world(), this.x(), this.y(), this.z(), newfreq);
        }
        this.updateChange();
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.currentfreq = tag.getInteger("freq");
        this.deadmap = tag.getByte("deadmap");
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.setInteger("freq", this.currentfreq);
        tag.setByte("deadmap", this.deadmap);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeShort(this.currentfreq);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.currentfreq = packet.readUShort();
    }

    @Override
    public void jamTile() {
        this.setDisabled(true);
        this.deadmap = (byte)this.world().rand.nextInt(256);
        this.scheduleTick(3);
    }

    @Override
    public void unjamTile() {
        if (this.disabled()) {
            this.deadmap = (byte)this.world().rand.nextInt(256);
            this.scheduleTick(3);
        }
        this.setDisabled(false);
    }

    public void scheduledTick() {
        if (this.deadmap != 0) {
            this.deadmap = (byte)((this.deadmap & 0xFF) >> 1);
            if (this.deadmap != 0) {
                this.scheduleTick(3);
            }
            this.updateChange();
        }
    }

    @Override
    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack held) {
        if (super.activate(player, hit, held)) {
            return true;
        }
        if (hit.sideHit == (this.side() ^ 1) && !player.isSneaking()) {
            if (this.world().isRemote) {
                WirelessRedstoneCore.proxy.openTileWirelessGui(player, (ITileWireless)this.tile());
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        super.renderDynamic(pos, frame, pass);
        if (pass == 0) {
            RenderWireless.renderFreq(pos, this);
        }
    }
}

