/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.util;

import com.gamerforea.eventhelper.EventHelper;
import com.gamerforea.eventhelper.inject.InjectionManager;
import com.gamerforea.eventhelper.util.ConvertUtils;
import com.google.common.base.Strings;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public final class EventUtils {
    public static boolean cantBreak(@Nonnull EntityPlayer player, int x, int y, int z) {
        try {
            Player bPlayer = ConvertUtils.toBukkitEntity(player);
            BlockBreakEvent event = new BlockBreakEvent(bPlayer.getWorld().getBlockAt(x, y, z), bPlayer);
            EventHelper.callEvent((Event)event);
            return event.isCancelled();
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed call BlockBreakEvent: [Player: {}, X:{}, Y:{}, Z:{}]", String.valueOf(player), x, y, z);
            return true;
        }
    }

    public static boolean cantBreak(@Nonnull EntityPlayer player, double x, double y, double z) {
        int xx = MathHelper.func_76128_c((double)x);
        int yy = MathHelper.func_76128_c((double)y);
        int zz = MathHelper.func_76128_c((double)z);
        return EventUtils.cantBreak(player, xx, yy, zz);
    }

    public static boolean cantDamage(@Nonnull Entity attacker, @Nonnull Entity victim) {
        try {
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent(ConvertUtils.toBukkitEntity(attacker), ConvertUtils.toBukkitEntity(victim), EntityDamageEvent.DamageCause.ENTITY_ATTACK, 0.0);
            EventHelper.callEvent((Event)event);
            return event.isCancelled();
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed call EntityDamageByEntityEvent: [Attacker: {}, Victim: {}]", String.valueOf(attacker), String.valueOf(victim));
            return true;
        }
    }

    public static boolean cantInteract(@Nonnull EntityPlayer player, @Nullable ItemStack stack, int x, int y, int z, @Nonnull ForgeDirection side) {
        try {
            Player bPlayer = ConvertUtils.toBukkitEntity(player);
            PlayerInteractEvent event = new PlayerInteractEvent(bPlayer, Action.RIGHT_CLICK_BLOCK, ConvertUtils.toBukkitItemStackMirror(stack), bPlayer.getWorld().getBlockAt(x, y, z), ConvertUtils.toBukkitFace(side));
            EventHelper.callEvent((Event)event);
            return event.isCancelled();
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed call PlayerInteractEvent: [Player: {}, Item: {}, X:{}, Y:{}, Z:{}, Side: {}]", String.valueOf(player), String.valueOf(stack), x, y, z, String.valueOf(side));
            return true;
        }
    }

    public static boolean cantFromTo(@Nonnull World world, int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        try {
            org.bukkit.World bWorld = ConvertUtils.toBukkitWorld(world);
            BlockFromToEvent event = new BlockFromToEvent(bWorld.getBlockAt(fromX, fromY, fromZ), bWorld.getBlockAt(toX, toY, toZ));
            EventHelper.callEvent((Event)event);
            return event.isCancelled();
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed call BlockFromToEvent: [FromX: {}, FromY: {}, FromZ: {}, ToX: {}, ToY: {}, ToZ: {}]", fromX, fromY, fromZ, toX, toY, toZ);
            return true;
        }
    }

    public static boolean cantFromTo(@Nonnull World world, int fromX, int fromY, int fromZ, @Nonnull ForgeDirection direction) {
        try {
            org.bukkit.World bWorld = ConvertUtils.toBukkitWorld(world);
            BlockFromToEvent event = new BlockFromToEvent(bWorld.getBlockAt(fromX, fromY, fromZ), ConvertUtils.toBukkitFace(direction));
            EventHelper.callEvent((Event)event);
            return event.isCancelled();
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed call BlockFromToEvent: [FromX: {}, FromY: {}, FromZ: {}, Direction: {}]", fromX, fromY, fromZ, String.valueOf(direction));
            return true;
        }
    }

    public static boolean isInPrivate(@Nonnull World world, int x, int y, int z) {
        try {
            return InjectionManager.isInPrivate(ConvertUtils.toBukkitWorld(world), x, y, z);
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed check private: [World: {}, X: {}, Y: {}, Z: {}]", world.func_72912_H().func_76065_j(), x, y, z);
            return true;
        }
    }

    public static boolean isPrivateMember(@Nonnull EntityPlayer player, double x, double y, double z) {
        int xx = MathHelper.func_76128_c((double)x);
        int yy = MathHelper.func_76128_c((double)y);
        int zz = MathHelper.func_76128_c((double)z);
        return EventUtils.isPrivateMember(player, xx, yy, zz);
    }

    public static boolean isPrivateMember(@Nonnull EntityPlayer player, int x, int y, int z) {
        try {
            return InjectionManager.isPrivateMember(ConvertUtils.toBukkitEntity(player), x, y, z);
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed check private member: [Player: {}, X: {}, Y: {}, Z: {}]", String.valueOf(player), x, y, z);
            return true;
        }
    }

    public static boolean isPrivateOwner(@Nonnull EntityPlayer player, double x, double y, double z) {
        int xx = MathHelper.func_76128_c((double)x);
        int yy = MathHelper.func_76128_c((double)y);
        int zz = MathHelper.func_76128_c((double)z);
        return EventUtils.isPrivateOwner(player, xx, yy, zz);
    }

    public static boolean isPrivateOwner(@Nonnull EntityPlayer player, int x, int y, int z) {
        try {
            return InjectionManager.isPrivateOwner(ConvertUtils.toBukkitEntity(player), x, y, z);
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed check private owner: [Player: {}, X: {}, Y: {}, Z: {}]", String.valueOf(player), x, y, z);
            return true;
        }
    }

    public static boolean isInPrivate(@Nonnull Entity entity) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        return EventUtils.isInPrivate(entity.field_70170_p, x, y, z);
    }

    public static boolean hasPermission(@Nullable EntityPlayer player, @Nonnull String permission) {
        if (player == null) {
            return false;
        }
        try {
            Player bPlayer = ConvertUtils.toBukkitEntity(player);
            return bPlayer != null && bPlayer.hasPermission(permission);
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed checking permission: [Player: {}, Permission: {}]", player, permission);
            return false;
        }
    }

    public static boolean hasPermission(@Nullable UUID playerId, @Nonnull String permission) {
        if (playerId == null) {
            return false;
        }
        try {
            Player player = Bukkit.getPlayer((UUID)playerId);
            return player != null && player.hasPermission(permission);
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed checking permission: [Player name: {}, Permission: {}]", playerId, permission);
            return false;
        }
    }

    public static boolean hasPermission(@Nullable String playerName, @Nonnull String permission) {
        if (Strings.isNullOrEmpty((String)playerName)) {
            return false;
        }
        try {
            Player player = Bukkit.getPlayerExact((String)playerName);
            return player != null && player.hasPermission(permission);
        }
        catch (Throwable throwable) {
            EventHelper.error(throwable, "Failed checking permission: [Player UUID: {}, Permission: {}]", playerName, permission);
            return false;
        }
    }
}

