/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.util;

import com.gamerforea.eventhelper.EventHelper;
import com.gamerforea.eventhelper.fake.FakePlayerContainer;
import com.gamerforea.eventhelper.util.EventUtils;
import com.gamerforea.eventhelper.util.FastUtils;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public final class ExplosionByPlayer
extends Explosion {
    private final EntityPlayer player;
    private final World world;
    private final Map<EntityPlayer, Vec3> playerKnockbackMap = new HashMap<EntityPlayer, Vec3>();

    public ExplosionByPlayer(@Nonnull GameProfile modFakeProfile, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size) {
        this((EntityPlayer)(player == null ? (exploder instanceof EntityPlayer ? (EntityPlayer)exploder : FastUtils.getFake(world, modFakeProfile)) : player), world, exploder, x, y, z, size);
    }

    public ExplosionByPlayer(@Nonnull FakePlayer modFake, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size) {
        this((EntityPlayer)(player == null ? (exploder instanceof EntityPlayer ? (EntityPlayer)exploder : modFake) : player), world, exploder, x, y, z, size);
    }

    public ExplosionByPlayer(@Nonnull FakePlayerContainer fake, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size) {
        this(fake.get(), world, exploder, x, y, z, size);
    }

    public ExplosionByPlayer(@Nonnull EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size) {
        super(world, exploder, x, y, z, size);
        this.world = world;
        this.player = player;
    }

    public final void func_77278_a() {
        if (!EventHelper.explosions) {
            return;
        }
        this.field_77281_g.addAll(this.getPositions());
        float size = this.field_77280_f;
        this.field_77280_f *= 2.0f;
        int minX = MathHelper.func_76128_c((double)(this.field_77284_b - (double)this.field_77280_f - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.field_77284_b + (double)this.field_77280_f + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.field_77285_c - (double)this.field_77280_f - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.field_77285_c + (double)this.field_77280_f + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.field_77282_d - (double)this.field_77280_f - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.field_77282_d + (double)this.field_77280_f + 1.0));
        List entities = this.world.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        Vec3 vec3 = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
        for (Entity entity : entities) {
            double distanceZ;
            double distanceY;
            double distanceX;
            double distance1;
            double distance = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)this.field_77280_f;
            if (!(distance <= 1.0) || (distance1 = (double)MathHelper.func_76133_a((double)((distanceX = entity.field_70165_t - this.field_77284_b) * distanceX + (distanceY = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * distanceY + (distanceZ = entity.field_70161_v - this.field_77282_d) * distanceZ))) == 0.0 || EventUtils.cantDamage((Entity)this.player, entity)) continue;
            distanceX /= distance1;
            distanceY /= distance1;
            distanceZ /= distance1;
            double density = this.world.func_72842_a(vec3, entity.field_70121_D);
            double d5 = (1.0 - distance) * density;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d5 * d5 + d5) / 2.0 * 8.0 * (double)this.field_77280_f + 1.0)));
            double d6 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d5);
            entity.field_70159_w += distanceX * d6;
            entity.field_70181_x += distanceY * d6;
            entity.field_70179_y += distanceZ * d6;
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            this.playerKnockbackMap.put(player, Vec3.func_72443_a((double)(distanceX * d5), (double)(distanceY * d5), (double)(distanceZ * d5)));
        }
        this.field_77280_f = size;
    }

    private Set<ChunkPosition> getPositions() {
        HashSet<ChunkPosition> set = new HashSet<ChunkPosition>();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double distanceX = (float)i / 30.0f - 1.0f;
                    double distanceY = (float)j / 30.0f - 1.0f;
                    double distanceZ = (float)k / 30.0f - 1.0f;
                    double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                    distanceX /= distance;
                    distanceY /= distance;
                    distanceZ /= distance;
                    double dX = this.field_77284_b;
                    double dY = this.field_77285_c;
                    double dZ = this.field_77282_d;
                    float f = 0.3f;
                    for (float size = this.field_77280_f * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); size > 0.0f; size -= f * 0.75f) {
                        int z;
                        int y;
                        int x = MathHelper.func_76128_c((double)dX);
                        Block block = this.world.func_147439_a(x, y = MathHelper.func_76128_c((double)dY), z = MathHelper.func_76128_c((double)dZ));
                        if (block.func_149688_o() != Material.field_151579_a) {
                            float resistance = this.field_77283_e != null ? this.field_77283_e.func_145772_a((Explosion)this, this.world, x, y, z, block) : block.getExplosionResistance(this.field_77283_e, this.world, x, y, z, this.field_77284_b, this.field_77285_c, this.field_77282_d);
                            size -= (resistance + 0.3f) * f;
                        }
                        if (size > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_145774_a((Explosion)this, this.world, x, y, z, block, size)) && !EventUtils.cantBreak(this.player, x, y, z)) {
                            set.add(new ChunkPosition(x, y, z));
                        }
                        dX += distanceX * (double)f;
                        dY += distanceY * (double)f;
                        dZ += distanceZ * (double)f;
                    }
                }
            }
        }
        return set;
    }

    public final Map func_77277_b() {
        return this.playerKnockbackMap;
    }

    public static ExplosionByPlayer createExplosion(@Nonnull GameProfile modFakeProfile, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean smoke) {
        return ExplosionByPlayer.newExplosion(modFakeProfile, player, world, exploder, x, y, z, size, false, smoke);
    }

    public static ExplosionByPlayer createExplosion(@Nonnull FakePlayer modFake, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean smoke) {
        return ExplosionByPlayer.newExplosion(modFake, player, world, exploder, x, y, z, size, false, smoke);
    }

    @Nonnull
    public static ExplosionByPlayer createExplosion(@Nonnull FakePlayerContainer fake, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean smoke) {
        return ExplosionByPlayer.newExplosion(fake, world, exploder, x, y, z, size, false, smoke);
    }

    @Nonnull
    public static ExplosionByPlayer createExplosion(@Nonnull EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean smoke) {
        return ExplosionByPlayer.newExplosion(player, world, exploder, x, y, z, size, false, smoke);
    }

    public static ExplosionByPlayer newExplosion(@Nonnull GameProfile modFakeProfile, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean flame, boolean smoke) {
        ExplosionByPlayer explosion = new ExplosionByPlayer(modFakeProfile, player, world, exploder, x, y, z, size);
        return ExplosionByPlayer.newExplosion(explosion, world, x, y, z, size, flame, smoke);
    }

    public static ExplosionByPlayer newExplosion(@Nonnull FakePlayer modFake, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean flame, boolean smoke) {
        ExplosionByPlayer explosion = new ExplosionByPlayer(modFake, player, world, exploder, x, y, z, size);
        return ExplosionByPlayer.newExplosion(explosion, world, x, y, z, size, flame, smoke);
    }

    @Nonnull
    public static ExplosionByPlayer newExplosion(@Nonnull FakePlayerContainer fake, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean flame, boolean smoke) {
        ExplosionByPlayer explosion = new ExplosionByPlayer(fake, world, exploder, x, y, z, size);
        return ExplosionByPlayer.newExplosion(explosion, world, x, y, z, size, flame, smoke);
    }

    @Nonnull
    public static ExplosionByPlayer newExplosion(@Nonnull EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean flame, boolean smoke) {
        ExplosionByPlayer explosion = new ExplosionByPlayer(player, world, exploder, x, y, z, size);
        return ExplosionByPlayer.newExplosion(explosion, world, x, y, z, size, flame, smoke);
    }

    private static ExplosionByPlayer newExplosion(@Nonnull ExplosionByPlayer explosion, @Nonnull World world, double x, double y, double z, float size, boolean flame, boolean smoke) {
        explosion.field_77286_a = flame;
        explosion.field_82755_b = smoke;
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            return explosion;
        }
        boolean isServerWorld = world instanceof WorldServer;
        explosion.func_77278_a();
        explosion.func_77279_a(!isServerWorld);
        if (isServerWorld) {
            if (!smoke) {
                explosion.field_77281_g.clear();
            }
            for (EntityPlayer target : world.field_73010_i) {
                if (!(target.func_70092_e(x, y, z) < 4096.0)) continue;
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new S27PacketExplosion(x, y, z, size, explosion.field_77281_g, (Vec3)explosion.func_77277_b().get(target)));
            }
        }
        return explosion;
    }
}

