/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.inject;

import com.gamerforea.eventhelper.inject.PluginInjection;
import com.gamerforea.eventhelper.inject.gpp.GPPInjection;
import com.gamerforea.eventhelper.inject.wg.WGInjection;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.Player;

public final class InjectionManager {
    private static final List<PluginInjection> injections = new ArrayList<PluginInjection>();

    public static void init() {
        PluginInjection gppInj;
        PluginInjection wgInj = WGInjection.getInjection();
        if (wgInj != null) {
            injections.add(wgInj);
        }
        if ((gppInj = GPPInjection.getInjection()) != null) {
            injections.add(gppInj);
        }
    }

    public static boolean isInPrivate(World world, int x, int y, int z) {
        for (PluginInjection inj : injections) {
            if (!inj.isInPrivate(world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrivateMember(Player player, int x, int y, int z) {
        for (PluginInjection inj : injections) {
            if (inj.isPrivateMember(player, x, y, z)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrivateOwner(Player player, int x, int y, int z) {
        for (PluginInjection inj : injections) {
            if (inj.isPrivateOwner(player, x, y, z)) continue;
            return false;
        }
        return true;
    }
}

