/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.iterator.TObjectLongIterator;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class CooldownManager<T> {
    private final TObjectLongMap<T> cooldowns = new TObjectLongHashMap();
    private final long cooldown;

    public CooldownManager(long cooldown, @Nonnull TimeUnit timeUnit) {
        this(cooldown <= 0L ? 0L : timeUnit.toSeconds(cooldown) * 20L);
    }

    public CooldownManager(long cooldownInTicks) {
        this.cooldown = Math.max(0L, cooldownInTicks);
        if (this.cooldown > 0L) {
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    public boolean canAdd(@Nonnull T key) {
        return this.cooldown <= 0L || !this.cooldowns.containsKey(key);
    }

    public boolean add(@Nonnull T key) {
        if (this.cooldown <= 0L) {
            return true;
        }
        if (this.canAdd(key)) {
            this.cooldowns.put(key, this.cooldown);
            return true;
        }
        return false;
    }

    public long getCooldown(@Nonnull T key) {
        return this.cooldown <= 0L ? 0L : this.cooldowns.get(key);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TObjectLongIterator iterator = this.cooldowns.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                long timer = iterator.value() - 1L;
                if (timer <= 0L) {
                    iterator.remove();
                    continue;
                }
                iterator.setValue(timer);
            }
        }
    }
}

