/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.util;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;

public final class ItemInventoryValidator {
    public static final String NBT_KEY_ID = "UID";
    private static final Random RANDOM = new Random();
    private final ItemStack stack;
    private final String nbtIdKey;
    private final Predicate<Item> itemValidator;
    private final Function<EntityPlayer, ItemStack> stackGetter;
    private boolean itemInHotbar = true;
    private int slotIndex = -1;
    private int slotNumber = -1;

    public ItemInventoryValidator(ItemStack stack) {
        this(stack, null, true);
    }

    public ItemInventoryValidator(ItemStack stack, Predicate<Item> itemValidator) {
        this(stack, null, true, itemValidator);
    }

    public ItemInventoryValidator(ItemStack stack, Function<EntityPlayer, ItemStack> stackGetter) {
        this(stack, null, true, stackGetter);
    }

    public ItemInventoryValidator(ItemStack stack, Predicate<Item> itemValidator, Function<EntityPlayer, ItemStack> stackGetter) {
        this(stack, null, true, itemValidator, stackGetter);
    }

    public ItemInventoryValidator(ItemStack stack, String nbtKeyId, boolean generateIdIfAbsent) {
        this(stack, nbtKeyId, generateIdIfAbsent, null, null);
    }

    public ItemInventoryValidator(ItemStack stack, String nbtKeyId, boolean generateIdIfAbsent, Predicate<Item> itemValidator) {
        this(stack, nbtKeyId, generateIdIfAbsent, itemValidator, null);
    }

    public ItemInventoryValidator(ItemStack stack, String nbtKeyId, boolean generateIdIfAbsent, Function<EntityPlayer, ItemStack> stackGetter) {
        this(stack, nbtKeyId, generateIdIfAbsent, null, stackGetter);
    }

    public ItemInventoryValidator(ItemStack stack, String nbtKeyId, boolean generateIdIfAbsent, Predicate<Item> itemValidator, Function<EntityPlayer, ItemStack> stackGetter) {
        this.stack = stack;
        this.nbtIdKey = nbtKeyId = (String)StringUtils.defaultIfBlank((CharSequence)nbtKeyId, (CharSequence)NBT_KEY_ID);
        this.itemValidator = itemValidator;
        this.stackGetter = stackGetter;
        if (generateIdIfAbsent && stack != null && (itemValidator == null || itemValidator.test(stack.func_77973_b()))) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            if (!nbt.func_74764_b(nbtKeyId)) {
                nbt.func_74768_a(nbtKeyId, RANDOM.nextInt());
            }
        }
    }

    public boolean isItemInHotbar() {
        return this.itemInHotbar;
    }

    public void setItemInHotbar(boolean itemInHotbar) {
        this.itemInHotbar = itemInHotbar;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public void setSlotIndex(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public void setSlotIndex(int slotIndex, boolean itemInHotbar) {
        this.setSlotIndex(slotIndex);
        this.setItemInHotbar(itemInHotbar);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public boolean tryGetSlotNumberFromPlayerSlot(Slot slot) {
        if (this.slotIndex >= 0 && slot.field_75224_c instanceof InventoryPlayer && slot.getSlotIndex() == this.slotIndex) {
            this.setSlotNumber(slot.field_75222_d);
            return true;
        }
        return false;
    }

    public boolean canInteractWith(EntityPlayer player) {
        if (this.itemInHotbar && this.slotIndex >= 0 && this.slotIndex != player.field_71071_by.field_70461_c) {
            return false;
        }
        if (this.stack != null) {
            ItemStack stackToCheck;
            if (this.stackGetter == null) {
                if (this.slotIndex < 0) {
                    return true;
                }
                stackToCheck = player.field_71071_by.func_70301_a(this.slotIndex);
            } else {
                stackToCheck = this.stackGetter.apply(player);
            }
            return stackToCheck != null && (this.itemValidator == null || this.itemValidator.test(stackToCheck.func_77973_b())) && this.isSameItemInventory(this.stack, stackToCheck);
        }
        return true;
    }

    public boolean canSlotClick(int slot, int button, int buttonType, EntityPlayer player) {
        if (this.slotNumber >= 0 && slot == this.slotNumber) {
            return false;
        }
        if (buttonType == 2 && this.itemInHotbar && this.slotIndex >= 0 && button == this.slotIndex) {
            return false;
        }
        return this.canInteractWith(player);
    }

    private boolean isSameItemInventory(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (!base.func_77942_o() || !comparison.func_77942_o()) {
            return false;
        }
        String baseUID = base.func_77978_p().func_74779_i(this.nbtIdKey);
        String comparisonUID = comparison.func_77978_p().func_74779_i(this.nbtIdKey);
        return baseUID != null && baseUID.equals(comparisonUID);
    }
}

