/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.loadbalancer.api;

import com.gamerforea.loadbalancer.api.ILoadBalancerAPI;
import com.gamerforea.loadbalancer.dummy.DummyLoadBalancerAPI;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class LoadBalancerAPIProvider {
    private static ILoadBalancerAPI loadBalancerAPI;

    LoadBalancerAPIProvider() {
    }

    public static ILoadBalancerAPI getLoadBalancerAPI() {
        if (loadBalancerAPI != null) {
            return loadBalancerAPI;
        }
        Logger logger = LogManager.getLogger((String)"LoadBalancerAPIProvider");
        ServiceLoader<ILoadBalancerAPI> serviceLoader = ServiceLoader.load(ILoadBalancerAPI.class);
        ArrayList implementations = Lists.newArrayList(serviceLoader);
        if (implementations.isEmpty()) {
            logger.warn("LoadBalancerAPI implementation not found. Fallback to dummy implementation");
            loadBalancerAPI = DummyLoadBalancerAPI.INSTANCE;
            return loadBalancerAPI;
        }
        ILoadBalancerAPI implementation = Collections.max(implementations, Comparator.comparingInt(ILoadBalancerAPI::getPriority));
        logger.warn("LoadBalancerAPI implementation found: " + implementation.getClass().getName());
        loadBalancerAPI = implementation;
        return loadBalancerAPI;
    }
}

