/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.loadbalancer.api.meter;

import com.gamerforea.loadbalancer.api.meter.MeterPeriod;
import java.util.concurrent.TimeUnit;

public interface ITickMeterView {
    public long averageTickTime(MeterPeriod var1);

    default public long averageTickTime(MeterPeriod period, TimeUnit timeUnit) {
        return timeUnit.convert(this.averageTickTime(period), TimeUnit.NANOSECONDS);
    }

    default public float averageTPS(MeterPeriod period) {
        long tickTime = this.averageTickTime(period);
        return tickTime == 0L ? 20.0f : Math.min(20.0f, 1.0E9f / (float)tickTime);
    }

    default public float averageTickTimePercentage(ITickMeterView parentTickMeter, MeterPeriod period) {
        long tickTime = this.averageTickTime(period);
        if (tickTime == 0L) {
            return 0.0f;
        }
        long parentTickTime = parentTickMeter.averageTickTime(period);
        return tickTime < parentTickTime ? (float)tickTime / (float)parentTickTime : 1.0f;
    }
}

