/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper;

import com.gamerforea.eventhelper.command.CommandReloadAllConfigs;
import com.gamerforea.eventhelper.config.ConfigUtils;
import com.gamerforea.eventhelper.inject.InjectionManager;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

@Mod(modid="EventHelper", name="EventHelper", version="1.7.10-1.13", acceptableRemoteVersions="*")
public final class EventHelper {
    public static final Logger LOGGER = LogManager.getLogger((String)"EventHelper");
    public static final File cfgDir = new File(Loader.instance().getConfigDir(), "Events");
    public static final List listeners = Lists.newArrayList();
    public static String craftPackage = "org.bukkit.craftbukkit.v1_7_R4";
    public static boolean explosions = true;
    public static boolean debug = true;

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandReloadAllConfigs());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        Configuration cfg = ConfigUtils.getConfig("EventHelper");
        String c = "general";
        String[] plugins = cfg.getStringList("plugins", c, new String[]{"WorldGuard", "GriefPreventionPlus"}, "Plugins for sending events");
        boolean pluginHooking = cfg.getBoolean("pluginHooking", c, true, "Hooking plugins (allow checking regions)");
        craftPackage = cfg.getString("craftPackage", c, craftPackage, "CraftBukkit package (for reflection)");
        explosions = cfg.getBoolean("explosions", c, explosions, "Explosions enabled");
        debug = cfg.getBoolean("debug", c, debug, "Debugging enabled");
        cfg.save();
        if (pluginHooking) {
            InjectionManager.init();
        }
    }

    public static void callEvent(Object event) {
    }

    public static void error(Throwable throwable, String message, Object ... args) {
        if (debug) {
            LOGGER.error((Message)new FormattedMessage(message, args), throwable);
        } else {
            LOGGER.error(message, args);
        }
    }
}

