/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.config;

import com.gamerforea.eventhelper.EventHelper;
import com.gamerforea.eventhelper.config.ClassSet;
import com.gamerforea.eventhelper.config.Config;
import com.gamerforea.eventhelper.config.ConfigBoolean;
import com.gamerforea.eventhelper.config.ConfigClassSet;
import com.gamerforea.eventhelper.config.ConfigEnum;
import com.gamerforea.eventhelper.config.ConfigFloat;
import com.gamerforea.eventhelper.config.ConfigInt;
import com.gamerforea.eventhelper.config.ConfigItemBlockList;
import com.gamerforea.eventhelper.config.ConfigString;
import com.gamerforea.eventhelper.config.ConfigStringCollection;
import com.gamerforea.eventhelper.config.ItemBlockList;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class ConfigUtils {
    private static final String PACKAGE_DEFAULT = "default";
    private static final Set<Class<?>> LOADED_CONFIG_CLASSES = new HashSet();

    public static Set<String> reloadAllConfigs() {
        TreeSet<String> configNames = new TreeSet<String>();
        for (Class<?> configClass : LOADED_CONFIG_CLASSES) {
            try {
                ConfigUtils.readConfig(configClass, true);
                configNames.add(ConfigUtils.getConfigName(configClass));
            }
            catch (Throwable throwable) {}
        }
        return configNames;
    }

    @Nonnull
    public static <T extends Collection<String>> T readStringCollection(@Nonnull Configuration cfg, @Nonnull String name, @Nonnull String category, @Nonnull String comment, @Nonnull T def) {
        String[] temp = cfg.getStringList(name, category, def.toArray((String[])new String[0]), comment);
        def.clear();
        Collections.addAll(def, temp);
        return (T)def;
    }

    @Nonnull
    public static Configuration getConfig(@Nonnull Class<?> configClass) {
        return ConfigUtils.getConfig(ConfigUtils.getConfigName(configClass));
    }

    @Nonnull
    public static Configuration getConfig(@Nonnull String cfgName) {
        Configuration cfg = new Configuration(new File(EventHelper.cfgDir, cfgName + ".cfg"));
        cfg.load();
        return cfg;
    }

    public static void readConfig(@Nonnull Class<?> configClass) {
        ConfigUtils.readConfig(configClass, false);
    }

    public static void readConfig(@Nonnull Class<?> configClass, @Nonnull String configName) {
        ConfigUtils.readConfig(configClass, configName, false);
    }

    public static void readConfig(@Nonnull Class<?> configClass, boolean reload) {
        ConfigUtils.readConfig(configClass, ConfigUtils.getConfigName(configClass), reload);
    }

    public static void readConfig(@Nonnull Class<?> configClass, @Nonnull String configName, boolean reload) {
        if (!LOADED_CONFIG_CLASSES.add(configClass) && !reload) {
            return;
        }
        Configuration cfg = ConfigUtils.getConfig(configName);
        try {
            for (Field field : configClass.getDeclaredFields()) {
                try {
                    ConfigUtils.readConfigProperty(cfg, field);
                }
                catch (Throwable throwable) {
                    EventHelper.LOGGER.error("Failed reading property {} in config {}", new Object[]{field, cfg.getConfigFile().getName(), throwable});
                }
            }
        }
        catch (Throwable throwable) {
            EventHelper.LOGGER.error("Failed reading config {}", new Object[]{cfg.getConfigFile().getName(), throwable});
        }
        cfg.save();
    }

    private static void readConfigProperty(@Nonnull Configuration cfg, @Nonnull Field field) throws IllegalAccessException {
        if (Modifier.isStatic(field.getModifiers())) {
            field.setAccessible(true);
            for (Annotation declaredAnnotation : field.getDeclaredAnnotations()) {
                String name;
                Annotation annotation;
                Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
                if (annotationType == ConfigBoolean.class) {
                    ConfigUtils.checkType(field, Boolean.TYPE);
                    ConfigUtils.checkNotFinal(field);
                    annotation = (ConfigBoolean)declaredAnnotation;
                    name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                    ConfigUtils.tryMoveProperty(cfg, name, annotation.category(), annotation.oldName(), annotation.oldCategory());
                    boolean defaultValue = field.getBoolean(null);
                    boolean value = cfg.getBoolean(name, annotation.category(), defaultValue, annotation.comment());
                    field.setBoolean(null, value);
                    continue;
                }
                if (annotationType == ConfigFloat.class) {
                    ConfigUtils.checkType(field, Float.TYPE);
                    ConfigUtils.checkNotFinal(field);
                    annotation = (ConfigFloat)declaredAnnotation;
                    name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                    ConfigUtils.tryMoveProperty(cfg, name, annotation.category(), annotation.oldName(), annotation.oldCategory());
                    float defaultValue = field.getFloat(null);
                    float value = cfg.getFloat(name, annotation.category(), defaultValue, annotation.min(), annotation.max(), annotation.comment());
                    field.setFloat(null, value);
                    continue;
                }
                if (annotationType == ConfigInt.class) {
                    ConfigUtils.checkType(field, Integer.TYPE);
                    ConfigUtils.checkNotFinal(field);
                    annotation = (ConfigInt)declaredAnnotation;
                    name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                    ConfigUtils.tryMoveProperty(cfg, name, annotation.category(), annotation.oldName(), annotation.oldCategory());
                    int defaultValue = field.getInt(null);
                    int value = cfg.getInt(name, annotation.category(), defaultValue, annotation.min(), annotation.max(), annotation.comment());
                    field.setInt(null, value);
                    continue;
                }
                if (annotationType == ConfigString.class) {
                    ConfigUtils.checkType(field, String.class);
                    ConfigUtils.checkNotFinal(field);
                    annotation = (ConfigString)declaredAnnotation;
                    name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                    ConfigUtils.tryMoveProperty(cfg, name, annotation.category(), annotation.oldName(), annotation.oldCategory());
                    String defaultValue = (String)field.get(null);
                    String value = cfg.getString(name, annotation.category(), defaultValue, annotation.comment());
                    field.set(null, value);
                    continue;
                }
                if (annotationType == ConfigItemBlockList.class) {
                    ConfigUtils.checkType(field, ItemBlockList.class);
                    annotation = (ConfigItemBlockList)declaredAnnotation;
                    name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                    ConfigUtils.tryMoveProperty(cfg, name, annotation.category(), annotation.oldName(), annotation.oldCategory());
                    ItemBlockList list = (ItemBlockList)field.get(null);
                    Objects.requireNonNull(list, field + " value must not be null");
                    Set values = ConfigUtils.readStringCollection(cfg, name, annotation.category(), annotation.comment(), new HashSet<String>(list.getRaw()));
                    list.clear();
                    list.addRaw(values);
                    continue;
                }
                if (annotationType == ConfigClassSet.class) {
                    ConfigUtils.checkType(field, ClassSet.class);
                    annotation = (ConfigClassSet)declaredAnnotation;
                    name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                    ConfigUtils.tryMoveProperty(cfg, name, annotation.category(), annotation.oldName(), annotation.oldCategory());
                    ClassSet classSet = (ClassSet)field.get(null);
                    Objects.requireNonNull(classSet, field + " value must not be null");
                    Set values = ConfigUtils.readStringCollection(cfg, name, annotation.category(), annotation.comment(), new HashSet<String>(classSet.getRaw()));
                    classSet.clear();
                    classSet.addRaw(values);
                    continue;
                }
                if (annotationType == ConfigEnum.class) {
                    ConfigUtils.checkType(field, Enum.class);
                    ConfigUtils.checkNotFinal(field);
                    annotation = (ConfigEnum)declaredAnnotation;
                    name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                    ConfigUtils.tryMoveProperty(cfg, name, annotation.category(), annotation.oldName(), annotation.oldCategory());
                    Enum defaultValue = (Enum)field.get(null);
                    Objects.requireNonNull(defaultValue, field + " value must not be null");
                    String valueName = cfg.getString(name, annotation.category(), defaultValue.name(), annotation.comment());
                    try {
                        Object value = Enum.valueOf(defaultValue.getDeclaringClass(), valueName);
                        field.set(null, value);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (annotationType != ConfigStringCollection.class) continue;
                ConfigUtils.checkType(field, Collection.class);
                annotation = (ConfigStringCollection)declaredAnnotation;
                name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                ConfigUtils.tryMoveProperty(cfg, name, annotation.category(), annotation.oldName(), annotation.oldCategory());
                Collection collection = (Collection)field.get(null);
                Objects.requireNonNull(collection, field + " value must not be null");
                ConfigUtils.readStringCollection(cfg, name, annotation.category(), annotation.comment(), collection);
            }
        }
    }

    private static void checkType(@Nonnull Field field, @Nonnull Class<?> expectedType) {
        Class<?> type = field.getType();
        Preconditions.checkArgument((expectedType == type || expectedType.isAssignableFrom(type) ? 1 : 0) != 0, (Object)(field + " type must be " + expectedType + " ( real type is " + type + ')'));
    }

    private static void checkNotFinal(@Nonnull Field field) {
        int modifiers = field.getModifiers();
        Preconditions.checkArgument((!Modifier.isFinal(modifiers) ? 1 : 0) != 0, (Object)(field + " must not be final"));
    }

    private static boolean tryMoveProperty(@Nonnull Configuration cfg, @Nonnull String newName, @Nonnull String newCategory, @Nullable String oldName, @Nullable String oldCategory) {
        if (newName.isEmpty() || newCategory.isEmpty()) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)oldCategory)) {
            oldCategory = newCategory;
        }
        if (Strings.isNullOrEmpty((String)oldName)) {
            oldName = newName;
        }
        if (newName.equalsIgnoreCase(oldName) && newCategory.equalsIgnoreCase(oldCategory)) {
            return false;
        }
        if (cfg.hasKey(newCategory, newName) || !cfg.hasKey(oldCategory, oldName)) {
            return false;
        }
        ConfigCategory prevCategory = cfg.getCategory(oldCategory);
        if (prevCategory.containsKey(oldName)) {
            ConfigCategory category;
            Property property = prevCategory.remove((Object)oldName);
            property.setName(newName);
            if (newCategory.equalsIgnoreCase(oldCategory)) {
                category = prevCategory;
            } else {
                category = cfg.getCategory(newCategory);
                if (prevCategory.isEmpty()) {
                    cfg.removeCategory(prevCategory);
                }
            }
            category.put(newName, property);
            return true;
        }
        return false;
    }

    @Nonnull
    private static String getConfigName(@Nonnull Class<?> configClass) {
        Config annotation = configClass.getAnnotation(Config.class);
        Objects.requireNonNull(annotation, "Annotaion " + Config.class.getName() + " not found for class " + configClass.getName());
        String cfgName = annotation.name();
        if (Strings.isNullOrEmpty((String)cfgName)) {
            cfgName = ConfigUtils.getPackageName(configClass.getName());
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cfgName) ? 1 : 0) != 0, (Object)("Config name for class " + configClass.getName() + " is not determined"));
        return cfgName;
    }

    @Nonnull
    private static String getPackageName(@Nullable String className) {
        if (Strings.isNullOrEmpty((String)className)) {
            return PACKAGE_DEFAULT;
        }
        int classDelimeterIndex = className.lastIndexOf(46);
        if (classDelimeterIndex == -1) {
            return PACKAGE_DEFAULT;
        }
        String packageName = className.substring(0, classDelimeterIndex);
        if (Strings.isNullOrEmpty((String)packageName)) {
            return PACKAGE_DEFAULT;
        }
        int packageDelimeterIndex = packageName.lastIndexOf(46);
        if (packageDelimeterIndex == -1) {
            return packageName;
        }
        String simplePackageName = packageName.substring(packageDelimeterIndex + 1);
        return Strings.isNullOrEmpty((String)simplePackageName) ? PACKAGE_DEFAULT : simplePackageName;
    }
}

