/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.nexus;

import com.gamerforea.eventhelper.nexus.ModNexus;
import com.gamerforea.eventhelper.nexus.ModNexusFactory;
import com.gamerforea.eventhelper.util.ReflectionUtils;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;

public final class NexusUtils {
    @Nonnull
    public static ModNexusFactory getFactory() {
        return NexusUtils.getFactory(NexusUtils.getGameProfile());
    }

    @Nonnull
    public static ModNexusFactory getFactory(@Nonnull Class<?> modNexusClass) {
        return NexusUtils.getFactory(NexusUtils.getGameProfile(modNexusClass));
    }

    @Nonnull
    public static ModNexusFactory getFactory(@Nonnull GameProfile profile) {
        return new ModNexusFactory(profile);
    }

    @Nonnull
    public static GameProfile getGameProfile() {
        Class[] callingClasses = ReflectionUtils.getCallingClasses();
        HashSet<Class> visitedClasses = new HashSet<Class>(callingClasses.length);
        for (Class callerClass : callingClasses) {
            ModNexus annotation;
            if (!visitedClasses.add(callerClass) || (annotation = callerClass.getAnnotation(ModNexus.class)) == null) continue;
            return NexusUtils.getGameProfile(callerClass);
        }
        throw new IllegalStateException("Class with ModNexus annotation not found in StackTrace");
    }

    @Nonnull
    public static GameProfile getGameProfile(@Nonnull Class<?> modNexusClass) {
        ModNexus annotation = NexusUtils.getModNexusAnnotation(modNexusClass);
        return annotation.uuid().isEmpty() ? NexusUtils.getGameProfile(annotation.name()) : NexusUtils.getGameProfile(annotation.name(), UUID.fromString(annotation.uuid()));
    }

    @Nonnull
    public static GameProfile getGameProfile(@Nonnull String fakeName) {
        Preconditions.checkArgument((!fakeName.isEmpty() ? 1 : 0) != 0, (Object)"fakeName must not be empty");
        if (fakeName.charAt(0) != '[') {
            fakeName = '[' + fakeName + ']';
        }
        return NexusUtils.getGameProfile(fakeName, NexusUtils.stringToId(fakeName));
    }

    @Nonnull
    public static GameProfile getGameProfile(@Nonnull String fakeName, @Nonnull UUID fakeId) {
        Preconditions.checkArgument((!fakeName.isEmpty() ? 1 : 0) != 0, (Object)"fakeName must not be empty");
        if (fakeName.charAt(0) != '[') {
            fakeName = '[' + fakeName + ']';
        }
        return new GameProfile(fakeId, fakeName);
    }

    @Nonnull
    private static UUID stringToId(@Nonnull String fakeName) {
        return new UUID(Hashing.md5().hashBytes(fakeName.getBytes(StandardCharsets.UTF_8)).asLong(), Hashing.sha1().hashBytes(fakeName.getBytes(StandardCharsets.UTF_8)).asLong());
    }

    @Nonnull
    private static ModNexus getModNexusAnnotation(@Nonnull Class<?> modNexusClass) {
        ModNexus annotation = modNexusClass.getAnnotation(ModNexus.class);
        Preconditions.checkNotNull((Object)annotation, (Object)("ModNexus annotation not found in class " + modNexusClass.getName()));
        Preconditions.checkArgument((!annotation.name().isEmpty() ? 1 : 0) != 0, (Object)"ModNexus.name() must not be empty");
        return annotation;
    }
}

