/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.util;

import com.gamerforea.eventhelper.EventHelper;
import com.gamerforea.eventhelper.fake.FakePlayerContainer;
import com.gamerforea.eventhelper.util.EventUtils;
import com.gamerforea.eventhelper.util.FastUtils;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public final class ExplosionByPlayer
extends Explosion {
    private final EntityPlayer player;
    private final World world;
    private final Map<EntityPlayer, Vec3> playerKnockbackMap = new HashMap<EntityPlayer, Vec3>();

    public ExplosionByPlayer(@Nonnull GameProfile modFakeProfile, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size) {
        this((EntityPlayer)(player == null ? (exploder instanceof EntityPlayer ? (EntityPlayer)exploder : FastUtils.getFake(world, modFakeProfile)) : player), world, exploder, x, y, z, size);
    }

    public ExplosionByPlayer(@Nonnull FakePlayer modFake, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size) {
        this((EntityPlayer)(player == null ? (exploder instanceof EntityPlayer ? (EntityPlayer)exploder : modFake) : player), world, exploder, x, y, z, size);
    }

    public ExplosionByPlayer(@Nonnull FakePlayerContainer fake, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size) {
        this(fake.get(), world, exploder, x, y, z, size);
    }

    public ExplosionByPlayer(@Nonnull EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size) {
        super(world, exploder, x, y, z, size);
        this.world = world;
        this.player = player;
    }

    public void doExplosionA() {
        if (!EventHelper.explosions) {
            return;
        }
        this.affectedBlockPositions.addAll(this.getPositions());
        float size = this.explosionSize;
        this.explosionSize *= 2.0f;
        int minX = MathHelper.floor_double((double)(this.explosionX - (double)this.explosionSize - 1.0));
        int maxX = MathHelper.floor_double((double)(this.explosionX + (double)this.explosionSize + 1.0));
        int minY = MathHelper.floor_double((double)(this.explosionY - (double)this.explosionSize - 1.0));
        int maxY = MathHelper.floor_double((double)(this.explosionY + (double)this.explosionSize + 1.0));
        int minZ = MathHelper.floor_double((double)(this.explosionZ - (double)this.explosionSize - 1.0));
        int maxZ = MathHelper.floor_double((double)(this.explosionZ + (double)this.explosionSize + 1.0));
        List entities = this.world.getEntitiesWithinAABBExcludingEntity(this.exploder, AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        Vec3 vec3 = Vec3.createVectorHelper((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (Entity entity : entities) {
            double distanceZ;
            double distanceY;
            double distanceX;
            double distance1;
            double distance = entity.getDistance(this.explosionX, this.explosionY, this.explosionZ) / (double)this.explosionSize;
            if (!(distance <= 1.0) || (distance1 = (double)MathHelper.sqrt_double((double)((distanceX = entity.posX - this.explosionX) * distanceX + (distanceY = entity.posY + (double)entity.getEyeHeight() - this.explosionY) * distanceY + (distanceZ = entity.posZ - this.explosionZ) * distanceZ))) == 0.0 || EventUtils.cantDamage((Entity)this.player, entity)) continue;
            distanceX /= distance1;
            distanceY /= distance1;
            distanceZ /= distance1;
            double density = this.world.getBlockDensity(vec3, entity.boundingBox);
            double d5 = (1.0 - distance) * density;
            entity.attackEntityFrom(DamageSource.setExplosionSource((Explosion)this), (float)((int)((d5 * d5 + d5) / 2.0 * 8.0 * (double)this.explosionSize + 1.0)));
            double d6 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d5);
            entity.motionX += distanceX * d6;
            entity.motionY += distanceY * d6;
            entity.motionZ += distanceZ * d6;
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            this.playerKnockbackMap.put(player, Vec3.createVectorHelper((double)(distanceX * d5), (double)(distanceY * d5), (double)(distanceZ * d5)));
        }
        this.explosionSize = size;
    }

    private Set<ChunkPosition> getPositions() {
        HashSet<ChunkPosition> set = new HashSet<ChunkPosition>();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double distanceX = (float)i / 30.0f - 1.0f;
                    double distanceY = (float)j / 30.0f - 1.0f;
                    double distanceZ = (float)k / 30.0f - 1.0f;
                    double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                    distanceX /= distance;
                    distanceY /= distance;
                    distanceZ /= distance;
                    double dX = this.explosionX;
                    double dY = this.explosionY;
                    double dZ = this.explosionZ;
                    float f = 0.3f;
                    for (float size = this.explosionSize * (0.7f + this.world.rand.nextFloat() * 0.6f); size > 0.0f; size -= f * 0.75f) {
                        int z;
                        int y;
                        int x = MathHelper.floor_double((double)dX);
                        Block block = this.world.getBlock(x, y = MathHelper.floor_double((double)dY), z = MathHelper.floor_double((double)dZ));
                        if (block.getMaterial() != Material.air) {
                            float resistance = this.exploder != null ? this.exploder.func_145772_a((Explosion)this, this.world, x, y, z, block) : block.getExplosionResistance(this.exploder, this.world, x, y, z, this.explosionX, this.explosionY, this.explosionZ);
                            size -= (resistance + 0.3f) * f;
                        }
                        if (size > 0.0f && (this.exploder == null || this.exploder.func_145774_a((Explosion)this, this.world, x, y, z, block, size)) && !EventUtils.cantBreak(this.player, x, y, z)) {
                            set.add(new ChunkPosition(x, y, z));
                        }
                        dX += distanceX * (double)f;
                        dY += distanceY * (double)f;
                        dZ += distanceZ * (double)f;
                    }
                }
            }
        }
        return set;
    }

    public Map func_77277_b() {
        return this.playerKnockbackMap;
    }

    public static ExplosionByPlayer createExplosion(@Nonnull GameProfile modFakeProfile, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean smoke) {
        return ExplosionByPlayer.newExplosion(modFakeProfile, player, world, exploder, x, y, z, size, false, smoke);
    }

    public static ExplosionByPlayer createExplosion(@Nonnull FakePlayer modFake, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean smoke) {
        return ExplosionByPlayer.newExplosion(modFake, player, world, exploder, x, y, z, size, false, smoke);
    }

    @Nonnull
    public static ExplosionByPlayer createExplosion(@Nonnull FakePlayerContainer fake, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean smoke) {
        return ExplosionByPlayer.newExplosion(fake, world, exploder, x, y, z, size, false, smoke);
    }

    @Nonnull
    public static ExplosionByPlayer createExplosion(@Nonnull EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean smoke) {
        return ExplosionByPlayer.newExplosion(player, world, exploder, x, y, z, size, false, smoke);
    }

    public static ExplosionByPlayer newExplosion(@Nonnull GameProfile modFakeProfile, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean flame, boolean smoke) {
        ExplosionByPlayer explosion = new ExplosionByPlayer(modFakeProfile, player, world, exploder, x, y, z, size);
        return ExplosionByPlayer.newExplosion(explosion, world, x, y, z, size, flame, smoke);
    }

    public static ExplosionByPlayer newExplosion(@Nonnull FakePlayer modFake, @Nullable EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean flame, boolean smoke) {
        ExplosionByPlayer explosion = new ExplosionByPlayer(modFake, player, world, exploder, x, y, z, size);
        return ExplosionByPlayer.newExplosion(explosion, world, x, y, z, size, flame, smoke);
    }

    @Nonnull
    public static ExplosionByPlayer newExplosion(@Nonnull FakePlayerContainer fake, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean flame, boolean smoke) {
        ExplosionByPlayer explosion = new ExplosionByPlayer(fake, world, exploder, x, y, z, size);
        return ExplosionByPlayer.newExplosion(explosion, world, x, y, z, size, flame, smoke);
    }

    @Nonnull
    public static ExplosionByPlayer newExplosion(@Nonnull EntityPlayer player, @Nonnull World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean flame, boolean smoke) {
        ExplosionByPlayer explosion = new ExplosionByPlayer(player, world, exploder, x, y, z, size);
        return ExplosionByPlayer.newExplosion(explosion, world, x, y, z, size, flame, smoke);
    }

    private static ExplosionByPlayer newExplosion(@Nonnull ExplosionByPlayer explosion, @Nonnull World world, double x, double y, double z, float size, boolean flame, boolean smoke) {
        explosion.isFlaming = flame;
        explosion.isSmoking = smoke;
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            return explosion;
        }
        boolean isServerWorld = world instanceof WorldServer;
        explosion.doExplosionA();
        explosion.doExplosionB(!isServerWorld);
        if (isServerWorld) {
            if (!smoke) {
                explosion.affectedBlockPositions.clear();
            }
            for (EntityPlayer target : world.playerEntities) {
                if (!(target.getDistanceSq(x, y, z) < 4096.0)) continue;
                ((EntityPlayerMP)target).playerNetServerHandler.sendPacket((Packet)new S27PacketExplosion(x, y, z, size, explosion.affectedBlockPositions, (Vec3)explosion.func_77277_b().get(target)));
            }
        }
        return explosion;
    }
}

