/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.config;

import com.gamerforea.eventhelper.EventHelper;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public final class ItemBlockList {
    private static final String[] DEFAULT_VALUES = new String[]{"minecraft:bedrock", "modid:block_name@meta"};
    private static final char SEPARATOR = '@';
    private static final int ALL_META = -1;
    private final Set<String> rawSet = new HashSet<String>();
    private final Map<Item, TIntSet> items = new HashMap<Item, TIntSet>();
    private final Map<Block, TIntSet> blocks = new HashMap<Block, TIntSet>();
    private boolean loaded = true;

    public ItemBlockList() {
        this(false);
    }

    public ItemBlockList(boolean initWithDefaultValues) {
        if (initWithDefaultValues) {
            this.addRaw(Arrays.asList(DEFAULT_VALUES));
        }
    }

    public void clear() {
        this.loaded = true;
        this.items.clear();
        this.blocks.clear();
        this.rawSet.clear();
    }

    public Set<String> getRaw() {
        return Collections.unmodifiableSet(this.rawSet);
    }

    public void addRaw(@Nonnull Collection<String> strings) {
        this.loaded = false;
        this.items.clear();
        this.blocks.clear();
        this.rawSet.addAll(strings);
    }

    public boolean isEmpty() {
        this.load();
        return this.items.isEmpty() && this.blocks.isEmpty();
    }

    public boolean contains(@Nullable ItemStack stack) {
        return stack != null && this.contains(stack.func_77973_b(), stack.func_77960_j());
    }

    public boolean contains(@Nonnull Item item, int meta) {
        this.load();
        return item instanceof ItemBlock && this.contains(((ItemBlock)item).field_150939_a, meta) || ItemBlockList.contains(this.items, item, meta);
    }

    public boolean contains(@Nonnull Block block, int meta) {
        this.load();
        return ItemBlockList.contains(this.blocks, block, meta);
    }

    private void load() {
        if (!this.loaded) {
            this.loaded = true;
            FMLControlledNamespacedRegistry itemRegistry = GameData.getItemRegistry();
            FMLControlledNamespacedRegistry blockRegistry = GameData.getBlockRegistry();
            for (String s : this.rawSet) {
                Block block;
                String[] parts;
                if ((s = s.trim()).isEmpty() || (parts = StringUtils.split((String)s, (char)'@')) == null || parts.length <= 0) continue;
                String name = parts[0];
                int meta = parts.length > 1 ? ItemBlockList.safeParseInt(parts[1]) : -1;
                Item item = (Item)itemRegistry.func_82594_a(name);
                if (item != null) {
                    ItemBlockList.put(this.items, item, meta);
                }
                if ((block = (Block)blockRegistry.func_82594_a(name)) != null && block != Blocks.field_150350_a) {
                    ItemBlockList.put(this.blocks, block, meta);
                }
                if (!EventHelper.debug || item != null || block != null && block != Blocks.field_150350_a) continue;
                EventHelper.LOGGER.warn("Item/block {} not found", new Object[]{name});
            }
        }
    }

    private static <K> boolean put(Map<K, TIntSet> map, K key, int value) {
        TIntSet set = map.get(key);
        if (set == null) {
            set = new TIntHashSet();
            map.put(key, set);
        }
        return set.add(value);
    }

    private static <K> boolean contains(Map<K, TIntSet> map, K key, int value) {
        TIntSet set = map.get(key);
        return set != null && (set.contains(value) || set.contains(-1));
    }

    private static int safeParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }
}

