/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.eventhelper.util;

import com.gamerforea.eventhelper.util.CraftUtils;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class ConvertUtils {
    private static final Method getBukkitEntity;
    private static final Method asCraftMirror;

    public static org.bukkit.entity.Entity toBukkitEntity(Entity entity) throws Exception {
        return (org.bukkit.entity.Entity)getBukkitEntity.invoke((Object)entity, new Object[0]);
    }

    public static Player toBukkitEntity(EntityPlayer player) throws Exception {
        return (Player)getBukkitEntity.invoke((Object)player, new Object[0]);
    }

    public static org.bukkit.World toBukkitWorld(World world) {
        return Bukkit.getWorld((String)world.func_72912_H().func_76065_j());
    }

    public static ItemStack toBukkitItemStackMirror(net.minecraft.item.ItemStack stack) throws Exception {
        return (ItemStack)asCraftMirror.invoke(null, stack);
    }

    public static BlockFace toBukkitFace(ForgeDirection direction) {
        switch (direction) {
            case DOWN: {
                return BlockFace.DOWN;
            }
            case UP: {
                return BlockFace.UP;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
            case UNKNOWN: {
                return BlockFace.SELF;
            }
        }
        return BlockFace.SELF;
    }

    static {
        try {
            getBukkitEntity = Entity.class.getDeclaredMethod("getBukkitEntity", new Class[0]);
            getBukkitEntity.setAccessible(true);
            asCraftMirror = CraftUtils.getCraftClass("inventory.CraftItemStack").getDeclaredMethod("asCraftMirror", net.minecraft.item.ItemStack.class);
            asCraftMirror.setAccessible(true);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed hooking CraftBukkit methods!", throwable);
        }
    }
}

