/*
 * Decompiled with CFR 0.152.
 */
package com.integral.grimoire;

import com.integral.grimoire.ExtraShenanigans;
import com.integral.grimoire.GrimoireExtension;
import com.integral.grimoire.chadmc.ChadShenanigans;
import com.integral.grimoire.incelmc.IncelShenanigans;
import com.integral.grimoire.tasks.ClearBuildTask;
import com.integral.grimoire.tasks.ClearResourcesTask;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AccessRule;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

public class GrimoireShenanigans
implements Plugin<Project> {
    public Project project;
    public ExtraShenanigans extraShenanigans;
    public Rule forbiddenRule;
    protected boolean enabled = false;

    public void apply(final Project project) {
        this.enabled = true;
        this.project = project;
        this.applyExternalPlugin("maven-publish");
        this.applyExternalPlugin("eclipse");
        project.getExtensions().create("grimoire", GrimoireExtension.class, new Object[]{this});
        try {
            this.project.getTasks().getByName("clearBuildCache");
            this.project.getTasks().getByName("clearResourcesCache");
        }
        catch (Exception ex) {
            this.project.getTasks().getByName("compileJava").dependsOn(new Object[]{this.makeTask("clearBuildCache", ClearBuildTask.class)});
            this.project.getTasks().getByName("processResources").dependsOn(new Object[]{this.makeTask("clearResourcesCache", ClearResourcesTask.class)});
        }
        if (this.areGrimoireShenanigansEnabled()) {
            try {
                Class.forName("net.minecraftforge.gradle.userdev.UserDevPlugin");
                this.extraShenanigans = new IncelShenanigans(this);
            }
            catch (Exception ex) {
                try {
                    Class.forName("net.minecraftforge.gradle.user.patch.FmlUserPlugin");
                    this.extraShenanigans = new ChadShenanigans(this);
                }
                catch (Exception ex2) {
                    throw new RuntimeException("Could not located any valid ForgeGradle version!", ex2);
                }
            }
            if (this.extraShenanigans != null) {
                this.applyGrimoireShenanigans();
            } else {
                this.project.getLogger().error("Failed to instantiate ExtraShenanigans!");
            }
        }
        this.project.afterEvaluate(new Action(){

            public void execute(Object arg) {
                project.getLogger().lifecycle("Grimoire shenanigans " + (GrimoireShenanigans.this.areGrimoireShenanigansEnabled() ? "enabled" : "disabled"));
                if (GrimoireShenanigans.this.extraShenanigans.isChadMC() && GrimoireShenanigans.this.areGrimoireShenanigansEnabled()) {
                    project.getLogger().lifecycle("Using Mixin refmap name: " + GrimoireShenanigans.this.getMixinRefmapName());
                }
            }
        });
    }

    protected void applyGrimoireShenanigans() {
        this.addMavenRepo(this.project, "spongepowered-repo", "https://repo.spongepowered.org/repository/maven-public/");
        this.addMavenRepo(this.project, "juan-github", "https://github.com/juanmuscaria/maven/raw/master/");
        this.project.getRepositories().mavenCentral();
        Task copyTask = this.extraShenanigans.copySrgsTask();
        JavaCompile compileJava = (JavaCompile)this.project.getTasks().getByName("compileJava");
        if (copyTask != null) {
            copyTask.dependsOn(new Object[]{"genSrgs"});
            compileJava.dependsOn(new Object[]{copyTask});
        }
        this.project.getDependencies().add("annotationProcessor", (Object)this.extraShenanigans.getAnnotationProccessor());
        if (!this.isGrimoireItself()) {
            if (!this.disableGrimoireDependency()) {
                if (this.extraShenanigans.isChadMC()) {
                    this.project.getDependencies().add("compileOnly", (Object)("io.github.crucible.grimoire:Grimoire-mc1.7.10-api:" + this.grimoireVersion()));
                    this.project.getDependencies().add("runtimeOnly", (Object)("io.github.crucible.grimoire:Grimoire-mc1.7.10-dev:" + this.grimoireVersion()));
                } else {
                    this.project.getDependencies().add("compileOnly", (Object)("io.github.crucible.grimoire:Grimoire-mc1.12.2-api:" + this.grimoireVersion()));
                    this.project.getDependencies().add("runtimeOnly", (Object)("io.github.crucible.grimoire:Grimoire-mc1.12.2-dev:" + this.grimoireVersion()));
                }
            }
            EclipseModel eclipse = (EclipseModel)this.project.getExtensions().getByName("eclipse");
            ArrayList<AccessRule> basicRules = new ArrayList<AccessRule>();
            this.addRule(basicRules, this.getForbiddenRule(), "com/gamerforea/eventhelper/config/**");
            this.addRule(basicRules, this.getForbiddenRule(), "com/gamerforea/eventhelper/util/EventUtils**");
            this.addRule(basicRules, this.getForbiddenRule(), "io/github/crucible/grimoire/common/????*/**");
            this.addRule(basicRules, this.getForbiddenRule(), "io/github/crucible/grimoire/mc1_7_10/????*/**");
            this.addRule(basicRules, this.getForbiddenRule(), "io/github/crucible/grimoire/mc1_12_2/????*/**");
            this.addRule(basicRules, this.getForbiddenRule(), "io/github/crucible/omniconfig/????*/**");
            this.addRule(basicRules, this.getForbiddenRule(), "io/github/crucible/omniconfig/lib/**");
            eclipse.classpath(path -> path.file(file -> file.whenMerged(obj -> {
                if (obj instanceof Classpath) {
                    Classpath clp = (Classpath)obj;
                    clp.getEntries().forEach(entryObj -> {
                        AbstractClasspathEntry abs;
                        if (entryObj instanceof AbstractClasspathEntry && "lib".equals((abs = (AbstractClasspathEntry)entryObj).getKind())) {
                            abs.getAccessRules().addAll(basicRules);
                        }
                    });
                }
            })));
        }
        if (this.extraShenanigans.isChadMC()) {
            this.project.file((Object)(this.project.getBuildDir().getName() + "/mixins")).mkdirs();
            File mixinSrg = this.project.file((Object)(this.project.getBuildDir().getName() + "/mixins/mixins." + this.project.getName() + ".srg"));
            File mixinRefMap = this.project.file((Object)(this.project.getBuildDir().getName() + "/mixins/" + this.getMixinRefmapName().replace("/", "$").replace(File.separator, "$")));
            this.project.getExtensions().getExtraProperties().set("mixinSrg", (Object)mixinSrg);
            this.project.getExtensions().getExtraProperties().set("mixinRefMap", (Object)mixinRefMap);
            try {
                List compilerArgs = compileJava.getOptions().getCompilerArgs();
                compilerArgs.add("-Xlint:-processing");
                compilerArgs.add("-AoutSrgFile=" + mixinSrg.getCanonicalPath());
                compilerArgs.add("-AoutRefMapFile=" + mixinRefMap.getCanonicalPath());
                compilerArgs.add("-AreobfSrgFile=" + this.project.file((Object)(this.project.getBuildDir().getName() + "/srgs/mcp-srg.srg")).getCanonicalPath());
                compileJava.getOptions().setCompilerArgs(compilerArgs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Jar jarTask = (Jar)this.project.getTasks().getByName("jar");
            jarTask.from(new Object[]{mixinRefMap}).into((Object)this.getMixinRefmapName().replace("$", "/"));
            this.extraShenanigans.extraReobfMap(mixinSrg);
            ProcessResources processResources = (ProcessResources)this.project.getTasks().getByName("processResources");
            LinkedHashMap propertyMap = new LinkedHashMap();
            LinkedHashMap<String, String> tokenMap = new LinkedHashMap<String, String>();
            tokenMap.put("MIXIN_REFMAP", this.getMixinRefmapName());
            propertyMap.put("tokens", tokenMap);
            processResources.filter(propertyMap, ReplaceTokens.class);
            this.extraShenanigans.addSourceReplacements();
        }
    }

    private void addRule(List<AccessRule> rules, Rule rule, String pattern) {
        rules.add(new AccessRule(rule.getName(), pattern));
    }

    public String grimoireVersion() {
        return this.project.hasProperty("grimoireVersion") ? this.project.getProperties().get("grimoireVersion").toString() : "+";
    }

    public boolean areGrimoireShenanigansEnabled() {
        return this.enabled;
    }

    public Rule getForbiddenRule() {
        if (this.forbiddenRule == null) {
            if (this.project.hasProperty("grimoireRestrictionRule")) {
                try {
                    this.forbiddenRule = Rule.valueOf(String.valueOf(this.project.getProperties().get("grimoireRestrictionRule")));
                }
                catch (Exception ex) {
                    this.forbiddenRule = Rule.FORBIDDEN;
                }
            } else {
                this.forbiddenRule = Rule.FORBIDDEN;
            }
        }
        return this.forbiddenRule;
    }

    public boolean isGrimoireItself() {
        if (this.project.hasProperty("isGrimoireItself")) {
            return Boolean.parseBoolean(String.valueOf(this.project.getProperties().get("isGrimoireItself")));
        }
        return false;
    }

    public boolean disableGrimoireDependency() {
        if (this.project.hasProperty("disableGrimoireDependency")) {
            return Boolean.parseBoolean(String.valueOf(this.project.getProperties().get("disableGrimoireDependency")));
        }
        return false;
    }

    public String getMixinRefmapName() {
        if (this.project.hasProperty("mixinRefmapName")) {
            return String.valueOf(this.project.getProperties().get("mixinRefmapName"));
        }
        return this.project.getName() + ".refmap.json";
    }

    public void applyExternalPlugin(String plugin) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("plugin", plugin);
        this.project.apply(map);
    }

    public DefaultTask makeTask(String name) {
        return this.makeTask(name, DefaultTask.class);
    }

    public <T extends Task> T makeTask(String name, Class<T> type) {
        return GrimoireShenanigans.makeTask(this.project, name, type);
    }

    public MavenArtifactRepository addMavenRepo(Project proj, final String name, final String url) {
        return proj.getRepositories().maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository repo) {
                repo.setName(name);
                repo.setUrl((Object)url);
            }
        });
    }

    public FlatDirectoryArtifactRepository addFlatRepo(Project proj, final String name, final Object ... dirs) {
        return proj.getRepositories().flatDir((Action)new Action<FlatDirectoryArtifactRepository>(){

            public void execute(FlatDirectoryArtifactRepository repo) {
                repo.setName(name);
                repo.dirs(dirs);
            }
        });
    }

    public static <T extends Task> T makeTask(Project proj, String name, Class<T> type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("type", type);
        return (T)proj.task(map, name);
    }

    public static enum Rule {
        FORBIDDEN("nonaccessible"),
        ACESSIBLE("accessible"),
        DISCOURAGED("discouraged");

        private final String name;

        private Rule(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

