/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.column.ColumnMetadata;
import com.jidesoft.thirdparty.prefuse.data.event.ExpressionListener;
import com.jidesoft.thirdparty.prefuse.data.event.ProjectionListener;
import com.jidesoft.thirdparty.prefuse.data.event.TableListener;
import com.jidesoft.thirdparty.prefuse.data.expression.BooleanLiteral;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.data.tuple.TableTuple;
import com.jidesoft.thirdparty.prefuse.data.util.AcceptAllColumnProjection;
import com.jidesoft.thirdparty.prefuse.data.util.CascadedRowManager;
import com.jidesoft.thirdparty.prefuse.data.util.ColumnProjection;
import com.jidesoft.thirdparty.prefuse.util.collections.CompositeIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class CascadedTable
extends Table {
    protected Table m_parent;
    protected ArrayList m_pnames;
    protected ColumnProjection m_colFilter;
    protected Predicate m_rowFilter;
    protected Listener m_listener;

    public CascadedTable(Table table) {
        this(table, null, null);
    }

    public CascadedTable(Table table, Predicate predicate) {
        this(table, predicate, null);
    }

    public CascadedTable(Table table, ColumnProjection columnProjection) {
        this(table, null, columnProjection);
    }

    public CascadedTable(Table table, Predicate predicate, ColumnProjection columnProjection) {
        this(table, predicate, columnProjection, TableTuple.class);
    }

    protected CascadedTable(Table table, Predicate predicate, ColumnProjection columnProjection, Class clazz) {
        super(0, 0, clazz);
        this.m_parent = table;
        this.m_pnames = new ArrayList();
        this.m_rows = new CascadedRowManager(this);
        this.m_rowFilter = predicate == null ? BooleanLiteral.TRUE : predicate;
        this.m_colFilter = columnProjection == null ? new AcceptAllColumnProjection() : columnProjection;
        this.filterColumns();
        this.filterRows();
        this.m_listener = new Listener();
        this.m_parent.addTableListener(this.m_listener);
        if (this.m_rowFilter != BooleanLiteral.TRUE) {
            this.m_rowFilter.addExpressionListener(this.m_listener);
        }
        this.m_colFilter.addProjectionListener(this.m_listener);
    }

    protected CascadedTable() {
        this(TableTuple.class);
    }

    protected CascadedTable(Class clazz) {
        super(0, 0, clazz);
        this.m_pnames = new ArrayList();
    }

    protected void filterColumns() {
        if (this.m_parent == null) {
            return;
        }
        for (int i2 = 0; i2 < this.m_pnames.size(); ++i2) {
            String string = (String)this.m_pnames.get(i2);
            Column column = this.m_parent.getColumn(i2);
            boolean bl = this.m_names.contains(string);
            if (this.m_colFilter.include(column, string) && !bl) continue;
            this.m_pnames.remove(i2--);
            if (!bl) {
                ((Table.ColumnEntry)this.m_entries.get(string)).dispose();
                this.m_entries.remove(string);
            }
            this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), i2, -1);
        }
        this.m_pnames.clear();
        Iterator iterator = this.m_parent.getColumnNames();
        int n2 = 0;
        int n3 = this.m_columns.size();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Column column = this.m_parent.getColumn(n2);
            if (this.m_colFilter.include(column, string) && !this.m_names.contains(string)) {
                this.m_pnames.add(string);
                Table.ColumnEntry columnEntry = (Table.ColumnEntry)this.m_entries.get(string);
                if (columnEntry == null) {
                    columnEntry = new Table.ColumnEntry(n3++, column, new ColumnMetadata(this, string));
                    this.m_entries.put(string, columnEntry);
                    this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), n2, 1);
                } else {
                    columnEntry.colnum = n3++;
                }
                this.m_lastCol = this.m_columns.size() - 1;
            }
            ++n2;
        }
    }

    public void filterRows() {
        if (this.m_parent == null) {
            return;
        }
        CascadedRowManager cascadedRowManager = (CascadedRowManager)this.m_rows;
        IntIterator intIterator = this.m_rows.rows();
        while (intIterator.hasNext()) {
            int n2 = intIterator.nextInt();
            if (this.m_rowFilter.getBoolean(this.m_parent.getTuple(cascadedRowManager.getParentRow(n2)))) continue;
            this.removeCascadedRow(n2);
        }
        Iterator iterator = this.m_parent.tuples(this.m_rowFilter);
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            int n3 = tuple.getRow();
            if (cascadedRowManager.getChildRow(n3) != -1) continue;
            this.addCascadedRow(n3);
        }
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size() + this.m_pnames.size();
    }

    public int getLocalColumnCount() {
        return this.m_columns.size();
    }

    public Table getParentTable() {
        return this.m_parent;
    }

    public int getParentRow(int n2) {
        return ((CascadedRowManager)this.m_rows).getParentRow(n2);
    }

    public int getChildRow(int n2) {
        return ((CascadedRowManager)this.m_rows).getChildRow(n2);
    }

    @Override
    public int addRow() {
        if (this.m_parent != null) {
            throw new IllegalStateException("Add row not supported for CascadedTable.");
        }
        return super.addRow();
    }

    @Override
    public void addRows(int n2) {
        if (this.m_parent != null) {
            throw new IllegalStateException("Add rows not supported for CascadedTable.");
        }
        super.addRows(n2);
    }

    @Override
    public boolean removeRow(int n2) {
        if (this.m_parent != null) {
            throw new IllegalStateException("Remove row not supported for CascadedTable.");
        }
        return super.removeRow(n2);
    }

    protected int addCascadedRow(int n2) {
        int n3 = this.m_rows.addRow();
        ((CascadedRowManager)this.m_rows).put(n3, n2);
        this.updateRowCount();
        this.fireTableEvent(n3, n3, -1, 1);
        return n3;
    }

    protected boolean removeCascadedRow(int n2) {
        boolean bl = super.removeRow(n2);
        if (bl) {
            ((CascadedRowManager)this.m_rows).remove(n2);
        }
        return bl;
    }

    @Override
    public String getColumnName(int n2) {
        int n3 = this.m_names.size();
        if (n2 >= n3) {
            return (String)this.m_pnames.get(n2 - n3);
        }
        return (String)this.m_names.get(n2);
    }

    @Override
    public int getColumnNumber(Column column) {
        int n2 = this.m_columns.indexOf(column);
        if (n2 == -1 && this.m_parent != null) {
            n2 = this.m_parent.getColumnNumber(column);
            if (n2 == -1) {
                return n2;
            }
            String string = this.m_parent.getColumnName(n2);
            if ((n2 = this.m_pnames.indexOf(string)) != -1) {
                n2 += this.m_columns.size();
            }
        }
        return n2;
    }

    @Override
    public Column getColumn(int n2) {
        this.m_lastCol = n2;
        int n3 = this.m_names.size();
        if (n2 >= n3 && this.m_parent != null) {
            return this.m_parent.getColumn((String)this.m_pnames.get(n2 - n3));
        }
        return (Column)this.m_columns.get(n2);
    }

    @Override
    protected boolean hasColumn(String string) {
        int n2 = this.getColumnNumber(string);
        return n2 >= 0 && n2 < this.getLocalColumnCount();
    }

    @Override
    protected Iterator getColumnNames() {
        if (this.m_parent == null) {
            return this.m_names.iterator();
        }
        return new CompositeIterator(this.m_names.iterator(), this.m_pnames.iterator());
    }

    @Override
    protected void invalidateSchema() {
        super.invalidateSchema();
        this.filterColumns();
    }

    private class Listener
    implements TableListener,
    ProjectionListener,
    ExpressionListener {
        private Listener() {
        }

        @Override
        public void tableChanged(Table table, int n2, int n3, int n4, int n5) {
            if (table != CascadedTable.this.m_parent) {
                return;
            }
            CascadedRowManager cascadedRowManager = (CascadedRowManager)CascadedTable.this.m_rows;
            switch (n5) {
                case 0: {
                    int n6 = -1;
                    for (int i2 = n2; i2 <= n3; ++i2) {
                        n6 = cascadedRowManager.getChildRow(i2);
                        if (n6 != -1) {
                            if (CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(i2))) {
                                int n7 = CascadedTable.this.getColumnNumber(CascadedTable.this.m_parent.getColumnName(n4));
                                if (n7 < CascadedTable.this.getLocalColumnCount()) continue;
                                CascadedTable.this.fireTableEvent(n6, n6, n7, 0);
                                continue;
                            }
                            CascadedTable.this.removeCascadedRow(n6);
                            continue;
                        }
                        if (!CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(i2)) || (n6 = cascadedRowManager.getChildRow(i2)) >= 0) continue;
                        CascadedTable.this.addCascadedRow(i2);
                    }
                    break;
                }
                case -1: {
                    if (n4 == -1) {
                        int n8 = -1;
                        for (int i3 = n2; i3 <= n3; ++i3) {
                            n8 = cascadedRowManager.getChildRow(i3);
                            if (n8 == -1) continue;
                            CascadedTable.this.removeCascadedRow(n8);
                        }
                        break;
                    }
                    CascadedTable.this.filterColumns();
                    break;
                }
                case 1: {
                    if (n4 == -1) {
                        for (int i4 = n2; i4 <= n3; ++i4) {
                            if (!CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(i4)) || cascadedRowManager.getChildRow(i4) >= 0) continue;
                            CascadedTable.this.addCascadedRow(i4);
                        }
                        break;
                    }
                    CascadedTable.this.filterColumns();
                }
            }
        }

        @Override
        public void projectionChanged(ColumnProjection columnProjection) {
            if (columnProjection == CascadedTable.this.m_colFilter) {
                CascadedTable.this.filterColumns();
            }
        }

        @Override
        public void expressionChanged(Expression expression) {
            if (expression == CascadedTable.this.m_rowFilter) {
                CascadedTable.this.filterRows();
            }
        }
    }
}

