/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.event.ColumnListener;
import com.jidesoft.thirdparty.prefuse.data.parser.DataParseException;
import com.jidesoft.thirdparty.prefuse.data.parser.DataParser;
import com.jidesoft.thirdparty.prefuse.data.parser.ObjectParser;
import com.jidesoft.thirdparty.prefuse.data.parser.ParserFactory;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;
import com.jidesoft.thirdparty.prefuse.util.collections.CopyOnWriteArrayList;
import java.math.BigDecimal;
import java.util.Date;

public abstract class AbstractColumn
implements Column {
    protected final Class m_columnType;
    protected DataParser m_parser;
    protected Object m_defaultValue;
    protected boolean m_readOnly;
    protected CopyOnWriteArrayList m_listeners;

    public AbstractColumn() {
        this(Object.class, null);
    }

    public AbstractColumn(Class clazz) {
        this(clazz, null);
    }

    public AbstractColumn(Class clazz, Object object) {
        this.m_columnType = clazz;
        DataParser dataParser = ParserFactory.getDefaultFactory().getParser(clazz);
        this.m_parser = dataParser == null ? new ObjectParser() : dataParser;
        this.setDefaultValue(object);
        this.m_readOnly = false;
        this.m_listeners = new CopyOnWriteArrayList();
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.m_readOnly = bl;
    }

    @Override
    public boolean isCellEditable(int n2) {
        return !this.m_readOnly;
    }

    @Override
    public Class getColumnType() {
        return this.m_columnType;
    }

    @Override
    public DataParser getParser() {
        return this.m_parser;
    }

    @Override
    public void setParser(DataParser dataParser) {
        if (!this.m_columnType.isAssignableFrom(dataParser.getType())) {
            throw new IllegalArgumentException("Parser type (" + dataParser.getType().getName() + ") incompatible with" + " this column's data type (" + this.m_columnType.getName() + ")");
        }
        this.m_parser = dataParser;
    }

    @Override
    public void addColumnListener(ColumnListener columnListener) {
        this.m_listeners.add(columnListener);
    }

    @Override
    public void removeColumnListener(ColumnListener columnListener) {
        this.m_listeners.remove(columnListener);
    }

    protected final void fireColumnEvent(int n2, int n3, int n4) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged(this, n2, n3, n4);
        }
    }

    protected final void fireColumnEvent(int n2, int n3) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, n3);
        }
    }

    protected final void fireColumnEvent(int n2, long l2) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, l2);
        }
    }

    protected final void fireColumnEvent(int n2, float f2) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, f2);
        }
    }

    protected final void fireColumnEvent(int n2, double d2) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, d2);
        }
    }

    protected final void fireColumnEvent(int n2, boolean bl) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, bl);
        }
    }

    protected final void fireColumnEvent(int n2, Object object) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, object);
        }
    }

    @Override
    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setDefaultValue(Object object) {
        boolean bl = this.m_columnType.isPrimitive();
        if (object != null && (!bl && !this.m_columnType.isInstance(object) || bl && !TypeLib.isWrapperInstance(this.m_columnType, object))) {
            throw new IllegalArgumentException("Default value is not of type " + this.m_columnType.getName());
        }
        this.m_defaultValue = object;
    }

    @Override
    public void revertToDefault(int n2) {
        this.set(this.m_defaultValue, n2);
    }

    @Override
    public boolean canGet(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            boolean bl = clazz.isAssignableFrom(this.m_columnType) || TypeLib.isNumericType(this.m_columnType) && TypeLib.isNumericType(clazz);
            return bl || clazz.isAssignableFrom(TypeLib.getWrapperType(this.m_columnType)) || clazz.isAssignableFrom(String.class);
        }
        if (this.m_columnType == BigDecimal.class && clazz.isPrimitive()) {
            return true;
        }
        return clazz.isAssignableFrom(this.m_columnType);
    }

    @Override
    public boolean canSet(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            return this.m_columnType.isAssignableFrom(clazz) || TypeLib.getWrapperType(this.m_columnType).isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
        }
        return this.m_columnType.isAssignableFrom(clazz);
    }

    @Override
    public boolean canGetInt() {
        return this.canGet(Integer.TYPE);
    }

    @Override
    public boolean canSetInt() {
        return this.canSet(Integer.TYPE);
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        if (this.canGetInt()) {
            return (Integer)this.get(n2);
        }
        throw new DataTypeException(Integer.TYPE);
    }

    @Override
    public void setInt(int n2, int n3) throws DataTypeException {
        if (!this.canSetInt()) {
            throw new DataTypeException(Integer.TYPE);
        }
        this.set(new Integer(n2), n3);
    }

    @Override
    public boolean canGetLong() {
        return this.canGet(Long.TYPE);
    }

    @Override
    public boolean canSetLong() {
        return this.canSet(Long.TYPE);
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        if (this.canGetLong()) {
            return (Long)this.get(n2);
        }
        throw new DataTypeException(Long.TYPE);
    }

    @Override
    public void setLong(long l2, int n2) throws DataTypeException {
        if (!this.canSetLong()) {
            throw new DataTypeException(Long.TYPE);
        }
        this.set(new Long(l2), n2);
    }

    @Override
    public boolean canGetFloat() {
        return this.canGet(Float.TYPE);
    }

    @Override
    public boolean canSetFloat() {
        return this.canSet(Float.TYPE);
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        if (this.canGetFloat()) {
            return ((Float)this.get(n2)).floatValue();
        }
        throw new DataTypeException(Float.TYPE);
    }

    @Override
    public void setFloat(float f2, int n2) throws DataTypeException {
        if (!this.canSetFloat()) {
            throw new DataTypeException(Float.TYPE);
        }
        this.set(new Float(f2), n2);
    }

    @Override
    public boolean canGetDouble() {
        return this.canGet(Double.TYPE);
    }

    @Override
    public boolean canSetDouble() {
        return this.canSet(Double.TYPE);
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        if (this.canGetDouble()) {
            Object object = this.get(n2);
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).doubleValue();
            }
            return (Double)object;
        }
        throw new DataTypeException(Double.TYPE);
    }

    @Override
    public void setDouble(double d2, int n2) throws DataTypeException {
        if (!this.canSetDouble()) {
            throw new DataTypeException(Double.TYPE);
        }
        this.set(new Double(d2), n2);
    }

    @Override
    public boolean canGetBoolean() {
        return this.canGet(Boolean.TYPE);
    }

    @Override
    public boolean canSetBoolean() {
        return this.canSet(Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(int n2) throws DataTypeException {
        if (this.canGetBoolean()) {
            return (Boolean)this.get(n2);
        }
        throw new DataTypeException(Boolean.TYPE);
    }

    @Override
    public void setBoolean(boolean bl, int n2) throws DataTypeException {
        if (!this.canSetBoolean()) {
            throw new DataTypeException(Boolean.TYPE);
        }
        this.set(new Boolean(bl), n2);
    }

    @Override
    public boolean canGetString() {
        return true;
    }

    @Override
    public boolean canSetString() {
        return this.m_parser != null && !(this.m_parser instanceof ObjectParser);
    }

    @Override
    public String getString(int n2) throws DataTypeException {
        if (this.canGetString()) {
            return this.m_parser.format(this.get(n2));
        }
        throw new DataTypeException(String.class);
    }

    @Override
    public void setString(String string, int n2) throws DataTypeException {
        try {
            this.set(this.m_parser.parse(string), n2);
        }
        catch (DataParseException dataParseException) {
            throw new DataTypeException(dataParseException);
        }
    }

    @Override
    public boolean canGetDate() {
        return this.canGet(Date.class);
    }

    @Override
    public boolean canSetDate() {
        return this.canSet(Date.class);
    }

    @Override
    public Date getDate(int n2) throws DataTypeException {
        if (this.canGetDate()) {
            return (Date)this.get(n2);
        }
        throw new DataTypeException(Date.class);
    }

    @Override
    public void setDate(Date date, int n2) throws DataTypeException {
        this.set(date, n2);
    }
}

