/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataReadOnlyException;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import java.util.Arrays;

public class DoubleColumn
extends AbstractColumn {
    private double[] m_values;
    private int m_size;

    public DoubleColumn() {
        this(0, 10, 0.0);
    }

    public DoubleColumn(int n2) {
        this(n2, n2, 0.0);
    }

    public DoubleColumn(int n2, int n3, double d2) {
        super(Double.TYPE, new Double(d2));
        if (n3 < n2) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new double[n3];
        Arrays.fill(this.m_values, d2);
        this.m_size = n2;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int n2) {
        if (n2 > this.m_values.length) {
            int n3 = Math.max(3 * this.m_values.length / 2 + 1, n2);
            double[] dArray = new double[n3];
            System.arraycopy(this.m_values, 0, dArray, 0, this.m_size);
            Arrays.fill(dArray, this.m_size, n3, (Double)this.m_defaultValue);
            this.m_values = dArray;
        }
        this.m_size = n2;
    }

    @Override
    public Object get(int n2) {
        return new Double(this.getDouble(n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setDouble(((Number)object).doubleValue(), n2);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n2);
        }
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        if (n2 < 0 || n2 > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        return this.m_values[n2];
    }

    @Override
    public void setDouble(double d2, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        double d3 = this.m_values[n2];
        if (d3 == d2) {
            return;
        }
        this.m_values[n2] = d2;
        this.fireColumnEvent(n2, d3);
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        return (int)this.getDouble(n2);
    }

    @Override
    public void setInt(int n2, int n3) throws DataTypeException {
        this.setDouble(n2, n3);
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        return (long)this.getDouble(n2);
    }

    @Override
    public void setLong(long l2, int n2) throws DataTypeException {
        this.setDouble(l2, n2);
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        return (float)this.getDouble(n2);
    }

    @Override
    public void setFloat(float f2, int n2) throws DataTypeException {
        this.setDouble(f2, n2);
    }
}

