/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.column.ColumnFactory;
import com.jidesoft.thirdparty.prefuse.data.event.ColumnListener;
import com.jidesoft.thirdparty.prefuse.data.event.ExpressionListener;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionAnalyzer;
import java.util.BitSet;
import java.util.Set;

public class ExpressionColumn
extends AbstractColumn {
    private Expression m_expr;
    private Table m_table;
    private Set m_columns;
    private BitSet m_valid;
    private Column m_cache;
    private Listener m_lstnr;

    public ExpressionColumn(Table table, Expression expression) {
        super(expression.getType(table.getSchema()));
        this.m_table = table;
        this.m_expr = expression;
        this.m_lstnr = new Listener();
        this.init();
        int n2 = this.m_table.getRowCount();
        this.m_cache = ColumnFactory.getColumn(this.getColumnType(), n2);
        this.m_valid = new BitSet(n2);
        this.m_expr.addExpressionListener(this.m_lstnr);
    }

    protected void init() {
        Column column;
        if (this.m_columns != null && this.m_columns.size() > 0) {
            for (String string : this.m_columns) {
                column = this.m_table.getColumn(string);
                column.removeColumnListener(this.m_lstnr);
            }
        }
        this.m_columns = ExpressionAnalyzer.getReferencedColumns(this.m_expr);
        for (String string : this.m_columns) {
            if (this.m_table.getColumn(string) != null) continue;
            throw new IllegalArgumentException("Table must contain all columns referenced by the expression. Bad column name: " + string);
        }
        for (String string : this.m_columns) {
            column = this.m_table.getColumn(string);
            column.addColumnListener(this.m_lstnr);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_cache.getRowCount();
    }

    @Override
    public void setMaximumRow(int n2) {
        this.m_cache.setMaximumRow(n2);
    }

    public boolean isCacheValid(int n2) {
        return this.m_valid.get(n2);
    }

    public void invalidateCache(int n2, int n3) {
        this.m_valid.clear(n2, n3 + 1);
    }

    @Override
    public void revertToDefault(int n2) {
    }

    @Override
    public boolean canSet(Class clazz) {
        return false;
    }

    @Override
    public Object get(int n2) {
        Class clazz;
        this.rangeCheck(n2);
        if (this.isCacheValid(n2)) {
            return this.m_cache.get(n2);
        }
        Object object = this.m_expr.get(this.m_table.getTuple(n2));
        Class clazz2 = clazz = object == null ? Object.class : object.getClass();
        if (this.m_cache.canSet(clazz)) {
            this.m_cache.set(object, n2);
            this.m_valid.set(n2);
        }
        return object;
    }

    @Override
    public void set(Object object, int n2) throws DataTypeException {
        throw new UnsupportedOperationException();
    }

    private void rangeCheck(int n2) {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean getBoolean(int n2) throws DataTypeException {
        if (!this.canGetBoolean()) {
            throw new DataTypeException(Boolean.TYPE);
        }
        this.rangeCheck(n2);
        if (this.isCacheValid(n2)) {
            return this.m_cache.getBoolean(n2);
        }
        boolean bl = this.m_expr.getBoolean(this.m_table.getTuple(n2));
        this.m_cache.setBoolean(bl, n2);
        this.m_valid.set(n2);
        return bl;
    }

    private void computeNumber(int n2) {
        if (this.m_columnType == Integer.TYPE) {
            this.m_cache.setInt(this.m_expr.getInt(this.m_table.getTuple(n2)), n2);
        } else if (this.m_columnType == Long.TYPE) {
            this.m_cache.setLong(this.m_expr.getLong(this.m_table.getTuple(n2)), n2);
        } else if (this.m_columnType == Float.TYPE) {
            this.m_cache.setFloat(this.m_expr.getFloat(this.m_table.getTuple(n2)), n2);
        } else {
            this.m_cache.setDouble(this.m_expr.getDouble(this.m_table.getTuple(n2)), n2);
        }
        this.m_valid.set(n2);
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        if (!this.canGetInt()) {
            throw new DataTypeException(Integer.TYPE);
        }
        this.rangeCheck(n2);
        if (!this.isCacheValid(n2)) {
            this.computeNumber(n2);
        }
        return this.m_cache.getInt(n2);
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        if (!this.canGetDouble()) {
            throw new DataTypeException(Double.TYPE);
        }
        this.rangeCheck(n2);
        if (!this.isCacheValid(n2)) {
            this.computeNumber(n2);
        }
        return this.m_cache.getDouble(n2);
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        if (!this.canGetFloat()) {
            throw new DataTypeException(Float.TYPE);
        }
        this.rangeCheck(n2);
        if (!this.isCacheValid(n2)) {
            this.computeNumber(n2);
        }
        return this.m_cache.getFloat(n2);
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        if (!this.canGetLong()) {
            throw new DataTypeException(Long.TYPE);
        }
        this.rangeCheck(n2);
        if (!this.isCacheValid(n2)) {
            this.computeNumber(n2);
        }
        return this.m_cache.getLong(n2);
    }

    private class Listener
    implements ColumnListener,
    ExpressionListener {
        private Listener() {
        }

        public void columnChanged(int n2, int n3) {
            if (n2 == n3 && ExpressionColumn.this.isCacheValid(n2)) {
                if (!ExpressionColumn.this.m_table.isValidRow(n2)) {
                    return;
                }
                ExpressionColumn.this.invalidateCache(n2, n3);
                Class clazz = ExpressionColumn.this.getColumnType();
                if (Integer.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.m_cache.getInt(n2));
                } else if (Long.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.m_cache.getLong(n2));
                } else if (Float.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.m_cache.getFloat(n2));
                } else if (Double.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.m_cache.getDouble(n2));
                } else if (Boolean.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.m_cache.getBoolean(n2));
                } else {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.m_cache.get(n2));
                }
            } else {
                ExpressionColumn.this.invalidateCache(n2, n3);
                ExpressionColumn.this.fireColumnEvent(0, n2, n3);
            }
        }

        @Override
        public void columnChanged(Column column, int n2, boolean bl) {
            this.columnChanged(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, double d2) {
            this.columnChanged(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, float f2) {
            this.columnChanged(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, int n3, int n4) {
            this.columnChanged(n3, n4);
        }

        @Override
        public void columnChanged(Column column, int n2, int n3) {
            this.columnChanged(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, long l2) {
            this.columnChanged(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, Object object) {
            this.columnChanged(n2, n2);
        }

        @Override
        public void expressionChanged(Expression expression) {
            this.columnChanged(0, ExpressionColumn.this.m_cache.getRowCount());
            ExpressionColumn.this.init();
        }
    }
}

