/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataReadOnlyException;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;

public class ObjectColumn
extends AbstractColumn {
    private Object[] m_values;
    private int m_size;

    public ObjectColumn() {
        this(Object.class);
    }

    public ObjectColumn(Class clazz) {
        this(clazz, 0, 10, null);
    }

    public ObjectColumn(int n2) {
        this(Object.class, n2, n2, null);
    }

    public ObjectColumn(Class clazz, int n2) {
        this(clazz, n2, n2, null);
    }

    public ObjectColumn(Class clazz, int n2, int n3, Object object) {
        super(clazz, object);
        if (n3 < n2) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new Object[n3];
        try {
            Cloneable cloneable = (Cloneable)object;
            Method method = cloneable.getClass().getMethod("clone", null);
            for (int i2 = 0; i2 < n3; ++i2) {
                this.m_values[i2] = method.invoke(this.m_defaultValue, null);
            }
        }
        catch (Exception exception) {
            if (object != null) {
                Logger.getLogger(this.getClass().getName()).fine("Default value of type \"" + object.getClass().getName() + "\" is not " + "cloneable. Using Object reference directly.");
            }
            Arrays.fill(this.m_values, object);
        }
        this.m_size = n2;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int n2) {
        if (n2 > this.m_values.length) {
            int n3 = Math.max(3 * this.m_values.length / 2 + 1, n2);
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.m_values, 0, objectArray, 0, this.m_size);
            try {
                Cloneable cloneable = (Cloneable)this.m_defaultValue;
                Method method = cloneable.getClass().getMethod("clone", null);
                for (int i2 = this.m_size; i2 < n3; ++i2) {
                    objectArray[i2] = method.invoke(this.m_defaultValue, null);
                }
            }
            catch (Exception exception) {
                Arrays.fill(objectArray, this.m_size, n3, this.m_defaultValue);
            }
            this.m_values = objectArray;
        }
        this.m_size = n2;
    }

    @Override
    public void revertToDefault(int n2) {
        try {
            Cloneable cloneable = (Cloneable)this.m_defaultValue;
            Method method = cloneable.getClass().getMethod("clone", null);
            this.set(method.invoke(this.m_defaultValue, null), n2);
        }
        catch (Exception exception) {
            this.set(this.m_defaultValue, n2);
        }
    }

    @Override
    public Object get(int n2) {
        if (n2 < 0 || n2 > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        return this.m_values[n2];
    }

    @Override
    public void set(Object object, int n2) {
        Object object2;
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        if (object == null || this.canSet(object.getClass())) {
            object2 = this.m_values[n2];
            if (object2 == object) {
                return;
            }
        } else {
            throw new DataTypeException(object.getClass());
        }
        this.m_values[n2] = object;
        this.fireColumnEvent(n2, object2);
    }
}

